/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.pumps;

import foxtrot.EventPump;
import foxtrot.Task;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public abstract class SunJDK14ConditionalEventPump
implements EventPump {
    private static final boolean debug = false;
    private static Class conditionalClass;
    private static Method pumpEventsMethod;
    protected static Class sequencedEventClass;

    public void pumpEvents(Task task) {
        if (task == null) {
            return;
        }
        try {
            try {
                Object conditional = Proxy.newProxyInstance(conditionalClass.getClassLoader(), new Class[]{conditionalClass}, (InvocationHandler)new Conditional(task));
                pumpEventsMethod.invoke((Object)Thread.currentThread(), conditional);
            }
            catch (InvocationTargetException x) {
                Throwable t = x.getTargetException();
                System.err.println("[SunJDK14ConditionalEventPump] Exception occurred during event dispatching:");
                t.printStackTrace();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (Error)t;
            }
            catch (Throwable x) {
                System.err.println("[SunJDK14ConditionalEventPump] PANIC: uncaught exception in Foxtrot code");
                x.printStackTrace();
                Object var5_5 = null;
                this.waitForTask(task);
            }
            Object var5_4 = null;
            this.waitForTask(task);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.waitForTask(task);
            throw throwable;
        }
    }

    protected abstract Boolean canPumpSequencedEvent(AWTEvent var1);

    private void waitForTask(Task task) {
        try {
            Task task2 = task;
            synchronized (task2) {
                while (!task.isCompleted()) {
                    task.wait();
                }
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                static /* synthetic */ Class class$foxtrot$pumps$SunJDK14ConditionalEventPump$ThrowableHandler;

                public Object run() throws ClassNotFoundException, NoSuchMethodException {
                    ClassLoader loader = ClassLoader.getSystemClassLoader();
                    conditionalClass = loader.loadClass("java.awt.Conditional");
                    sequencedEventClass = loader.loadClass("java.awt.SequencedEvent");
                    Class<?> dispatchThreadClass = loader.loadClass("java.awt.EventDispatchThread");
                    pumpEventsMethod = dispatchThreadClass.getDeclaredMethod("pumpEvents", conditionalClass);
                    ((AccessibleObject)pumpEventsMethod).setAccessible(true);
                    String property = "sun.awt.exception.handler";
                    String handler = System.getProperty(property);
                    if (handler == null) {
                        handler = (class$foxtrot$pumps$SunJDK14ConditionalEventPump$ThrowableHandler == null ? (class$foxtrot$pumps$SunJDK14ConditionalEventPump$ThrowableHandler = 1.class$("foxtrot.pumps.SunJDK14ConditionalEventPump$ThrowableHandler")) : class$foxtrot$pumps$SunJDK14ConditionalEventPump$ThrowableHandler).getName();
                        System.setProperty(property, handler);
                    }
                    return null;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
        }
        catch (Throwable x) {
            throw new Error(x.toString());
        }
    }

    public static class ThrowableHandler {
        public void handle(Throwable t) {
            System.err.println("[SunJDK14ConditionalEventPump] Exception occurred during event dispatching:");
            t.printStackTrace();
        }
    }

    private class Conditional
    implements InvocationHandler {
        private Task task;

        private Conditional(Task task) {
            this.task = task;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (!"evaluate".equals(name)) {
                throw new Error("Unknown " + conditionalClass.getName() + " method: " + name);
            }
            AWTEvent nextEvent = this.getEventQueue().peekEvent();
            if (sequencedEventClass.isInstance(nextEvent)) {
                return SunJDK14ConditionalEventPump.this.canPumpSequencedEvent(nextEvent);
            }
            return this.task.isCompleted() ? Boolean.FALSE : Boolean.TRUE;
        }

        private EventQueue getEventQueue() {
            return (EventQueue)AccessController.doPrivileged(new PrivilegedAction(this){
                private final /* synthetic */ Conditional this$1;
                {
                    this.this$1 = this$1;
                }

                public Object run() {
                    return Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
            });
        }
    }
}

