/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.HighlightJButton;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class ButtonFactory {
    private static boolean useHighlightButtons = false;
    private static boolean useButtonIcons = false;

    public static void useButtonIcons() {
        ButtonFactory.useButtonIcons(true);
    }

    public static void useButtonIcons(boolean bl) {
        if (System.getProperty("mrj.version") == null) {
            useButtonIcons = bl;
        }
    }

    public static void useHighlightButtons() {
        ButtonFactory.useHighlightButtons(true);
    }

    public static void useHighlightButtons(boolean bl) {
        if (System.getProperty("mrj.version") == null) {
            useHighlightButtons = bl;
        }
        ButtonFactory.useButtonIcons(bl);
    }

    public static JButton createButton(Icon icon, Color color) {
        if (useHighlightButtons) {
            if (useButtonIcons) {
                return new HighlightJButton(icon, color);
            }
            return new HighlightJButton("", color);
        }
        if (useButtonIcons) {
            return new JButton(icon);
        }
        return new JButton();
    }

    public static JButton createButton(String string, Color color) {
        if (useHighlightButtons) {
            return new HighlightJButton(string, color);
        }
        return new JButton(string);
    }

    public static JButton createButton(String string, Icon icon, Color color) {
        if (useHighlightButtons) {
            if (useButtonIcons) {
                return new HighlightJButton(string, icon, color);
            }
            return new HighlightJButton(string, color);
        }
        if (useButtonIcons) {
            return new JButton(string, icon);
        }
        return new JButton(string);
    }

    public static JButton createButton(Action action, Color color) {
        if (useHighlightButtons) {
            return new HighlightJButton(action, color);
        }
        return new JButton(action);
    }
}

