// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Summary represents the type of a metric that is calculated by aggregating as a Summary of all reported double measurements over a time interval.
type Summary struct {
	DataPoints []*SummaryDataPoint
}

var (
	protoPoolSummary = sync.Pool{
		New: func() any {
			return &Summary{}
		},
	}
)

func NewSummary() *Summary {
	if !UseProtoPooling.IsEnabled() {
		return &Summary{}
	}
	return protoPoolSummary.Get().(*Summary)
}

func DeleteSummary(orig *Summary, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.DataPoints {
		DeleteSummaryDataPoint(orig.DataPoints[i], true)
	}
	orig.Reset()
	if nullable {
		protoPoolSummary.Put(orig)
	}
}

func CopySummary(dest, src *Summary) *Summary {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSummary()
	}
	dest.DataPoints = CopySummaryDataPointPtrSlice(dest.DataPoints, src.DataPoints)

	return dest
}

func CopySummarySlice(dest, src []Summary) []Summary {
	var newDest []Summary
	if cap(dest) < len(src) {
		newDest = make([]Summary, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSummary(&dest[i], false)
		}
	}
	for i := range src {
		CopySummary(&newDest[i], &src[i])
	}
	return newDest
}

func CopySummaryPtrSlice(dest, src []*Summary) []*Summary {
	var newDest []*Summary
	if cap(dest) < len(src) {
		newDest = make([]*Summary, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSummary()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSummary(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSummary()
		}
	}
	for i := range src {
		CopySummary(newDest[i], src[i])
	}
	return newDest
}

func (orig *Summary) Reset() {
	*orig = Summary{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Summary) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		orig.DataPoints[0].MarshalJSON(dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			orig.DataPoints[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Summary) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "dataPoints", "data_points":
			for iter.ReadArray() {
				orig.DataPoints = append(orig.DataPoints, NewSummaryDataPoint())
				orig.DataPoints[len(orig.DataPoints)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *Summary) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = orig.DataPoints[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *Summary) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.DataPoints) - 1; i >= 0; i-- {
		l = orig.DataPoints[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *Summary) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DataPoints = append(orig.DataPoints, NewSummaryDataPoint())
			err = orig.DataPoints[len(orig.DataPoints)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSummary() *Summary {
	orig := NewSummary()
	orig.DataPoints = []*SummaryDataPoint{{}, GenTestSummaryDataPoint()}
	return orig
}

func GenTestSummaryPtrSlice() []*Summary {
	orig := make([]*Summary, 5)
	orig[0] = NewSummary()
	orig[1] = GenTestSummary()
	orig[2] = NewSummary()
	orig[3] = GenTestSummary()
	orig[4] = NewSummary()
	return orig
}

func GenTestSummarySlice() []Summary {
	orig := make([]Summary, 5)
	orig[1] = *GenTestSummary()
	orig[3] = *GenTestSummary()
	return orig
}
