/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class ReloadableResourceBundleMessageSource
extends AbstractMessageSource
implements ResourceLoaderAware {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    private String[] basenames = new String[0];
    private String defaultEncoding;
    private Properties fileEncodings;
    private boolean fallbackToSystemLocale = true;
    private long cacheMillis = -1L;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final Map cachedFilenames = new HashMap();
    private final Map cachedProperties = new HashMap();
    private final Map cachedMergedProperties = new HashMap();

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            for (int i = 0; i < basenames.length; ++i) {
                String basename = basenames[i];
                Assert.hasText(basename, "Basename must not be empty");
                this.basenames[i] = basename.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setFileEncodings(Properties fileEncodings) {
        this.fileEncodings = fileEncodings;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = cacheSeconds * 1000;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            String result = propHolder.getProperty(code);
            if (result != null) {
                return result;
            }
        } else {
            for (int i = 0; i < this.basenames.length; ++i) {
                List filenames = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = 0; j < filenames.size(); ++j) {
                    String filename = (String)filenames.get(j);
                    PropertiesHolder propHolder = this.getProperties(filename);
                    String result = propHolder.getProperty(code);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            MessageFormat result = propHolder.getMessageFormat(code, locale);
            if (result != null) {
                return result;
            }
        } else {
            for (int i = 0; i < this.basenames.length; ++i) {
                List filenames = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = 0; j < filenames.size(); ++j) {
                    String filename = (String)filenames.get(j);
                    PropertiesHolder propHolder = this.getProperties(filename);
                    MessageFormat result = propHolder.getMessageFormat(code, locale);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getMergedProperties(Locale locale) {
        Map map = this.cachedMergedProperties;
        synchronized (map) {
            PropertiesHolder mergedHolder = (PropertiesHolder)this.cachedMergedProperties.get(locale);
            if (mergedHolder != null) {
                return mergedHolder;
            }
            Properties mergedProps = new Properties();
            mergedHolder = new PropertiesHolder(mergedProps, -1L);
            for (int i = this.basenames.length - 1; i >= 0; --i) {
                List filenames = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = filenames.size() - 1; j >= 0; --j) {
                    String filename = (String)filenames.get(j);
                    PropertiesHolder propHolder = this.getProperties(filename);
                    if (propHolder.getProperties() == null) continue;
                    mergedProps.putAll((Map<?, ?>)propHolder.getProperties());
                }
            }
            this.cachedMergedProperties.put(locale, mergedHolder);
            return mergedHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List calculateAllFilenames(String basename, Locale locale) {
        Map map = this.cachedFilenames;
        synchronized (map) {
            ArrayList<String> filenames;
            HashMap localeMap = (HashMap)this.cachedFilenames.get(basename);
            if (localeMap != null && (filenames = (ArrayList<String>)localeMap.get(locale)) != null) {
                return filenames;
            }
            filenames = new ArrayList<String>(7);
            filenames.addAll(this.calculateFilenamesForLocale(basename, locale));
            if (this.fallbackToSystemLocale && !locale.equals(Locale.getDefault())) {
                List fallbackFilenames = this.calculateFilenamesForLocale(basename, Locale.getDefault());
                Iterator it = fallbackFilenames.iterator();
                while (it.hasNext()) {
                    String fallbackFilename = (String)it.next();
                    if (filenames.contains(fallbackFilename)) continue;
                    filenames.add(fallbackFilename);
                }
            }
            filenames.add(basename);
            if (localeMap != null) {
                localeMap.put(locale, filenames);
            } else {
                localeMap = new HashMap();
                localeMap.put(locale, filenames);
                this.cachedFilenames.put(basename, localeMap);
            }
            return filenames;
        }
    }

    protected List calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer temp = new StringBuffer(basename);
        if (language.length() > 0) {
            temp.append('_').append(language);
            result.add(0, temp.toString());
        }
        if (country.length() > 0) {
            temp.append('_').append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getProperties(String filename) {
        Map map = this.cachedProperties;
        synchronized (map) {
            PropertiesHolder propHolder = (PropertiesHolder)this.cachedProperties.get(filename);
            if (propHolder != null && (propHolder.getRefreshTimestamp() < 0L || propHolder.getRefreshTimestamp() > System.currentTimeMillis() - this.cacheMillis)) {
                return propHolder;
            }
            return this.refreshProperties(filename, propHolder);
        }
    }

    protected PropertiesHolder refreshProperties(String filename, PropertiesHolder propHolder) {
        long refreshTimestamp = this.cacheMillis < 0L ? -1L : System.currentTimeMillis();
        Resource resource = this.resourceLoader.getResource(filename + PROPERTIES_SUFFIX);
        if (!resource.exists()) {
            resource = this.resourceLoader.getResource(filename + XML_SUFFIX);
        }
        if (resource.exists()) {
            long fileTimestamp = -1L;
            if (this.cacheMillis >= 0L) {
                try {
                    fileTimestamp = resource.lastModified();
                    if (propHolder != null && propHolder.getFileTimestamp() == fileTimestamp) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Re-caching properties for filename [" + filename + "] - file hasn't been modified");
                        }
                        propHolder.setRefreshTimestamp(refreshTimestamp);
                        return propHolder;
                    }
                }
                catch (IOException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(resource + " could not be resolved in the file system - assuming that is hasn't changed", ex);
                    }
                    fileTimestamp = -1L;
                }
            }
            try {
                Properties props = this.loadProperties(resource, filename);
                propHolder = new PropertiesHolder(props, fileTimestamp);
            }
            catch (IOException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Could not parse properties file [" + resource.getFilename() + "]", ex);
                }
                propHolder = new PropertiesHolder();
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No properties file found for [" + filename + "] - neither plain properties nor XML");
            }
            propHolder = new PropertiesHolder();
        }
        propHolder.setRefreshTimestamp(refreshTimestamp);
        this.cachedProperties.put(filename, propHolder);
        return propHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(Resource resource, String filename) throws IOException {
        Properties properties;
        InputStream is = resource.getInputStream();
        Properties props = new Properties();
        try {
            if (resource.getFilename().endsWith(XML_SUFFIX)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loading properties [" + resource.getFilename() + "]");
                }
                this.propertiesPersister.loadFromXml(props, is);
            } else {
                String encoding = null;
                if (this.fileEncodings != null) {
                    encoding = this.fileEncodings.getProperty(filename);
                }
                if (encoding == null) {
                    encoding = this.defaultEncoding;
                }
                if (encoding != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Loading properties [" + resource.getFilename() + "] with encoding '" + encoding + "'");
                    }
                    this.propertiesPersister.load(props, new InputStreamReader(is, encoding));
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Loading properties [" + resource.getFilename() + "]");
                    }
                    this.propertiesPersister.load(props, is);
                }
            }
            properties = props;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug("Clearing entire resource bundle cache");
        Map map = this.cachedProperties;
        synchronized (map) {
            this.cachedProperties.clear();
        }
        map = this.cachedMergedProperties;
        synchronized (map) {
            this.cachedMergedProperties.clear();
        }
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        if (this.getParentMessageSource() instanceof ReloadableResourceBundleMessageSource) {
            ((ReloadableResourceBundleMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }

    protected class PropertiesHolder {
        private Properties properties;
        private long fileTimestamp = -1L;
        private long refreshTimestamp = -1L;
        private final Map cachedMessageFormats = new HashMap();

        public PropertiesHolder(Properties properties, long fileTimestamp) {
            this.properties = properties;
            this.fileTimestamp = fileTimestamp;
        }

        public PropertiesHolder() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public long getFileTimestamp() {
            return this.fileTimestamp;
        }

        public void setRefreshTimestamp(long refreshTimestamp) {
            this.refreshTimestamp = refreshTimestamp;
        }

        public long getRefreshTimestamp() {
            return this.refreshTimestamp;
        }

        public String getProperty(String code) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.getProperty(code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageFormat getMessageFormat(String code, Locale locale) {
            if (this.properties == null) {
                return null;
            }
            Map map = this.cachedMessageFormats;
            synchronized (map) {
                MessageFormat result;
                HashMap<Locale, MessageFormat> localeMap = (HashMap<Locale, MessageFormat>)this.cachedMessageFormats.get(code);
                if (localeMap != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                    return result;
                }
                String msg = this.properties.getProperty(code);
                if (msg != null) {
                    if (localeMap == null) {
                        localeMap = new HashMap<Locale, MessageFormat>();
                        this.cachedMessageFormats.put(code, localeMap);
                    }
                    MessageFormat result2 = ReloadableResourceBundleMessageSource.this.createMessageFormat(msg, locale);
                    localeMap.put(locale, result2);
                    return result2;
                }
                return null;
            }
        }
    }
}

