/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;

public abstract class JvmTreeHeapAbstractState<StateT extends LatticeAbstractState<StateT>>
implements JvmHeapAbstractState<StateT> {
    protected final MapAbstractState<Reference, HeapNode<StateT>> referenceToNode;

    public JvmTreeHeapAbstractState() {
        this(new MapAbstractState<Reference, HeapNode<StateT>>());
    }

    protected JvmTreeHeapAbstractState(MapAbstractState<Reference, HeapNode<StateT>> referenceToNode) {
        this.referenceToNode = referenceToNode;
    }

    @Override
    protected StateT getField(SetAbstractState<Reference> object, String descriptor, StateT defaultValue) {
        return (StateT)object.stream().reduce(defaultValue, (result, reference) -> result.join(this.referenceToNode.containsKey(reference) ? ((HeapNode)this.referenceToNode.get(reference)).getValueOrDefault(descriptor, defaultValue) : defaultValue), LatticeAbstractState::join);
    }

    @Override
    protected void setField(SetAbstractState<Reference> object, String descriptor, StateT value) {
        if (object.size() <= 1) {
            object.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode()).setValue(descriptor, value));
        } else {
            object.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode()).mergeValue(descriptor, value));
        }
    }

    @Override
    protected StateT getArrayElementOrDefault(SetAbstractState<Reference> array, StateT index, StateT defaultValue) {
        return (StateT)array.stream().reduce(defaultValue, (result, reference) -> result.join(this.referenceToNode.containsKey(reference) ? ((HeapNode)this.referenceToNode.get(reference)).getValueOrDefault("[]", defaultValue) : defaultValue), LatticeAbstractState::join);
    }

    @Override
    protected void setArrayElement(SetAbstractState<Reference> array, StateT index, StateT value) {
        array.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode()).mergeValue("[]", value));
    }

    @Override
    public boolean isLessOrEqual(JvmHeapAbstractState<StateT> abstractState) {
        return abstractState instanceof JvmTreeHeapAbstractState && this.referenceToNode.isLessOrEqual(((JvmTreeHeapAbstractState)abstractState).referenceToNode);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JvmTreeHeapAbstractState)) {
            return false;
        }
        return this.referenceToNode.equals(((JvmTreeHeapAbstractState)obj).referenceToNode);
    }

    @Override
    public int hashCode() {
        return this.referenceToNode.hashCode();
    }
}

