/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure.callgraph;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.MethodSignature;

public class EntryPoint {
    public static final List<EntryPoint> ENTRY_POINTS_ACTIVITY = Arrays.asList(new EntryPoint(Type.ACTIVITY, "android.app.Activity", "<clinit>"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "<init>"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onCreate"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onStart"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onRestart"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onResume"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onPause"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onStop"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onDestroy"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onAttachFragment"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onContentChanged"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onActivityResult"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onRestoreInstanceState"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onPostCreate"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onPostResume"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onAttachedToWindow"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onCreateOptionsMenu"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onPrepareOptionsMenu"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onUserInteraction"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onUserLeaveHint"), new EntryPoint(Type.ACTIVITY, "android.app.Activity", "onSaveInstanceState"));
    public static final List<EntryPoint> ENTRY_POINTS_FRAGMENT = Arrays.asList(new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "<clinit>"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "<init>"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onInflate"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onAttach"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onCreate"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onCreateView"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onViewCreated"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onActivityCreated"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onViewStateRestored"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onStart"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onResume"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onCreateOptionsMenu"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onPrepareOptionsMenu"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onPause"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onSaveInstanceState"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onStop"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onDestroyView"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onDestroy"), new EntryPoint(Type.ACTIVITY, "android.app.Fragment", "onDetach"));
    public static final List<EntryPoint> ENTRY_POINTS_SERVICE = Arrays.asList(new EntryPoint(Type.SERVICE, "android.app.Service", "<clinit>"), new EntryPoint(Type.SERVICE, "android.app.Service", "<init>"), new EntryPoint(Type.SERVICE, "android.app.Service", "onCreate"), new EntryPoint(Type.SERVICE, "android.app.Service", "onStartCommand"), new EntryPoint(Type.SERVICE, "android.app.Service", "onBind"), new EntryPoint(Type.SERVICE, "android.app.Service", "onUnbind"), new EntryPoint(Type.SERVICE, "android.app.Service", "onRebind"), new EntryPoint(Type.SERVICE, "android.app.Service", "onDestroy"));
    public static final List<EntryPoint> ENTRY_POINTS_BROADCAST_RECEIVER = Arrays.asList(new EntryPoint(Type.BROADCAST_RECEIVER, "android.content.BroadcastReceiver", "<clinit>"), new EntryPoint(Type.BROADCAST_RECEIVER, "android.content.BroadcastReceiver", "<init>"), new EntryPoint(Type.BROADCAST_RECEIVER, "android.content.BroadcastReceiver", "onReceive"));
    public static final List<EntryPoint> ENTRY_POINTS_CONTENT_PROVIDER = Arrays.asList(new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "<clinit>"), new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "<init>"), new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "onCreate"), new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "query"), new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "insert"), new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "update"), new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "delete"), new EntryPoint(Type.CONTENT_PROVIDER, "android.content.ContentProvider", "getType"));
    public static final List<EntryPoint> WELL_KNOWN_ENTRYPOINTS = Stream.of(ENTRY_POINTS_ACTIVITY, ENTRY_POINTS_FRAGMENT, ENTRY_POINTS_SERVICE, ENTRY_POINTS_BROADCAST_RECEIVER, ENTRY_POINTS_CONTENT_PROVIDER).flatMap(Collection::stream).collect(Collectors.toList());
    public static final Set<String> WELL_KNOWN_ENTRYPOINT_CLASSES = WELL_KNOWN_ENTRYPOINTS.stream().map(e -> e.className).collect(Collectors.toSet());
    public final String className;
    public final String methodName;
    public final Type type;

    public EntryPoint(Type type, String className, String methodName) {
        this.type = type;
        this.className = className;
        this.methodName = methodName;
    }

    public MethodSignature toSignature() {
        return new MethodSignature(this.className.replace('.', '/'), this.methodName, (MethodDescriptor)null);
    }

    public String toString() {
        return this.toSignature().toString() + " (" + (Object)((Object)this.type) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryPoint that = (EntryPoint)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName);
    }

    public static enum Type {
        ACTIVITY,
        SERVICE,
        BROADCAST_RECEIVER,
        CONTENT_PROVIDER;

    }
}

