/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.util.ArrayUtil;

public class StackSizeComputer
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final Logger logger = LogManager.getLogger(StackSizeComputer.class);
    private boolean[] evaluated = new boolean[8096];
    private int[] stackSizesBefore = new int[8096];
    private int[] stackSizesAfter = new int[8096];
    private boolean exitInstructionBlock;
    private int stackSize;
    private int maxStackSize;

    public boolean isReachable(int instructionOffset) {
        return this.evaluated[instructionOffset];
    }

    public int getStackSizeBefore(int instructionOffset) {
        if (!this.evaluated[instructionOffset]) {
            throw new IllegalArgumentException("Unknown stack size before unreachable instruction offset [" + instructionOffset + "]");
        }
        return this.stackSizesBefore[instructionOffset];
    }

    public int getStackSizeAfter(int instructionOffset) {
        if (!this.evaluated[instructionOffset]) {
            throw new IllegalArgumentException("Unknown stack size after unreachable instruction offset [" + instructionOffset + "]");
        }
        return this.stackSizesAfter[instructionOffset];
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            logger.error("Unexpected error while computing stack sizes:");
            logger.error("  Class       = [{}]", (Object)clazz.getName());
            logger.error("  Method      = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
            logger.error("  Exception   = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        this.evaluated = ArrayUtil.ensureArraySize(this.evaluated, codeLength, false);
        this.stackSizesBefore = ArrayUtil.ensureArraySize(this.stackSizesBefore, codeLength, 0);
        this.stackSizesAfter = ArrayUtil.ensureArraySize(this.stackSizesAfter, codeLength, 0);
        this.stackSize = 0;
        this.maxStackSize = 0;
        this.evaluateInstructionBlock(clazz, method, codeAttribute, 0);
        codeAttribute.exceptionsAccept(clazz, method, this);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        byte opcode = simpleInstruction.opcode;
        this.exitInstructionBlock = opcode == -84 || opcode == -83 || opcode == -82 || opcode == -81 || opcode == -80 || opcode == -79 || opcode == -65;
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.exitInstructionBlock = false;
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        byte opcode = variableInstruction.opcode;
        this.exitInstructionBlock = opcode == -87;
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        this.evaluateInstructionBlock(clazz, method, codeAttribute, offset + branchInstruction.branchOffset);
        if (opcode == -88 || opcode == -55) {
            --this.stackSize;
            this.evaluateInstructionBlock(clazz, method, codeAttribute, offset + branchInstruction.length(offset));
        }
        this.exitInstructionBlock = opcode == -89 || opcode == -56 || opcode == -88 || opcode == -55;
    }

    @Override
    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
        int[] jumpOffsets = switchInstruction.jumpOffsets;
        for (int index = 0; index < jumpOffsets.length; ++index) {
            this.evaluateInstructionBlock(clazz, method, codeAttribute, offset + jumpOffsets[index]);
        }
        this.evaluateInstructionBlock(clazz, method, codeAttribute, offset + switchInstruction.defaultOffset);
        this.exitInstructionBlock = true;
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.stackSize = 1;
        this.evaluateInstructionBlock(clazz, method, codeAttribute, exceptionInfo.u2handlerPC);
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, int instructionOffset) {
        int initialStackSize = this.stackSize;
        if (this.maxStackSize < this.stackSize) {
            this.maxStackSize = this.stackSize;
        }
        while (!this.evaluated[instructionOffset]) {
            this.evaluated[instructionOffset] = true;
            this.stackSizesBefore[instructionOffset] = this.stackSize;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, instructionOffset);
            this.stackSize -= instruction.stackPopCount(clazz);
            if (this.stackSize < 0) {
                throw new IllegalArgumentException("Stack size becomes negative after instruction " + instruction.toString(clazz, instructionOffset) + " in [" + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            }
            this.stackSize += instruction.stackPushCount(clazz);
            this.stackSizesAfter[instructionOffset] = this.stackSize;
            if (this.maxStackSize < this.stackSize) {
                this.maxStackSize = this.stackSize;
            }
            int nextInstructionOffset = instructionOffset + instruction.length(instructionOffset);
            instruction.accept(clazz, method, codeAttribute, instructionOffset, this);
            if (this.exitInstructionBlock) break;
            instructionOffset = nextInstructionOffset;
        }
        this.stackSize = initialStackSize;
    }
}

