/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.visitor.ClassCleaner;
import proguard.pass.Pass;
import proguard.util.PrintWriterUtil;

public class ObfuscationPreparation
implements Pass {
    private static final Logger logger = LogManager.getLogger(ObfuscationPreparation.class);
    private final Configuration configuration;

    public ObfuscationPreparation(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws IOException {
        if (this.configuration.applyMapping != null) {
            logger.info("Applying mapping from [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.applyMapping));
        }
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        appView.programClassPool.classesAccept(new ClassCleaner());
        appView.libraryClassPool.classesAccept(new ClassCleaner());
    }
}

