/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.io.File;
import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.SettableMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.VariableStringMatcher;
import proguard.util.WildcardManager;

public class FileNameParser
implements StringParser {
    private final WildcardManager wildcardManager;

    public FileNameParser() {
        this(null);
    }

    public FileNameParser(WildcardManager wildcardManager) {
        this.wildcardManager = wildcardManager;
    }

    @Override
    public StringMatcher parse(String regularExpression) {
        int index;
        StringMatcher nextMatcher = new EmptyStringMatcher();
        for (index = 0; index < regularExpression.length(); ++index) {
            if (regularExpression.regionMatches(index, "**", 0, 2)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                VariableStringMatcher variableStringMatcher = new VariableStringMatcher(null, null, 0, Integer.MAX_VALUE, settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 2)));
                nextMatcher = variableStringMatcher;
                break;
            }
            if (regularExpression.charAt(index) == '*') {
                SettableMatcher settableMatcher = new SettableMatcher();
                VariableStringMatcher variableStringMatcher = new VariableStringMatcher(null, new char[]{File.pathSeparatorChar, '/'}, 0, Integer.MAX_VALUE, settableMatcher);
                if (this.wildcardManager != null) {
                    this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
                }
                settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
                nextMatcher = variableStringMatcher;
                break;
            }
            if (regularExpression.charAt(index) != '?') continue;
            SettableMatcher settableMatcher = new SettableMatcher();
            VariableStringMatcher variableStringMatcher = new VariableStringMatcher(null, new char[]{File.pathSeparatorChar, '/'}, 1, 1, settableMatcher);
            if (this.wildcardManager != null) {
                this.wildcardManager.rememberVariableStringMatcher(variableStringMatcher);
            }
            settableMatcher.setMatcher(this.parse(regularExpression.substring(index + 1)));
            nextMatcher = variableStringMatcher;
            break;
        }
        return index != 0 ? new FixedStringMatcher(regularExpression.substring(0, index), nextMatcher) : nextMatcher;
    }

    public static void main(String[] args2) {
        try {
            System.out.println("Regular expression [" + args2[0] + "]");
            FileNameParser parser = new FileNameParser();
            StringMatcher matcher = parser.parse(args2[0]);
            for (int index = 1; index < args2.length; ++index) {
                String string = args2[index];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + matcher.matches(args2[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

