## Software Modules Packaged with FSP

### FSP Top Level Modules
  * Analog
    * [ADC (r_adc)](https://renesas.github.io/fsp/group___a_d_c.html)
    * [ADC (r_sdadc)](https://renesas.github.io/fsp/group___s_d_a_d_c.html)
    * [ADC Driver on r_adc_b](https://renesas.github.io/fsp/group___a_d_c___b.html)
    * [ADC-DMAC Integration (r_adc)](https://renesas.github.io/fsp/group___a_d_c.html)
    * [Comparator, High-Speed (r_acmphs)](https://renesas.github.io/fsp/group___a_c_m_p_h_s.html)
    * [Comparator, Low-Power (r_acmplp)](https://renesas.github.io/fsp/group___a_c_m_p_l_p.html)
    * [DAC (r_dac)](https://renesas.github.io/fsp/group___d_a_c.html)
    * [DAC8 (r_dac8)](https://renesas.github.io/fsp/group___d_a_c8.html)
    * [Operational Amplifier (r_opamp)](https://renesas.github.io/fsp/group___o_p_a_m_p.html)
  * Artificial Intelligence
    * [Arm CMSIS5 NN Library Source](https://arm-software.github.io/CMSIS-NN/latest/index.html)
  * Audio
    * [ADPCM Decoder (rm_adpcm_decoder)](https://renesas.github.io/fsp/group___r_m___a_d_p_c_m___d_e_c_o_d_e_r.html)
    * [Audio Playback PWM (rm_audio_playback_pwm)](https://renesas.github.io/fsp/group___r_m___a_u_d_i_o___p_l_a_y_b_a_c_k___p_w_m.html)
  * Bootloader
    * [MCUboot](https://github.com/mcu-tools/mcuboot)
    * [MCUboot Image Utilities](https://renesas.github.io/fsp/group___r_m___m_c_u_b_o_o_t___p_o_r_t.html)
  * CapTouch
    * [CTSU (r_ctsu)](https://renesas.github.io/fsp/group___c_t_s_u.html)
    * [Touch (rm_touch)](https://renesas.github.io/fsp/group___t_o_u_c_h.html)
  * Connectivity
    * [Azure RTOS USBX DFU](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX HCDC](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX HHID](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX HPRN](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX HUVC](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX OTG CDC](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX OTG HID](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX PAUD](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX PCDC](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX PHID](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX PMSC](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX PPRN](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [CAN (r_can)](https://renesas.github.io/fsp/group___c_a_n.html)
    * [CAN FD (r_canfd)](https://renesas.github.io/fsp/group___c_a_n_f_d.html)
    * [CAN FD Lite (r_canfdlite)](https://renesas.github.io/fsp/group___c_a_n_f_d.html)
    * [CEC (r_cec)](https://renesas.github.io/fsp/group___c_e_c.html)
    * [I2C Communication Device (rm_comms_i2c)](https://renesas.github.io/fsp/group___r_m___c_o_m_m_s___i2_c.html)
    * [I2C Master (r_iic_b_master)](https://renesas.github.io/fsp/group___i_i_c___m_a_s_t_e_r.html)
    * [I2C Master (r_iic_master)](https://renesas.github.io/fsp/group___i_i_c___m_a_s_t_e_r.html)
    * [I2C Master (r_sci_b_i2c)](https://renesas.github.io/fsp/group___s_c_i___b___i2_c.html)
    * [I2C Master (r_sci_i2c)](https://renesas.github.io/fsp/group___s_c_i___i2_c.html)
    * [I2C Shared Bus (rm_comms_i2c)](https://renesas.github.io/fsp/group___r_m___c_o_m_m_s___i2_c.html)
    * [I2C Slave (r_iic_b_slave)](https://renesas.github.io/fsp/group___i_i_c___s_l_a_v_e.html)
    * [I2C Slave (r_iic_slave)](https://renesas.github.io/fsp/group___i_i_c___s_l_a_v_e.html)
    * [I2S (r_ssi)](https://renesas.github.io/fsp/group___s_s_i.html)
    * [I3C (r_i3c)](https://renesas.github.io/fsp/group___i3_c.html)
    * [SPI (r_sci_b_spi)](https://renesas.github.io/fsp/group___s_c_i___b___s_p_i.html)
    * [SPI (r_sci_spi)](https://renesas.github.io/fsp/group___s_c_i___s_p_i.html)
    * [SPI (r_spi)](https://renesas.github.io/fsp/group___s_p_i.html)
    * [SPI (r_spi_b)](https://renesas.github.io/fsp/group___s_p_i___b.html)
    * [UART (r_sci_b_uart)](https://renesas.github.io/fsp/group___s_c_i___b___u_a_r_t.html)
    * [UART (r_sci_uart)](https://renesas.github.io/fsp/group___s_c_i___u_a_r_t.html)
    * [USB Composite (r_usb_composite)](https://renesas.github.io/fsp/group___u_s_b.html)
    * [USB HCDC (r_usb_hcdc)](https://renesas.github.io/fsp/group___u_s_b___h_c_d_c.html)
    * [USB HHID (r_usb_hhid)](https://renesas.github.io/fsp/group___u_s_b___h_h_i_d.html)
    * [USB HMSC (r_usb_hmsc)](https://renesas.github.io/fsp/group___u_s_b___h_m_s_c.html)
    * [USB Host Vendor class (r_usb_hvnd)](https://renesas.github.io/fsp/group___u_s_b___h_v_n_d.html)
    * [USB PCDC (r_usb_pcdc)](https://renesas.github.io/fsp/group___u_s_b___p_c_d_c.html)
    * [USB PHID (r_usb_phid)](https://renesas.github.io/fsp/group___u_s_b___p_h_i_d.html)
    * [USB PMSC (r_usb_pmsc)](https://renesas.github.io/fsp/group___u_s_b___p_m_s_c.html)
    * [USB PPRN (r_usb_pprn)](https://renesas.github.io/fsp/group___u_s_b___p_p_r_n.html)
    * [USB PVND (r_usb_pvnd)](https://renesas.github.io/fsp/group___u_s_b___p_v_n_d.html)
  * DSP
    * [Arm CMSIS5 DSP Library Source](http://www.keil.com/pack/doc/CMSIS/DSP/html/index.html)
    * [IIR Filter Accelerator (r_iirfa)](https://renesas.github.io/fsp/group___i_i_r_f_a.html)
  * Graphics
    * [Azure RTOS GUIX](https://docs.microsoft.com/en-us/azure/rtos/guix/)
    * [D/AVE 2D (r_drw)](https://www.tes-dst.com/technology-products/gpus/d/ave-2d/)
    * [D/AVE 2D Port Interface (r_drw)](https://renesas.github.io/fsp/group___d_r_w.html)
    * [Graphics LCD (r_glcdc)](https://renesas.github.io/fsp/group___g_l_c_d_c.html)
    * [JPEG Codec (r_jpeg)](https://renesas.github.io/fsp/group___j_p_e_g.html)
    * [Parallel Data Capture (r_pdc)](https://renesas.github.io/fsp/group___p_d_c.html)
    * [SEGGER emWin](https://www.segger.com/products/user-interface/emwin/)
    * [Segment LCD (r_slcdc)](https://renesas.github.io/fsp/group___s_l_c_d_c.html)
  * Input
    * [External IRQ (r_icu)](https://renesas.github.io/fsp/group___i_c_u.html)
    * [Key Matrix (r_kint)](https://renesas.github.io/fsp/group___k_i_n_t.html)
  * Monitoring
    * [CRC (r_crc)](https://renesas.github.io/fsp/group___c_r_c.html)
    * [Clock Accuracy Circuit (r_cac)](https://renesas.github.io/fsp/group___c_a_c.html)
    * [Data Operation Circuit (r_doc)](https://renesas.github.io/fsp/group___d_o_c.html)
    * [Independent Watchdog (r_iwdt)](https://renesas.github.io/fsp/group___i_w_d_t.html)
    * [Low Voltage Detection (r_lvd)](https://renesas.github.io/fsp/group___l_v_d.html)
    * [Watchdog (r_wdt)](https://renesas.github.io/fsp/group___w_d_t.html)
  * Motor
    * [120-degree conduction control sensorless (rm_motor_120_control_sensorless)](https://renesas.github.io/fsp/group___m_o_t_o_r__120___c_o_n_t_r_o_l___s_e_n_s_o_r_l_e_s_s.html)
    * [120-degree conduction control with Hall sensors (rm_motor_120_control_hall)](https://renesas.github.io/fsp/group___m_o_t_o_r__120___c_o_n_t_r_o_l___h_a_l_l.html)
    * [ADC and PWM Modulation (rm_motor_driver)](https://renesas.github.io/fsp/group___m_o_t_o_r___d_r_i_v_e_r.html)
    * [ADC and PWM modulation (rm_motor_120_driver)](https://renesas.github.io/fsp/group___m_o_t_o_r__120___d_r_i_v_e_r.html)
    * [Motor 120 degree control (rm_motor_120_degree)](https://renesas.github.io/fsp/group___m_o_t_o_r__120___d_e_g_r_e_e.html)
    * [Motor Angle and Speed Calculation with Hall sensors (rm_motor_sense_hall)](https://renesas.github.io/fsp/group___m_o_t_o_r___s_e_n_s_e___h_a_l_l.html)
    * [Motor Angle and Speed Calculation with encoder (rm_motor_sense_encoder)](https://renesas.github.io/fsp/group___m_o_t_o_r___s_e_n_s_e___e_n_c_o_d_e_r.html)
    * [Motor Angle and Speed Calculation with induction sensor (rm_motor_sense_induction)](https://renesas.github.io/fsp/group___m_o_t_o_r___s_e_n_s_e___i_n_d_u_c_t_i_o_n.html)
    * [Motor Angle and Speed Estimation (rm_motor_estimate)](https://renesas.github.io/fsp/group___m_o_t_o_r___e_s_t_i_m_a_t_e.html)
    * [Motor Current Controller (rm_motor_current)](https://renesas.github.io/fsp/group___m_o_t_o_r___c_u_r_r_e_n_t.html)
    * [Motor Encoder Vector Control (rm_motor_encoder)](https://renesas.github.io/fsp/group___m_o_t_o_r___e_n_c_o_d_e_r.html)
    * [Motor Position Controller (rm_motor_position)](https://renesas.github.io/fsp/group___m_o_t_o_r___p_o_s_i_t_i_o_n.html)
    * [Motor Sensorless Vector Control (rm_motor_sensorless)](https://renesas.github.io/fsp/group___m_o_t_o_r___s_e_n_s_o_r_l_e_s_s.html)
    * [Motor Speed Controller (rm_motor_speed)](https://renesas.github.io/fsp/group___m_o_t_o_r___s_p_e_e_d.html)
    * [Motor Vector Control with hall sensors(rm_motor_hall)](https://renesas.github.io/fsp/group___m_o_t_o_r___h_a_l_l.html)
    * [Motor inertia estimation (rm_motor_inertia_estimate)](https://renesas.github.io/fsp/group___m_o_t_o_r___i_n_e_r_t_i_a___e_s_t_i_m_a_t_e.html)
    * [Motor return origin function (rm_motor_return_origin)](https://renesas.github.io/fsp/group___m_o_t_o_r___r_e_t_u_r_n___o_r_i_g_i_n.html)
    * [Motor vector control with induction sensor (rm_motor_induction)](https://renesas.github.io/fsp/group___m_o_t_o_r___i_n_d_u_c_t_i_o_n.html)
  * Networking
    * Bluetooth Low Energy Mesh Network modules
      * [BLE Mesh (rm_ble_mesh)](https://renesas.github.io/fsp/group___r_m___b_l_e___m_e_s_h.html)
      * [BLE Mesh Access (rm_ble_mesh_access)](https://renesas.github.io/fsp/group___r_m___b_l_e___m_e_s_h___a_c_c_e_s_s.html)
      * [BLE Mesh Bearer (rm_ble_mesh_bearer)](https://renesas.github.io/fsp/group___r_m___b_l_e___m_e_s_h___b_e_a_r_e_r.html)
      * [BLE Mesh Bearer Platform (rm_mesh_bearer_platform)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___b_e_a_r_e_r___p_l_a_t_f_o_r_m.html)
      * [BLE Mesh Config Client (rm_mesh_config_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___c_o_n_f_i_g___c_l_t.html)
      * [BLE Mesh Config Server (rm_mesh_config_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___c_o_n_f_i_g___s_r_v.html)
      * [BLE Mesh Lower Trans (rm_ble_mesh_lower_trans)](https://renesas.github.io/fsp/group___r_m___b_l_e___m_e_s_h___l_o_w_e_r___t_r_a_n_s.html)
      * [BLE Mesh Model Generic Admin Property Server (rm_mesh_generic_admin_prop_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___a_d_m_i_n___p_r_o_p___s_r_v.html)
      * [BLE Mesh Model Generic Battery Client (rm_mesh_generic_battery_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___b_a_t_t_e_r_y___c_l_t.html)
      * [BLE Mesh Model Generic Battery Server (rm_mesh_generic_battery_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___b_a_t_t_e_r_y___s_r_v.html)
      * [BLE Mesh Model Generic Client Property Server (rm_mesh_generic_client_prop_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___c_l_i_e_n_t___p_r_o_p___s_r_v.html)
      * [BLE Mesh Model Generic Default Transition Time Client (rm_mesh_generic_dtt_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___d_t_t___c_l_t.html)
      * [BLE Mesh Model Generic Default Transition Time Server (rm_mesh_generic_dtt_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___d_t_t___s_r_v.html)
      * [BLE Mesh Model Generic Level Client (rm_mesh_generic_level_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___l_e_v_e_l___c_l_t.html)
      * [BLE Mesh Model Generic Level Server (rm_mesh_generic_level_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___l_e_v_e_l___s_r_v.html)
      * [BLE Mesh Model Generic Location Client (rm_mesh_generic_loc_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___l_o_c___c_l_t.html)
      * [BLE Mesh Model Generic Location Server (rm_mesh_generic_loc_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___l_o_c___s_r_v.html)
      * [BLE Mesh Model Generic Manufacturer Property Server (rm_mesh_generic_mfr_prop_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___m_f_r___p_r_o_p___s_r_v.html)
      * [BLE Mesh Model Generic On Off Client (rm_mesh_generic_on_off_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___o_n___o_f_f___c_l_t.html)
      * [BLE Mesh Model Generic On Off Server (rm_mesh_generic_on_off_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___o_n___o_f_f___s_r_v.html)
      * [BLE Mesh Model Generic Power Level Client (rm_mesh_generic_pl_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___p_l___c_l_t.html)
      * [BLE Mesh Model Generic Power Level Server (rm_mesh_generic_pl_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___p_l___s_r_v.html)
      * [BLE Mesh Model Generic Power On Off Client (rm_mesh_generic_poo_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___p_o_o___c_l_t.html)
      * [BLE Mesh Model Generic Power On Off Server (rm_mesh_generic_poo_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___p_o_o___s_r_v.html)
      * [BLE Mesh Model Generic Property Client (rm_mesh_generic_prop_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___p_r_o_p___c_l_t.html)
      * [BLE Mesh Model Generic User Property Server (rm_mesh_generic_user_prop_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___g_e_n_e_r_i_c___u_s_e_r___p_r_o_p___s_r_v.html)
      * [BLE Mesh Model Health Client (rm_mesh_health_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___h_e_a_l_t_h___c_l_t.html)
      * [BLE Mesh Model Health Server (rm_mesh_health_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___h_e_a_l_t_h___s_r_v.html)
      * [BLE Mesh Model Light Control Client (rm_mesh_light_ctl_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___c_t_l___c_l_t.html)
      * [BLE Mesh Model Light Control Server (rm_mesh_light_ctl_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___c_t_l___s_r_v.html)
      * [BLE Mesh Model Light HSL Client (rm_mesh_light_hsl_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___h_s_l___c_l_t.html)
      * [BLE Mesh Model Light HSL Server (rm_mesh_light_hsl_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___h_s_l___s_r_v.html)
      * [BLE Mesh Model Light Lightness Client (rm_mesh_light_lightness_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___l_i_g_h_t_n_e_s_s___c_l_t.html)
      * [BLE Mesh Model Light Lightness Controller Client (rm_mesh_light_lc_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___l_c___c_l_t.html)
      * [BLE Mesh Model Light Lightness Controller Server (rm_mesh_light_lc_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___l_c___s_r_v.html)
      * [BLE Mesh Model Light Lightness Server (rm_mesh_light_lightness_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___l_i_g_h_t_n_e_s_s___s_r_v.html)
      * [BLE Mesh Model Light XYL Client (rm_mesh_light_xyl_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___x_y_l___c_l_t.html)
      * [BLE Mesh Model Light XYL Server (rm_mesh_light_xyl_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___l_i_g_h_t___x_y_l___s_r_v.html)
      * [BLE Mesh Model Scene Client (rm_mesh_scene_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___s_c_e_n_e___c_l_t.html)
      * [BLE Mesh Model Scene Server (rm_mesh_scene_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___s_c_e_n_e___s_r_v.html)
      * [BLE Mesh Model Scheduler Client (rm_mesh_scheduler_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___s_c_h_e_d_u_l_e_r___c_l_t.html)
      * [BLE Mesh Model Scheduler Server (rm_mesh_scheduler_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___s_c_h_e_d_u_l_e_r___s_r_v.html)
      * [BLE Mesh Model Sensor Client (rm_mesh_sensor_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___s_e_n_s_o_r___c_l_t.html)
      * [BLE Mesh Model Sensor Server (rm_mesh_sensor_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___s_e_n_s_o_r___s_r_v.html)
      * [BLE Mesh Model Time Client (rm_mesh_time_clt)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___t_i_m_e___c_l_t.html)
      * [BLE Mesh Model Time Server (rm_mesh_time_srv)](https://renesas.github.io/fsp/group___r_m___m_e_s_h___t_i_m_e___s_r_v.html)
      * [BLE Mesh Network (rm_ble_mesh_network)](https://renesas.github.io/fsp/group___r_m___b_l_e___m_e_s_h___n_e_t_w_o_r_k.html)
      * [BLE Mesh Provision (rm_ble_mesh_provision)](https://renesas.github.io/fsp/group___r_m___b_l_e___m_e_s_h___p_r_o_v_i_s_i_o_n.html)
      * [BLE Mesh Upper Trans (rm_ble_mesh_upper_trans)](https://renesas.github.io/fsp/group___r_m___b_l_e___m_e_s_h___u_p_p_e_r___t_r_a_n_s.html)
    * [AWS Cellular Interface on RYZ (rm_cellular_ryz_aws)](https://renesas.github.io/fsp/group___r_m___c_e_l_l_u_l_a_r___r_y_z___a_w_s.html)
    * [AWS Core HTTP](https://docs.aws.amazon.com/freertos/latest/userguide/core-http.html)
    * [AWS Core MQTT](https://docs.aws.amazon.com/freertos/latest/userguide/coremqtt.html)
    * [AWS IoT Over-the-air Update Library](https://github.com/aws/ota-for-aws-iot-embedded-sdk)
    * [AWS Transport Interface on MbedTLS/PKCS11 (rm_aws_transport_interface_port)](https://docs.aws.amazon.com/embedded-csdk/latest/lib-ref/libraries/standard/coreMQTT/docs/doxygen/output/html/mqtt_transport_interface.html)
    * [Azure EWF Adapter on RYZ014A](https://renesas.github.io/fsp/group___r_m___a_z_u_r_e___e_w_f___r_y_z.html)
    * [Azure EWF Adapter on RYZ024A](https://renesas.github.io/fsp/group___r_m___a_z_u_r_e___e_w_f___r_y_z.html)
    * [Azure RTOS NetX Duo Auto IP](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-auto-ip/chapter1)
    * [Azure RTOS NetX Duo BSD Support](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-bsd/chapter1)
    * [Azure RTOS NetX Duo Common](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/)
    * [Azure RTOS NetX Duo DHCP IPv4 Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-dhcp-client/chapter1)
    * [Azure RTOS NetX Duo DHCP IPv4 Server](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-dhcp-server/chapter1)
    * [Azure RTOS NetX Duo DHCP IPv6 Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-dhcpv6-client/chapter1)
    * [Azure RTOS NetX Duo DHCP IPv6 Server](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-dhcpv6-server/chapter1)
    * [Azure RTOS NetX Duo DNS Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-dns/chapter1)
    * [Azure RTOS NetX Duo FTP Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-ftp/chapter1)
    * [Azure RTOS NetX Duo FTP Server](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-ftp/chapter1)
    * [Azure RTOS NetX Duo HTTP Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-http/chapter1)
    * [Azure RTOS NetX Duo HTTP Server](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-http/chapter1)
    * [Azure RTOS NetX Duo IP Instance](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/chapter3)
    * [Azure RTOS NetX Duo IoT Middleware](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/overview-netx-duo)
    * [Azure RTOS NetX Duo MQTT Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-mqtt/chapter1)
    * [Azure RTOS NetX Duo POP3 Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-pop3-client/chapter1)
    * [Azure RTOS NetX Duo Packet Pool Instance](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/chapter3)
    * [Azure RTOS NetX Duo SMTP Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-smtp-client/chapter1)
    * [Azure RTOS NetX Duo SNMP Agent](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-snmp/chapter1)
    * [Azure RTOS NetX Duo SNTP Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-sntp-client/chapter1)
    * [Azure RTOS NetX Duo TFTP Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-tftp/chapter1)
    * [Azure RTOS NetX Duo TFTP Server](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-tftp/chapter1)
    * [Azure RTOS NetX Duo Telnet Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-telnet/chapter1)
    * [Azure RTOS NetX Duo Telnet Server](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-telnet/chapter1)
    * [Azure RTOS NetX Duo Web HTTP/HTTPS Client](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-web-http/chapter1)
    * [Azure RTOS NetX Duo Web HTTP/HTTPS Server](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-web-http/chapter1)
    * [BLE Abstraction (rm_ble_abs)](https://renesas.github.io/fsp/group___b_l_e___a_b_s.html)
    * [BLE SPP Transport on SPI (rm_ble_abs_spp_transport)](https://renesas.github.io/fsp/group___b_l_e___a_b_s.html)
    * [BLE SPP Transport on UART (rm_ble_abs_spp_transport)](https://renesas.github.io/fsp/group___b_l_e___a_b_s.html)
    * [Ethernet (r_ether)](https://renesas.github.io/fsp/group___e_t_h_e_r.html)
    * [Ethernet (r_ether_phy)](https://renesas.github.io/fsp/group___e_t_h_e_r___p_h_y.html)
    * [FreeRTOS+TCP](https://www.freertos.org/FreeRTOS-Plus/FreeRTOS_Plus_TCP/TCP_IP_Configuration.html)
    * [GTL BLE Abstraction (rm_ble_abs_gtl)](https://renesas.github.io/fsp/group___b_l_e___a_b_s.html)
    * [PTP (r_ptp)](https://renesas.github.io/fsp/group___p_t_p.html)
    * [SPP BLE Abstraction (rm_ble_abs_spp)](https://renesas.github.io/fsp/group___b_l_e___a_b_s.html)
  * Power
    * [Low Power Modes (r_lpm)](https://renesas.github.io/fsp/group___l_p_m.html)
  * RTOS
    * [Azure RTOS ThreadX Port (rm_threadx_port)](https://renesas.github.io/fsp/group___r_m___t_h_r_e_a_d_x___p_o_r_t.html)
    * [FreeRTOS Buffer Allocation 2](https://www.freertos.org/FreeRTOS-Plus/FreeRTOS_Plus_TCP/Embedded_Ethernet_Buffer_Management.html)
    * [FreeRTOS Heap 1](https://www.freertos.org/a00111.html#heap_1)
    * [FreeRTOS Heap 2](https://www.freertos.org/a00111.html#heap_2)
    * [FreeRTOS Heap 3](https://www.freertos.org/a00111.html#heap_3)
    * [FreeRTOS Heap 4](https://www.freertos.org/a00111.html#heap_4)
    * [FreeRTOS Heap 5](https://www.freertos.org/a00111.html#heap_5)
    * [FreeRTOS Port (rm_freertos_port)](https://renesas.github.io/fsp/group___r_m___f_r_e_e_r_t_o_s___p_o_r_t.html)
  * Security
    * [Azure RTOS NetX Crypto](https://docs.microsoft.com/en-us/azure/rtos/netx/netx-crypto/chapter1)
    * [Azure RTOS NetX Secure](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-secure-tls/chapter1)
    * [MbedTLS](https://www.trustedfirmware.org/projects/mbed-tls/)
    * [MbedTLS (Crypto Only)](https://github.com/ARMmbed/mbed-crypto/blob/mbedcrypto-2.0.0/docs/getting_started.md)
    * [SCE Protected Mode](https://renesas.github.io/fsp/group___s_c_e___p_r_o_t_e_c_t_e_d.html)
    * [TinyCrypt (H/W Accelerated)](https://github.com/01org/tinycrypt/blob/master/documentation/tinycrypt.rst)
    * [TinyCrypt (S/W Only)](https://github.com/01org/tinycrypt/blob/master/documentation/tinycrypt.rst)
    * [Trusted Firmware-M](https://tf-m-user-guide.trustedfirmware.org/)
    * [Trusted Firmware-M BL2](https://tf-m-user-guide.trustedfirmware.org/design_docs/booting/tfm_secure_boot.html)
    * [Trusted Firmware-M Non-Secure](https://tf-m-user-guide.trustedfirmware.org/)
  * Sensor
    * [FS1015 Flow Sensor (rm_fs1015)](https://renesas.github.io/fsp/group___r_m___f_s1015.html)
    * [FS2012 Flow Sensor (rm_fs2012)](https://renesas.github.io/fsp/group___r_m___f_s2012.html)
    * [FS3000 Flow Sensor (rm_fs3000)](https://renesas.github.io/fsp/group___r_m___f_s3000.html)
    * [HS300X Temperature/Humidity Sensor (rm_hs300x)](https://renesas.github.io/fsp/group___r_m___h_s300_x.html)
    * [HS400X Temperature/Humidity Sensor (rm_hs400x)](https://renesas.github.io/fsp/group___r_m___h_s400_x.html)
    * [OB1203 Light/Proximity/PPG Sensor (rm_ob1203)](https://renesas.github.io/fsp/group___r_m___o_b1203.html)
    * [ZMOD4XXX Gas Sensor (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
  * Storage
    * [Azure RTOS FileX on Block Media](https://docs.microsoft.com/en-us/azure/rtos/filex/)
    * [Azure RTOS FileX on LevelX NOR](https://docs.microsoft.com/en-us/azure/rtos/filex/)
    * [Azure RTOS FileX on USBX](https://docs.microsoft.com/en-us/azure/rtos/filex/overview-filex)
    * [Azure RTOS LevelX NOR on SPI Memory](https://docs.microsoft.com/en-us/azure/rtos/levelx/)
    * [Block Media Custom Implementation (rm_block_media_user)](https://renesas.github.io/fsp/group___r_m___b_l_o_c_k___m_e_d_i_a___u_s_e_r.html)
    * [Block Media SD/MMC (rm_block_media_sdmmc)](https://renesas.github.io/fsp/group___r_m___b_l_o_c_k___m_e_d_i_a___s_d_m_m_c.html)
    * [Block Media SPI Flash (rm_block_media_spi)](https://renesas.github.io/fsp/group___r_m___b_l_o_c_k___m_e_d_i_a___s_p_i.html)
    * [Block Media USB (rm_block_media_usb)](https://renesas.github.io/fsp/group___r_m___b_l_o_c_k___m_e_d_i_a___u_s_b.html)
    * [Flash (r_flash_hp)](https://renesas.github.io/fsp/group___f_l_a_s_h___h_p.html)
    * [Flash (r_flash_lp)](https://renesas.github.io/fsp/group___f_l_a_s_h___l_p.html)
    * [FreeRTOS+FAT](https://www.freertos.org/FreeRTOS-Plus/FreeRTOS_Plus_FAT/index.html)
    * [LittleFS](https://github.com/ARMmbed/littlefs)
    * [OSPI Flash (r_ospi)](https://renesas.github.io/fsp/group___o_s_p_i.html)
    * [OSPI RAM (r_ospi)](https://renesas.github.io/fsp/group___o_s_p_i.html)
    * [QSPI (r_qspi)](https://renesas.github.io/fsp/group___q_s_p_i.html)
    * [SD/MMC (r_sdhi)](https://renesas.github.io/fsp/group___s_d_h_i.html)
    * [Virtual EEPROM on Flash (rm_vee_flash)](https://renesas.github.io/fsp/group___r_m___v_e_e___a_p_i.html)
  * System
    * [Clock Generation Circuit (r_cgc)](https://renesas.github.io/fsp/group___c_g_c.html)
    * [Event Link Controller (r_elc)](https://renesas.github.io/fsp/group___e_l_c.html)
    * [I/O Port (r_ioport)](https://renesas.github.io/fsp/group___i_o_p_o_r_t.html)
  * Timers
    * [Port Output Enable for GPT (r_poeg)](https://renesas.github.io/fsp/group___p_o_e_g.html)
    * [Realtime Clock (r_rtc)](https://renesas.github.io/fsp/group___r_t_c.html)
    * [Three-Phase PWM (r_gpt_three_phase)](https://renesas.github.io/fsp/group___g_p_t___t_h_r_e_e___p_h_a_s_e.html)
    * [Timer, General PWM (r_gpt)](https://renesas.github.io/fsp/group___g_p_t.html)
    * [Timer, Low-Power (r_agt)](https://renesas.github.io/fsp/group___a_g_t.html)
    * [Timer, Ultra-Low-Power (r_ulpt)](https://renesas.github.io/fsp/group___u_l_p_t.html)
  * Transfer
    * [Transfer (r_dmac)](https://renesas.github.io/fsp/group___d_m_a_c.html)
    * [Transfer (r_dtc)](https://renesas.github.io/fsp/group___d_t_c.html)
  * TrustZone
    * [ARM TrustZone Context RA Port (rm_tz_context)](https://arm-software.github.io/CMSIS_5/Core/html/group__context__trustzone__functions.html)


### FSP Module Dependencies
  * Analog
    * [SDADC Channel Configuration (r_sdadc)](https://renesas.github.io/fsp/group___s_d_a_d_c.html)
  * Bootloader
    * [MCUboot ASN.1 Parser](https://github.com/mcu-tools/mcuboot)
    * [MCUboot Custom Crypto (Protected Mode)](https://renesas.github.io/fsp/group___r_m___m_c_u_b_o_o_t___p_o_r_t.html)
    * [MCUboot Example Keys (NOT FOR PRODUCTION)](https://github.com/mcu-tools/mcuboot)
    * [MCUboot External Memory (QSPI)](https://renesas.github.io/fsp/)
    * [MCUboot Port for RA (rm_mcuboot_port)](https://renesas.github.io/fsp/group___r_m___m_c_u_b_o_o_t___p_o_r_t.html)
    * [MCUboot config](https://github.com/mcu-tools/mcuboot)
    * [MCUboot logging](https://github.com/mcu-tools/mcuboot)
    * [MCUboot sysflash](https://github.com/mcu-tools/mcuboot)
  * Connectivity
    * [Azure RTOS USBX HMSC](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX OTG MSC](https://docs.microsoft.com/en-us/azure/rtos/usbx/)
    * [Azure RTOS USBX Port (rm_usbx_port)](https://renesas.github.io/fsp/group___u_s_b_x.html)
    * [USB (r_usb_basic)](https://renesas.github.io/fsp/group___u_s_b.html)
    * [USB HCDC (r_usb_hcdc)](https://renesas.github.io/fsp/group___u_s_b___h_c_d_c.html)
    * [USB HHID (r_usb_hhid)](https://renesas.github.io/fsp/group___u_s_b___h_h_i_d.html)
    * [USB Host Vendor class (r_usb_hvnd)](https://renesas.github.io/fsp/group___u_s_b___h_v_n_d.html)
    * [USB PCDC (r_usb_pcdc_class)](https://renesas.github.io/fsp/group___u_s_b___p_c_d_c.html)
    * [USB PCDC 2channel (r_usb_pcdc)](https://renesas.github.io/fsp/group___u_s_b___p_c_d_c.html)
    * [USB PHID (r_usb_phid_class)](https://renesas.github.io/fsp/group___u_s_b___p_h_i_d.html)
    * [USB PHID 2channel (r_usb_phid)](https://renesas.github.io/fsp/group___u_s_b___p_h_i_d.html)
    * [USB PMSC (r_usb_pmsc_class)](https://renesas.github.io/fsp/group___u_s_b___p_m_s_c.html)
    * [USB PPRN (r_usb_pprn_class)](https://renesas.github.io/fsp/group___u_s_b___p_p_r_n.html)
    * [USB PVND (r_usb_pvnd_class)](https://renesas.github.io/fsp/group___u_s_b___p_v_n_d.html)
  * Graphics
    * [Azure RTOS GUIX Port (rm_guix_port)](https://renesas.github.io/fsp/group___r_m___g_u_i_x___p_o_r_t.html)
    * [SEGGER emWin RA Port (rm_emwin_port)](https://renesas.github.io/fsp/group___r_m___e_m_w_i_n___p_o_r_t.html)
  * Networking
    * [AWS Cellular Interface Common](https://www.freertos.org/Documentation/api-ref/cellular/index.html)
    * [AWS Cellular Platform (rm_cellular_platform_aws)](https://www.freertos.org/Documentation/api-ref/cellular/cellular_porting.html)
    * [AWS Cellular Sockets Wrapper](https://docs.aws.amazon.com/embedded-csdk/latest/lib-ref/libraries/standard/coreMQTT/docs/doxygen/output/html/mqtt_transport_interface.html)
    * [AWS Cellular/WiFi MbedTLS Bio](https://docs.aws.amazon.com/embedded-csdk/latest/lib-ref/libraries/standard/coreMQTT/docs/doxygen/output/html/mqtt_transport_interface.html)
    * [AWS Client Credentials](https://renesas.github.io/fsp/group___a_w_s___m_q_t_t.html)
    * [AWS Core HTTP](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS Core JSON](https://github.com/FreeRTOS/coreJSON/)
    * [AWS Core MQTT](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS Demo dev_mode_key_provisioning](https://docs.aws.amazon.com/freertos/latest/userguide/dev-mode-key-provisioning.html)
    * [AWS Demo dev_mode_key_provisioning (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS FreeRTOS+TCP MbedTLS Bio](https://docs.aws.amazon.com/embedded-csdk/latest/lib-ref/libraries/standard/coreMQTT/docs/doxygen/output/html/mqtt_transport_interface.html)
    * [AWS HTTPS Wrapper (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS IoT Common (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS Logging](https://renesas.github.io/fsp/)
    * [AWS MQTT Wrapper (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS PKCS11 PAL on LittleFS (rm_aws_pkcs11_pal_littlefs)](https://renesas.github.io/fsp/group___a_w_s___p_k_c_s11___p_a_l___l_i_t_t_l_e_f_s.html)
    * [AWS PKCS11 to MbedTLS](https://docs.aws.amazon.com/freertos/latest/userguide/security-pkcs.html)
    * [AWS Secure Sockets Common (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS Secure Sockets TLS Support (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS Secure Sockets on FreeRTOS Plus TCP (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS Secure Sockets on WiFi (No Longer Supported)](https://renesas.github.io/fsp/)
    * [AWS Silex WiFi Sockets Wrapper (rm_aws_sockets_wrapper_silex)](https://docs.aws.amazon.com/embedded-csdk/latest/lib-ref/libraries/standard/coreMQTT/docs/doxygen/output/html/mqtt_transport_interface.html)
    * [AWS TCP Sockets Wrapper](https://docs.aws.amazon.com/embedded-csdk/latest/lib-ref/libraries/standard/coreMQTT/docs/doxygen/output/html/mqtt_transport_interface.html)
    * [AWS Transport Interface on Secure Sockets (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [AWS WiFi Common](https://docs.aws.amazon.com/freertos/latest/userguide/freertos-wifi.html)
    * [AWS da16200 WiFi Sockets Wrapper (rm_aws_sockets_wrapper_da16200)](https://docs.aws.amazon.com/embedded-csdk/latest/lib-ref/libraries/standard/coreMQTT/docs/doxygen/output/html/mqtt_transport_interface.html)
    * [Azure EWF Heap Allocator](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure EWF Interface on r_uart](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure EWF Memory Pool Allocator](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure EWF NetX Duo Middleware](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure EWF Platform on Bare Metal](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure EWF Platform on ThreadX](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure EWF ThreadX Allocator](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure Embedded Wireless Framework Common](https://azure.github.io/embedded-wireless-framework/html/index.html)
    * [Azure RTOS NetX Duo NAT](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/netx-duo-nat/chapter1)
    * [BLE Driver (r_ble_balance)](https://renesas.github.io/fsp/group___b_l_e___b_a_l_a_n_c_e.html)
    * [BLE Driver (r_ble_balance_freertos)](https://renesas.github.io/fsp/group___b_l_e___b_a_l_a_n_c_e.html)
    * [BLE Driver (r_ble_balance_threadx)](https://renesas.github.io/fsp/group___b_l_e___b_a_l_a_n_c_e.html)
    * [BLE Driver (r_ble_compact)](https://renesas.github.io/fsp/group___b_l_e___c_o_m_p_a_c_t.html)
    * [BLE Driver (r_ble_compact_freertos)](https://renesas.github.io/fsp/group___b_l_e___c_o_m_p_a_c_t.html)
    * [BLE Driver (r_ble_compact_threadx)](https://renesas.github.io/fsp/group___b_l_e___c_o_m_p_a_c_t.html)
    * [BLE Driver (r_ble_extended)](https://renesas.github.io/fsp/group___b_l_e___e_x_t_e_n_d_e_d.html)
    * [BLE Driver (r_ble_extended_freertos)](https://renesas.github.io/fsp/group___b_l_e___e_x_t_e_n_d_e_d.html)
    * [BLE Driver (r_ble_extended_threadx)](https://renesas.github.io/fsp/group___b_l_e___e_x_t_e_n_d_e_d.html)
    * [BLE GTL Transport on UART (rm_ble_abs_gtl_transport)](https://renesas.github.io/fsp/group___b_l_e___a_b_s.html)
    * [BLE Mesh OS on Baremetal (rm_mesh_os_baremetal)](https://renesas.github.io/fsp/group___m_e_s_h___o_s___b_a_r_e_m_e_t_a_l.html)
    * [BLE Mesh OS on FreeRTOS (rm_mesh_os_freertos)](https://renesas.github.io/fsp/group___m_e_s_h___o_s___f_r_e_e_r_t_o_s.html)
    * [BLE Mesh Timer on Baremetal (rm_mesh_timer_baremetal)](https://renesas.github.io/fsp/group___m_e_s_h___t_i_m_e_r___b_a_r_e_m_e_t_a_l.html)
    * [BLE Mesh Timer on FreeRTOS (rm_mesh_timer_freertos)](https://renesas.github.io/fsp/group___m_e_s_h___t_i_m_e_r___f_r_e_e_r_t_o_s.html)
    * [Cellular Comm Interface on UART (rm_cellular_comm_uart_aws)](https://www.freertos.org/Documentation/api-ref/cellular/cellular__comm__interface_8h.html)
    * [DA14531 GTL Driver Layer](https://renesas.github.io/fsp/group___b_l_e___a_b_s___g_t_l.html)
    * [FreeRTOS+TCP Wrapper to r_ether (rm_freertos_plus_tcp)](https://renesas.github.io/fsp/group___f_r_e_e_r_t_o_s___p_l_u_s___t_c_p.html)
    * [FreeRTOS+TLS (No Longer Supported)](https://renesas.github.io/fsp/_f_r_e_e_r_t_o_s__m_i_g_r_a_t_i_o_n.html)
    * [NetX Duo Ethernet Driver (rm_netxduo_ether)](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/chapter5)
    * [NetX Duo WiFi Driver (rm_netxduo_wifi)](https://docs.microsoft.com/en-us/azure/rtos/netx-duo/chapter5)
    * [RYZ012 SPP Driver Layer](https://renesas.github.io/fsp/group___b_l_e___a_b_s___s_p_p.html)
    * [TinyCBOR](https://github.com/intel/tinycbor/)
    * [WiFi Onchip Silex Driver using r_sci_uart (rm_wifi_onchip_silex)](https://renesas.github.io/fsp/group___w_i_f_i___o_n_c_h_i_p___s_i_l_e_x.html)
    * [WiFi Onchip da16200 Driver using r_sci_uart (rm_wifi_onchip_da16200)](https://renesas.github.io/fsp/group___w_i_f_i___o_n_c_h_i_p___d_a16200.html)
  * Security
    * [Azure RTOS NetX Crypto HW Acceleration (rm_netx_secure_crypto)](https://renesas.github.io/fsp/group___r_m___n_e_t_x___s_e_c_u_r_e___c_r_y_p_t_o.html)
    * [Azure RTOS NetX Crypto Software Only](https://renesas.github.io/fsp/group___r_m___n_e_t_x___s_e_c_u_r_e___c_r_y_p_t_o.html)
    * [Crypto AES2](https://renesas.github.io/fsp/)
    * [Crypto RA2](https://renesas.github.io/fsp/)
    * [FreeRTOS MbedTLS Port](https://renesas.github.io/fsp/)
    * [Key Injection for PSA Crypto](https://renesas.github.io/fsp/group___s_c_e___k_e_y___i_n_j_e_c_t_i_o_n.html)
    * [MCUBoot TinyCrypt H/W Acceleration (rm_mcuboot_tinycrypt_port)](https://renesas.github.io/fsp/group___r_m___t_i_n_y_c_r_y_p_t___p_o_r_t.html)
    * [MCUboot TinyCrypt (H/W Accelerated)](https://github.com/01org/tinycrypt/blob/master/documentation/tinycrypt.rst)
    * [MCUboot TinyCrypt (S/W Only)](https://github.com/01org/tinycrypt/blob/master/documentation/tinycrypt.rst)
    * [Mbed Crypto H/W Acceleration (rm_psa_crypto)](https://renesas.github.io/fsp/group___r_m___p_s_a___c_r_y_p_t_o.html)
    * [MbedTLS FSP Port (rm_mbedtls)](https://www.trustedfirmware.org/projects/mbed-tls/)
    * [RSIP Compatibility Mode](https://renesas.github.io/fsp/)
    * [SCE Compatibility Mode](https://renesas.github.io/fsp/)
    * [SCE5](https://renesas.github.io/fsp/)
    * [SCE5B](https://renesas.github.io/fsp/)
    * [SCE7](https://renesas.github.io/fsp/)
    * [TRNG](https://renesas.github.io/fsp/)
    * [TinyCrypt H/W Acceleration (TRNG Only)](https://renesas.github.io/fsp/group___r_m___t_i_n_y_c_r_y_p_t___p_o_r_t.html)
    * [TinyCrypt H/W Acceleration (rm_tinycrypt_port)](https://renesas.github.io/fsp/group___r_m___t_i_n_y_c_r_y_p_t___p_o_r_t.html)
    * [Trusted Firmware-M BL2 Port (rm_bl2_port)](https://github.com/ARM-software/arm-trusted-firmware/blob/master/docs/design/firmware-design.rst#bl2)
    * [Trusted Firmware-M FreeRTOS Integration](https://tf-m-user-guide.trustedfirmware.org/)
    * [Trusted Firmware-M Port (rm_tfm_port)](https://tf-m-user-guide.trustedfirmware.org/)
  * Sensor
    * [OB1203 Light Proximity mode (rm_ob1203)](https://renesas.github.io/fsp/group___r_m___o_b1203.html)
    * [OB1203 Light mode (rm_ob1203)](https://renesas.github.io/fsp/group___r_m___o_b1203.html)
    * [OB1203 PPG mode (rm_ob1203)](https://renesas.github.io/fsp/group___r_m___o_b1203.html)
    * [OB1203 Proximity mode (rm_ob1203)](https://renesas.github.io/fsp/group___r_m___o_b1203.html)
    * [ZMOD4410 IAQ 1st Generation (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
    * [ZMOD4410 IAQ 2nd Generation (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
    * [ZMOD4410 IAQ 2nd Generation Ultra Low Power (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
    * [ZMOD4410 Odor (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
    * [ZMOD4410 Sulfur-based Odor (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
    * [ZMOD4450 RAQ (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
    * [ZMOD4510 OAQ 1st Generation (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
    * [ZMOD4510 OAQ 2nd Generation (rm_zmod4xxx)](https://renesas.github.io/fsp/group___r_m___z_m_o_d4_x_x_x.html)
  * Storage
    * [AWS OTA PAL (rm_aws_ota_pal_mcuboot)](https://renesas.github.io/fsp/group___r_m___a_w_s___o_t_a___p_a_l___m_c_u_b_o_o_t.html)
    * [Azure RTOS FileX Stub for NetX Duo](https://docs.microsoft.com/en-us/azure/rtos/filex/)
    * [Block Media Custom Implementation](https://renesas.github.io/fsp/group___r_m___b_l_o_c_k___m_e_d_i_a___u_s_e_r.html)
    * [FileX I/O (rm_filex_block_media)](https://renesas.github.io/fsp/group___r_m___f_i_l_e_x___b_l_o_c_k___m_e_d_i_a.html)
    * [FileX I/O (rm_filex_levelx_nor)](https://renesas.github.io/fsp/group___r_m___f_i_l_e_x___l_e_v_e_l_x___n_o_r.html)
    * [FreeRTOS+FAT Port for RA (rm_freertos_plus_fat)](https://www.freertos.org/FreeRTOS-Plus/FreeRTOS_Plus_FAT/index.html)
    * [LevelX NOR Port (rm_levelx_nor_spi)](https://renesas.github.io/fsp/group___r_m___l_e_v_e_l_x___n_o_r___s_p_i.html)
    * [LittleFS on Flash (rm_littlefs_flash)](https://renesas.github.io/fsp/group___r_m___l_i_t_t_l_e_f_s___f_l_a_s_h.html)
  * System
    * [Arm CMSIS5 Core (M)](https://arm-software.github.io/CMSIS_5/Core/html/index.html)
  * Transfer
    * [Ethernet DMA (r_edmac)](https://renesas.github.io/fsp/)
