/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.BgKinRunner;
import chiropraxis.kingtools.ModelManager2;
import driftwood.gui.AttentiveComboBox;
import driftwood.gui.AttentiveTextField;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.util.SoftLog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.KingMain;
import king.core.Kinemage;

public class ExpectedNoePanel
extends TablePane
implements ActionListener,
ChangeListener {
    static final DecimalFormat df = new DecimalFormat("0.0###");
    static final String DEFAULT_MAX_LENGTH = "4.5";
    KingMain kMain;
    ModelManager2 modelman;
    BgKinRunner noePlotter = null;
    AttentiveComboBox cmDisplaySel;
    JTextField tfMaxLength;
    JCheckBox cbShowAll;

    public ExpectedNoePanel(KingMain kingMain, ModelManager2 modelManager2) {
        this.kMain = kingMain;
        this.modelman = modelManager2;
        this.buildGUI();
    }

    private void buildGUI() {
        ExpectedNoePanel expectedNoePanel = this;
        this.cmDisplaySel = new AttentiveComboBox(new Object[]{"{molten}", "within 5 of {viewcenter}", "all", "viol"});
        this.cmDisplaySel.addActionListener(this);
        this.tfMaxLength = new AttentiveTextField(DEFAULT_MAX_LENGTH);
        this.tfMaxLength.addActionListener(this);
        this.cbShowAll = new JCheckBox("Show all predicted NOEs", true);
        this.cbShowAll.addActionListener(this);
        JButton jButton = new JButton(new ReflectiveAction("Simulate experiment(s)...", null, this, "onSimulateExperiment"));
        expectedNoePanel.save().weights(0.0, 1.0).addCell(new JLabel("Display:")).restore();
        expectedNoePanel.save().hfill(true).addCell(this.cmDisplaySel).restore();
        expectedNoePanel.newRow();
        expectedNoePanel.save().weights(0.0, 1.0).addCell(new JLabel("Max length:")).restore();
        expectedNoePanel.save().hfill(true).addCell(this.tfMaxLength).restore();
        expectedNoePanel.newRow();
        expectedNoePanel.addCell(this.cbShowAll, 2, 1);
        this.refreshGUI();
    }

    public void refreshGUI() {
        if (this.modelman.noeFile == null) {
            this.cbShowAll.setEnabled(false);
            this.cbShowAll.setSelected(true);
        } else {
            this.cbShowAll.setEnabled(true);
        }
    }

    BgKinRunner getNoePlotter() {
        Kinemage kinemage = this.kMain.getKinemage();
        if (!(kinemage == null || this.noePlotter != null && this.noePlotter.getKinemage().equals(kinemage))) {
            if (this.noePlotter != null) {
                this.noePlotter.terminate();
            }
            this.noePlotter = new BgKinRunner(this.kMain, kinemage, "");
        }
        return this.noePlotter;
    }

    public void visualizeNOEs(Collection collection, File file, String string) {
        try {
            String string2;
            String string3 = this.cbShowAll.isSelected() ? "a" : "";
            String string4 = this.getMaxLength();
            this.tfMaxLength.setText(string4);
            if (file == null) {
                string2 = "";
                string3 = "a";
            } else {
                string2 = "'" + file.getCanonicalPath() + "'";
            }
            BgKinRunner bgKinRunner = this.getNoePlotter();
            String string5 = " -t -g 'Expected NOEs' -f   -n " + string + " -e" + string3 + "n " + string4 + " '" + this.getDisplaySelection() + "'" + " '{pdbfile}' " + string2;
            String string6 = this.noePlotter.findProgram("noe-display");
            this.noePlotter.setCommand(string6 + string5);
            bgKinRunner.requestRun(collection, this.modelman.getMoltenState(), this.modelman.getFrozenPDB());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    String getDisplaySelection() {
        return this.cmDisplaySel.getText();
    }

    String getMaxLength() {
        try {
            double d = Double.parseDouble(this.tfMaxLength.getText());
            if (d < 1.0) {
                d = 1.0;
            }
            if (d > 20.0) {
                d = 20.0;
            }
            return df.format(d);
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_MAX_LENGTH;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.modelman.requestStateRefresh();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.modelman.requestStateRefresh();
    }

    public void onSimulateExperiment(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "This feature has not been implemented yet.", "Sorry!", 0);
    }
}

