/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class AltConfBackrubFinder {
    Collection inputFiles = new ArrayList();

    void searchModel(PrintStream printStream, String string, Model model) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0####");
        Collection collection = model.getStates().values();
        ModelState[] modelStateArray = collection.toArray(new ModelState[collection.size()]);
        for (Residue residue : model.getResidues()) {
            Residue residue2 = residue.getPrev(model);
            Residue residue3 = residue.getNext(model);
            if (residue2 == null || residue3 == null) continue;
            Atom atom = residue.getAtom(" CB ");
            Atom atom2 = residue2.getAtom(" CA ");
            Atom atom3 = residue3.getAtom(" CA ");
            Triple triple = new Triple(1.0, 0.0, 0.0);
            Triple triple2 = new Triple(1.0, 0.0, 0.0);
            double d = 0.0;
            for (int i = 0; i < modelStateArray.length; ++i) {
                for (int j = i + 1; j < modelStateArray.length; ++j) {
                    try {
                        AtomState atomState;
                        AtomState atomState2;
                        double d2;
                        AtomState atomState3 = modelStateArray[i].get(atom2);
                        AtomState atomState4 = modelStateArray[j].get(atom2);
                        AtomState atomState5 = modelStateArray[i].get(atom3);
                        AtomState atomState6 = modelStateArray[j].get(atom3);
                        if (atomState3.distance(atomState4) > 0.01 || atomState5.distance(atomState6) > 0.01 || !((d2 = (atomState2 = modelStateArray[i].get(atom)).distance(atomState = modelStateArray[j].get(atom))) > d)) continue;
                        d = d2;
                        Triple triple3 = new Triple().likeMidpoint(atomState3, atomState4);
                        Triple triple4 = new Triple().likeMidpoint(atomState5, atomState6);
                        triple.likeVector(triple3, triple4);
                        triple2.likeVector(atomState2, atomState);
                        continue;
                    }
                    catch (AtomException atomException) {
                        // empty catch block
                    }
                }
            }
            if (!(d > 0.0)) continue;
            printStream.println(string + ":" + model + ":" + residue.getCNIT() + ":" + decimalFormat.format(d) + ":" + decimalFormat.format(triple.angle(triple2)));
        }
    }

    public void Main() {
        PdbReader pdbReader = new PdbReader();
        for (File file : this.inputFiles) {
            try {
                CoordinateFile coordinateFile = pdbReader.read(file);
                for (Model model : coordinateFile.getModels()) {
                    String string = file.toString();
                    if (coordinateFile.getIdCode() != null) {
                        string = coordinateFile.getIdCode();
                    }
                    this.searchModel(System.out, string, model);
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException when processing " + file);
            }
        }
    }

    public static void main(String[] stringArray) {
        AltConfBackrubFinder altConfBackrubFinder = new AltConfBackrubFinder();
        try {
            altConfBackrubFinder.parseArguments(stringArray);
            altConfBackrubFinder.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            altConfBackrubFinder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AltConfBackrubFinder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AltConfBackrubFinder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AltConfBackrubFinder");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            throw new IllegalArgumentException("'" + string + "' is not a valid file name.");
        }
        this.inputFiles.add(file);
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

