/*
 * Decompiled with CFR 0.152.
 */
package driftwood.gui;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressDialog
implements ActionListener,
Runnable {
    JDialog progDialog;
    JProgressBar progBar;
    Timer timer;
    volatile int taskComplete = 0;
    volatile int taskTotal = 0;
    volatile boolean hide = false;
    volatile boolean canceled = false;

    public ProgressDialog(Component component, String string, boolean bl) {
        while (component != null && !(component instanceof Frame) && !(component instanceof Dialog)) {
            component = component.getParent();
        }
        this.progBar = new JProgressBar();
        this.progBar.setIndeterminate(true);
        this.progBar.setStringPainted(false);
        JLabel jLabel = new JLabel(string);
        JButton jButton = new JButton(new ReflectiveAction("Cancel", null, this, "onRequestCancel"));
        TablePane2 tablePane2 = new TablePane2().insets(6).center().memorize();
        tablePane2.addCell(jLabel).newRow();
        tablePane2.hfill(true).addCell(this.progBar).newRow();
        if (bl) {
            tablePane2.addCell(jButton);
        }
        this.progDialog = component instanceof Dialog ? new JDialog((Dialog)component, "", true) : new JDialog((Frame)component, "", true);
        this.progDialog.setDefaultCloseOperation(0);
        this.progDialog.setContentPane(tablePane2);
        this.progDialog.pack();
        this.progDialog.setLocationRelativeTo(component);
        this.timer = new Timer(250, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        ProgressDialog progressDialog = this;
        synchronized (progressDialog) {
            if (this.progBar.getMaximum() != this.taskTotal) {
                this.progBar.setMaximum(this.taskTotal);
            }
            if (this.progBar.getValue() != this.taskComplete) {
                this.progBar.setValue(this.taskComplete);
            }
            if (this.taskTotal > 0 && this.progBar.isIndeterminate()) {
                this.progBar.setIndeterminate(false);
                this.progBar.setStringPainted(true);
            }
        }
        if (this.hide) {
            this.timer.stop();
            this.hide = false;
            this.progDialog.dispose();
        }
    }

    public void run() {
        if (!this.progDialog.isVisible()) {
            this.timer.start();
            this.progDialog.pack();
            this.progDialog.setVisible(true);
        }
    }

    public void onRequestCancel(ActionEvent actionEvent) {
        this.canceled = true;
    }

    public synchronized void show() {
        SwingUtilities.invokeLater(this);
    }

    public synchronized void dispose() {
        this.hide = true;
    }

    public synchronized void update(int n, int n2) {
        this.taskComplete = n;
        this.taskTotal = n2;
    }

    public synchronized boolean isCanceled() {
        return this.canceled;
    }
}

