//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// **************    Class    ***************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptablestrongmemory?language=objc)
#[cfg(feature = "NSPointerFunctions")]
pub static NSMapTableStrongMemory: NSPointerFunctionsOptions =
    NSPointerFunctionsOptions(NSPointerFunctionsOptions::StrongMemory.0);

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptablezeroingweakmemory?language=objc)
#[cfg(feature = "NSPointerFunctions")]
#[deprecated = "GC no longer supported"]
pub static NSMapTableZeroingWeakMemory: NSPointerFunctionsOptions =
    NSPointerFunctionsOptions(NSPointerFunctionsOptions::ZeroingWeakMemory.0);

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptablecopyin?language=objc)
#[cfg(feature = "NSPointerFunctions")]
pub static NSMapTableCopyIn: NSPointerFunctionsOptions =
    NSPointerFunctionsOptions(NSPointerFunctionsOptions::CopyIn.0);

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptableobjectpointerpersonality?language=objc)
#[cfg(feature = "NSPointerFunctions")]
pub static NSMapTableObjectPointerPersonality: NSPointerFunctionsOptions =
    NSPointerFunctionsOptions(NSPointerFunctionsOptions::ObjectPointerPersonality.0);

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptableweakmemory?language=objc)
#[cfg(feature = "NSPointerFunctions")]
pub static NSMapTableWeakMemory: NSPointerFunctionsOptions =
    NSPointerFunctionsOptions(NSPointerFunctionsOptions::WeakMemory.0);

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptableoptions?language=objc)
pub type NSMapTableOptions = NSUInteger;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptable?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSMapTable<KeyType: ?Sized = AnyObject, ObjectType: ?Sized = AnyObject>;
);

impl<KeyType: ?Sized + Message, ObjectType: ?Sized + Message> NSMapTable<KeyType, ObjectType> {
    /// Unchecked conversion of the generic parameters.
    ///
    /// # Safety
    ///
    /// The generics must be valid to reinterpret as the given types.
    #[inline]
    pub unsafe fn cast_unchecked<NewKeyType: ?Sized + Message, NewObjectType: ?Sized + Message>(
        &self,
    ) -> &NSMapTable<NewKeyType, NewObjectType> {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl<KeyType: ?Sized + NSCoding, ObjectType: ?Sized + NSCoding> NSCoding
        for NSMapTable<KeyType, ObjectType>
    {
    }
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl<KeyType: ?Sized, ObjectType: ?Sized> NSCopying for NSMapTable<KeyType, ObjectType> {}
);

#[cfg(feature = "NSObject")]
unsafe impl<KeyType: ?Sized + Message, ObjectType: ?Sized + Message> CopyingHelper
    for NSMapTable<KeyType, ObjectType>
{
    type Result = Self;
}

#[cfg(feature = "NSEnumerator")]
extern_conformance!(
    unsafe impl<KeyType: ?Sized, ObjectType: ?Sized> NSFastEnumeration
        for NSMapTable<KeyType, ObjectType>
    {
    }
);

extern_conformance!(
    unsafe impl<KeyType: ?Sized, ObjectType: ?Sized> NSObjectProtocol
        for NSMapTable<KeyType, ObjectType>
    {
    }
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl<KeyType: ?Sized + NSSecureCoding, ObjectType: ?Sized + NSSecureCoding>
        NSSecureCoding for NSMapTable<KeyType, ObjectType>
    {
    }
);

impl<KeyType: Message, ObjectType: Message> NSMapTable<KeyType, ObjectType> {
    extern_methods!(
        #[cfg(feature = "NSPointerFunctions")]
        #[unsafe(method(initWithKeyOptions:valueOptions:capacity:))]
        #[unsafe(method_family = init)]
        pub fn initWithKeyOptions_valueOptions_capacity(
            this: Allocated<Self>,
            key_options: NSPointerFunctionsOptions,
            value_options: NSPointerFunctionsOptions,
            initial_capacity: NSUInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "NSPointerFunctions")]
        #[unsafe(method(initWithKeyPointerFunctions:valuePointerFunctions:capacity:))]
        #[unsafe(method_family = init)]
        pub fn initWithKeyPointerFunctions_valuePointerFunctions_capacity(
            this: Allocated<Self>,
            key_functions: &NSPointerFunctions,
            value_functions: &NSPointerFunctions,
            initial_capacity: NSUInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "NSPointerFunctions")]
        #[unsafe(method(mapTableWithKeyOptions:valueOptions:))]
        #[unsafe(method_family = none)]
        pub fn mapTableWithKeyOptions_valueOptions(
            key_options: NSPointerFunctionsOptions,
            value_options: NSPointerFunctionsOptions,
        ) -> Retained<NSMapTable<KeyType, ObjectType>>;

        #[deprecated = "GC no longer supported"]
        #[unsafe(method(mapTableWithStrongToStrongObjects))]
        #[unsafe(method_family = none)]
        pub fn mapTableWithStrongToStrongObjects() -> Retained<AnyObject>;

        #[deprecated = "GC no longer supported"]
        #[unsafe(method(mapTableWithWeakToStrongObjects))]
        #[unsafe(method_family = none)]
        pub fn mapTableWithWeakToStrongObjects() -> Retained<AnyObject>;

        #[deprecated = "GC no longer supported"]
        #[unsafe(method(mapTableWithStrongToWeakObjects))]
        #[unsafe(method_family = none)]
        pub fn mapTableWithStrongToWeakObjects() -> Retained<AnyObject>;

        #[deprecated = "GC no longer supported"]
        #[unsafe(method(mapTableWithWeakToWeakObjects))]
        #[unsafe(method_family = none)]
        pub fn mapTableWithWeakToWeakObjects() -> Retained<AnyObject>;

        #[unsafe(method(strongToStrongObjectsMapTable))]
        #[unsafe(method_family = none)]
        pub fn strongToStrongObjectsMapTable() -> Retained<NSMapTable<KeyType, ObjectType>>;

        #[unsafe(method(weakToStrongObjectsMapTable))]
        #[unsafe(method_family = none)]
        pub fn weakToStrongObjectsMapTable() -> Retained<NSMapTable<KeyType, ObjectType>>;

        #[unsafe(method(strongToWeakObjectsMapTable))]
        #[unsafe(method_family = none)]
        pub fn strongToWeakObjectsMapTable() -> Retained<NSMapTable<KeyType, ObjectType>>;

        #[unsafe(method(weakToWeakObjectsMapTable))]
        #[unsafe(method_family = none)]
        pub fn weakToWeakObjectsMapTable() -> Retained<NSMapTable<KeyType, ObjectType>>;

        #[cfg(feature = "NSPointerFunctions")]
        #[unsafe(method(keyPointerFunctions))]
        #[unsafe(method_family = none)]
        pub fn keyPointerFunctions(&self) -> Retained<NSPointerFunctions>;

        #[cfg(feature = "NSPointerFunctions")]
        #[unsafe(method(valuePointerFunctions))]
        #[unsafe(method_family = none)]
        pub fn valuePointerFunctions(&self) -> Retained<NSPointerFunctions>;

        #[unsafe(method(objectForKey:))]
        #[unsafe(method_family = none)]
        pub fn objectForKey(&self, a_key: Option<&KeyType>) -> Option<Retained<ObjectType>>;

        #[unsafe(method(removeObjectForKey:))]
        #[unsafe(method_family = none)]
        pub fn removeObjectForKey(&self, a_key: Option<&KeyType>);

        #[unsafe(method(setObject:forKey:))]
        #[unsafe(method_family = none)]
        pub fn setObject_forKey(&self, an_object: Option<&ObjectType>, a_key: Option<&KeyType>);

        #[unsafe(method(count))]
        #[unsafe(method_family = none)]
        pub fn count(&self) -> NSUInteger;

        #[cfg(feature = "NSEnumerator")]
        /// # Safety
        ///
        /// The returned enumerator's underlying collection should not be mutated while in use.
        #[unsafe(method(keyEnumerator))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEnumerator(&self) -> Retained<NSEnumerator<KeyType>>;

        #[cfg(feature = "NSEnumerator")]
        /// # Safety
        ///
        /// The returned enumerator's underlying collection should not be mutated while in use.
        #[unsafe(method(objectEnumerator))]
        #[unsafe(method_family = none)]
        pub unsafe fn objectEnumerator(&self) -> Option<Retained<NSEnumerator<ObjectType>>>;

        #[unsafe(method(removeAllObjects))]
        #[unsafe(method_family = none)]
        pub fn removeAllObjects(&self);

        #[cfg(feature = "NSDictionary")]
        #[unsafe(method(dictionaryRepresentation))]
        #[unsafe(method_family = none)]
        pub fn dictionaryRepresentation(&self) -> Retained<NSDictionary<KeyType, ObjectType>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl<KeyType: Message, ObjectType: Message> NSMapTable<KeyType, ObjectType> {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl<KeyType: Message, ObjectType: Message> DefaultRetained for NSMapTable<KeyType, ObjectType> {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// **************    void * Map table operations    ***************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmapenumerator?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct NSMapEnumerator {
    pub(crate) _pi: NSUInteger,
    pub(crate) _si: NSUInteger,
    pub(crate) _bs: *mut c_void,
}

unsafe impl Encode for NSMapEnumerator {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <NSUInteger>::ENCODING,
            <NSUInteger>::ENCODING,
            <*mut c_void>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for NSMapEnumerator {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// # Safety
    ///
    /// `table` generic should be of the correct type.
    pub fn NSResetMapTable(table: &NSMapTable);
}

/// # Safety
///
/// - `table1` generic should be of the correct type.
/// - `table2` generic should be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn NSCompareMapTables(
    table1: &NSMapTable,
    table2: &NSMapTable,
) -> bool {
    extern "C-unwind" {
        fn NSCompareMapTables(table1: &NSMapTable, table2: &NSMapTable) -> Bool;
    }
    unsafe { NSCompareMapTables(table1, table2) }.as_bool()
}

/// # Safety
///
/// - `table` generic should be of the correct type.
/// - `zone` must be a valid pointer or null.
#[cfg(feature = "NSZone")]
#[inline]
pub unsafe extern "C-unwind" fn NSCopyMapTableWithZone(
    table: &NSMapTable,
    zone: *mut NSZone,
) -> Retained<NSMapTable> {
    extern "C-unwind" {
        fn NSCopyMapTableWithZone(table: &NSMapTable, zone: *mut NSZone) -> *mut NSMapTable;
    }
    let ret = unsafe { NSCopyMapTableWithZone(table, zone) };
    unsafe { Retained::from_raw(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

/// # Safety
///
/// - `table` generic should be of the correct type.
/// - `key` must be a valid pointer.
/// - `original_key` must be a valid pointer or null.
/// - `value` must be a valid pointer or null.
#[inline]
pub unsafe extern "C-unwind" fn NSMapMember(
    table: &NSMapTable,
    key: NonNull<c_void>,
    original_key: *mut *mut c_void,
    value: *mut *mut c_void,
) -> bool {
    extern "C-unwind" {
        fn NSMapMember(
            table: &NSMapTable,
            key: NonNull<c_void>,
            original_key: *mut *mut c_void,
            value: *mut *mut c_void,
        ) -> Bool;
    }
    unsafe { NSMapMember(table, key, original_key, value) }.as_bool()
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `table` generic should be of the correct type.
    /// - `key` must be a valid pointer or null.
    pub fn NSMapGet(table: &NSMapTable, key: *const c_void) -> *mut c_void;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `table` generic should be of the correct type.
    /// - `key` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    pub fn NSMapInsert(table: &NSMapTable, key: *const c_void, value: *const c_void);
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `table` generic should be of the correct type.
    /// - `key` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    pub fn NSMapInsertKnownAbsent(table: &NSMapTable, key: *const c_void, value: *const c_void);
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `table` generic should be of the correct type.
    /// - `key` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    pub fn NSMapInsertIfAbsent(
        table: &NSMapTable,
        key: *const c_void,
        value: *const c_void,
    ) -> *mut c_void;
}

extern "C-unwind" {
    /// # Safety
    ///
    /// - `table` generic should be of the correct type.
    /// - `key` must be a valid pointer or null.
    pub fn NSMapRemove(table: &NSMapTable, key: *const c_void);
}

extern "C-unwind" {
    /// # Safety
    ///
    /// `table` generic should be of the correct type.
    pub fn NSEnumerateMapTable(table: &NSMapTable) -> NSMapEnumerator;
}

/// # Safety
///
/// - `enumerator` must be a valid pointer.
/// - `key` must be a valid pointer or null.
/// - `value` must be a valid pointer or null.
#[inline]
pub unsafe extern "C-unwind" fn NSNextMapEnumeratorPair(
    enumerator: NonNull<NSMapEnumerator>,
    key: *mut *mut c_void,
    value: *mut *mut c_void,
) -> bool {
    extern "C-unwind" {
        fn NSNextMapEnumeratorPair(
            enumerator: NonNull<NSMapEnumerator>,
            key: *mut *mut c_void,
            value: *mut *mut c_void,
        ) -> Bool;
    }
    unsafe { NSNextMapEnumeratorPair(enumerator, key, value) }.as_bool()
}

extern "C-unwind" {
    /// # Safety
    ///
    /// `enumerator` must be a valid pointer.
    pub fn NSEndMapTableEnumeration(enumerator: NonNull<NSMapEnumerator>);
}

extern "C-unwind" {
    /// # Safety
    ///
    /// `table` generic should be of the correct type.
    pub fn NSCountMapTable(table: &NSMapTable) -> NSUInteger;
}

#[cfg(feature = "NSString")]
impl NSString {
    /// # Safety
    ///
    /// `table` generic should be of the correct type.
    #[doc(alias = "NSStringFromMapTable")]
    #[cfg(feature = "NSString")]
    #[inline]
    pub unsafe fn from_map_table(table: &NSMapTable) -> Retained<NSString> {
        extern "C-unwind" {
            fn NSStringFromMapTable(table: &NSMapTable) -> *mut NSString;
        }
        let ret = unsafe { NSStringFromMapTable(table) };
        unsafe { Retained::retain_autoreleased(ret) }
            .expect("function was marked as returning non-null, but actually returned NULL")
    }
}

/// # Safety
///
/// `table` generic should be of the correct type.
#[cfg(feature = "NSArray")]
#[inline]
pub unsafe extern "C-unwind" fn NSAllMapTableKeys(table: &NSMapTable) -> Retained<NSArray> {
    extern "C-unwind" {
        fn NSAllMapTableKeys(table: &NSMapTable) -> *mut NSArray;
    }
    let ret = unsafe { NSAllMapTableKeys(table) };
    unsafe { Retained::retain_autoreleased(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

/// # Safety
///
/// `table` generic should be of the correct type.
#[cfg(feature = "NSArray")]
#[inline]
pub unsafe extern "C-unwind" fn NSAllMapTableValues(table: &NSMapTable) -> Retained<NSArray> {
    extern "C-unwind" {
        fn NSAllMapTableValues(table: &NSMapTable) -> *mut NSArray;
    }
    let ret = unsafe { NSAllMapTableValues(table) };
    unsafe { Retained::retain_autoreleased(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

/// **************     Legacy     **************************************
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptablekeycallbacks?language=objc)
#[cfg(feature = "NSString")]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct NSMapTableKeyCallBacks {
    pub hash:
        Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>) -> NSUInteger>,
    pub isEqual: Option<
        unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>, NonNull<c_void>) -> Bool,
    >,
    pub retain: Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>)>,
    pub release: Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>)>,
    pub describe:
        Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>) -> *mut NSString>,
    pub notAKeyMarker: *const c_void,
}

#[cfg(feature = "NSString")]
unsafe impl Encode for NSMapTableKeyCallBacks {
    const ENCODING: Encoding = Encoding::Struct("?", &[
        <Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>,NonNull<c_void>,) -> NSUInteger>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>,NonNull<c_void>,NonNull<c_void>,) -> Bool>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>,NonNull<c_void>,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>,NonNull<c_void>,)>>::ENCODING,
        <Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>,NonNull<c_void>,) -> *mut NSString>>::ENCODING,
        <*const c_void>::ENCODING,
    ]);
}

#[cfg(feature = "NSString")]
unsafe impl RefEncode for NSMapTableKeyCallBacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmaptablevaluecallbacks?language=objc)
#[cfg(feature = "NSString")]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct NSMapTableValueCallBacks {
    pub retain: Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>)>,
    pub release: Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>)>,
    pub describe:
        Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>) -> *mut NSString>,
}

#[cfg(feature = "NSString")]
unsafe impl Encode for NSMapTableValueCallBacks {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>)>>::ENCODING,
            <Option<unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>)>>::ENCODING,
            <Option<
                unsafe extern "C-unwind" fn(NonNull<NSMapTable>, NonNull<c_void>) -> *mut NSString,
            >>::ENCODING,
        ],
    );
}

#[cfg(feature = "NSString")]
unsafe impl RefEncode for NSMapTableValueCallBacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// # Safety
///
/// - `key_call_backs` struct field 1 must be implemented correctly.
/// - `key_call_backs` struct field 2 must be implemented correctly.
/// - `key_call_backs` struct field 3 must be implemented correctly.
/// - `key_call_backs` struct field 4 must be implemented correctly.
/// - `key_call_backs` struct field 5 must be implemented correctly.
/// - `key_call_backs` struct field 6 must be a valid pointer or null.
/// - `value_call_backs` struct field 1 must be implemented correctly.
/// - `value_call_backs` struct field 2 must be implemented correctly.
/// - `value_call_backs` struct field 3 must be implemented correctly.
/// - `zone` must be a valid pointer or null.
#[cfg(all(feature = "NSString", feature = "NSZone"))]
#[inline]
pub unsafe extern "C-unwind" fn NSCreateMapTableWithZone(
    key_call_backs: NSMapTableKeyCallBacks,
    value_call_backs: NSMapTableValueCallBacks,
    capacity: NSUInteger,
    zone: *mut NSZone,
) -> Retained<NSMapTable> {
    extern "C-unwind" {
        fn NSCreateMapTableWithZone(
            key_call_backs: NSMapTableKeyCallBacks,
            value_call_backs: NSMapTableValueCallBacks,
            capacity: NSUInteger,
            zone: *mut NSZone,
        ) -> *mut NSMapTable;
    }
    let ret = unsafe { NSCreateMapTableWithZone(key_call_backs, value_call_backs, capacity, zone) };
    unsafe { Retained::from_raw(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

/// # Safety
///
/// - `key_call_backs` struct field 1 must be implemented correctly.
/// - `key_call_backs` struct field 2 must be implemented correctly.
/// - `key_call_backs` struct field 3 must be implemented correctly.
/// - `key_call_backs` struct field 4 must be implemented correctly.
/// - `key_call_backs` struct field 5 must be implemented correctly.
/// - `key_call_backs` struct field 6 must be a valid pointer or null.
/// - `value_call_backs` struct field 1 must be implemented correctly.
/// - `value_call_backs` struct field 2 must be implemented correctly.
/// - `value_call_backs` struct field 3 must be implemented correctly.
#[cfg(feature = "NSString")]
#[inline]
pub unsafe extern "C-unwind" fn NSCreateMapTable(
    key_call_backs: NSMapTableKeyCallBacks,
    value_call_backs: NSMapTableValueCallBacks,
    capacity: NSUInteger,
) -> Retained<NSMapTable> {
    extern "C-unwind" {
        fn NSCreateMapTable(
            key_call_backs: NSMapTableKeyCallBacks,
            value_call_backs: NSMapTableValueCallBacks,
            capacity: NSUInteger,
        ) -> *mut NSMapTable;
    }
    let ret = unsafe { NSCreateMapTable(key_call_backs, value_call_backs, capacity) };
    unsafe { Retained::from_raw(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}

extern "C" {
    /// **************    Common map table key callbacks    ***************
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsintegermapkeycallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSIntegerMapKeyCallBacks: NSMapTableKeyCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnonownedpointermapkeycallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSNonOwnedPointerMapKeyCallBacks: NSMapTableKeyCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnonownedpointerornullmapkeycallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSNonOwnedPointerOrNullMapKeyCallBacks: NSMapTableKeyCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnonretainedobjectmapkeycallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSNonRetainedObjectMapKeyCallBacks: NSMapTableKeyCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsobjectmapkeycallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSObjectMapKeyCallBacks: NSMapTableKeyCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsownedpointermapkeycallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSOwnedPointerMapKeyCallBacks: NSMapTableKeyCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsintmapkeycallbacks?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated = "Not supported"]
    pub static NSIntMapKeyCallBacks: NSMapTableKeyCallBacks;
}

extern "C" {
    /// **************    Common map table value callbacks    ***************
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsintegermapvaluecallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSIntegerMapValueCallBacks: NSMapTableValueCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnonownedpointermapvaluecallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSNonOwnedPointerMapValueCallBacks: NSMapTableValueCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsobjectmapvaluecallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSObjectMapValueCallBacks: NSMapTableValueCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnonretainedobjectmapvaluecallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSNonRetainedObjectMapValueCallBacks: NSMapTableValueCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsownedpointermapvaluecallbacks?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSOwnedPointerMapValueCallBacks: NSMapTableValueCallBacks;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsintmapvaluecallbacks?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated = "Not supported"]
    pub static NSIntMapValueCallBacks: NSMapTableValueCallBacks;
}

#[cfg(feature = "NSString")]
#[deprecated = "renamed to `NSString::from_map_table`"]
#[inline]
pub unsafe extern "C-unwind" fn NSStringFromMapTable(table: &NSMapTable) -> Retained<NSString> {
    extern "C-unwind" {
        fn NSStringFromMapTable(table: &NSMapTable) -> *mut NSString;
    }
    let ret = unsafe { NSStringFromMapTable(table) };
    unsafe { Retained::retain_autoreleased(ret) }
        .expect("function was marked as returning non-null, but actually returned NULL")
}
