dnl MHW_MOD_PARAM()
dnl $1 - name of this module
dnl $2 - name of required module to search for
dnl $3 - (optional) --help text for flag

AC_DEFUN(MHW_MOD_PARAM,
changequote(<<,>>)dnl
<<
AC_ARG_WITH($2, [  --with-]builtin(format, %-17s, $2=DIR)ifelse($3, , [look for ]$2[ in DIR], $3),
[if test "$withval" = no; then
  AC_MSG_WARN(can't configure $1 without $2)
  mhw_mod_$2_path=yes
else
  mhw_mod_$2_path=$withval
fi], mhw_mod_$2_path=yes)
>>dnl
changequote([,])dnl
)


dnl MHW_MOD_DOSEARCH()
dnl $1 - name of required module to search for
dnl $2 - name of module component to search for
dnl $3 - description of module component for user visible messages
dnl $4 - list of filenames to search for
dnl $5 - default list of root directories to search (wildcards ok)
dnl $6 - (optional) directories to try within the root directories

AC_DEFUN(MHW_MOD_DOSEARCH,
changequote(<<,>>)dnl
<<
AC_CACHE_CHECK(for $3 nearby, mhw_cv_mod_$1_$2_path,
changequote(<<,>>)dnl
<<
if test "$mhw_mod_$1_path" = yes; then
  mhw_roots="$5"
else
  mhw_roots=$mhw_mod_$1_path
fi
for rt in `echo $mhw_roots`
do
  complete=yes
  mhw_cv_mod_$1_$2_path=''>>dnl
ifelse($6, ,dnl
<<
  found=$rt
  for fn in $4
  do
    if test ! -f $rt/$fn; then
      complete=no
      break
    fi
  done
  if test "$complete" = yes; then
    mhw_cv_mod_$1_$2_path=$found
    break
  fi>>,
<<
  for fn in $4
  do
    found=no
    for dir in $6
    do
      if test -f $rt/$dir/$fn; then
	found="$rt/$dir"
	break
      fi
    done
    if test "$found" = no; then
      complete=no
      break
    fi
    mhw_add=yes
    for mhw_dir in $mhw_cv_mod_$1_$2_path
    do
      test "$mhw_dir" = "$found" && mhw_add=no
    done
    if test "$mhw_add" = yes; then
      mhw_cv_mod_$1_$2_path="$mhw_cv_mod_$1_$2_path $found"
    fi
  done
  if test "$complete" = yes; then
    break
  fi>>)
<<done
if test "X$mhw_cv_mod_$1_$2_path" = "X"; then
  mhw_cv_mod_$1_$2_path=no
fi
>>dnl
changequote([,])dnl
)
mhw_mod_$1_$2_path=$mhw_cv_mod_$1_$2_path
>>dnl
changequote([,])dnl
)
