/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerMap {
    private final @Nullable VelocityServer server;
    private final Map<String, RegisteredServer> servers = new ConcurrentHashMap<String, RegisteredServer>();

    public ServerMap(@Nullable VelocityServer server) {
        this.server = server;
    }

    public Optional<RegisteredServer> getServer(String name) {
        Preconditions.checkNotNull(name, "server");
        String lowerName = name.toLowerCase(Locale.US);
        return Optional.ofNullable(this.servers.get(lowerName));
    }

    public Collection<RegisteredServer> getAllServers() {
        return ImmutableList.copyOf(this.servers.values());
    }

    public RegisteredServer register(ServerInfo serverInfo) {
        Preconditions.checkNotNull(serverInfo, "serverInfo");
        String lowerName = serverInfo.getName().toLowerCase(Locale.US);
        VelocityRegisteredServer rs = new VelocityRegisteredServer(this.server, serverInfo);
        RegisteredServer existing = this.servers.putIfAbsent(lowerName, rs);
        if (existing != null && !existing.getServerInfo().equals(serverInfo)) {
            throw new IllegalArgumentException("Server with name " + serverInfo.getName() + " already registered");
        }
        if (existing == null) {
            return rs;
        }
        return existing;
    }

    public void unregister(ServerInfo serverInfo) {
        Preconditions.checkNotNull(serverInfo, "serverInfo");
        String lowerName = serverInfo.getName().toLowerCase(Locale.US);
        RegisteredServer rs = this.servers.get(lowerName);
        if (rs == null) {
            throw new IllegalArgumentException("Server with name " + serverInfo.getName() + " is not registered!");
        }
        Preconditions.checkArgument(rs.getServerInfo().equals(serverInfo), "Trying to remove server %s with differing information", (Object)serverInfo.getName());
        Preconditions.checkState(this.servers.remove(lowerName, rs), "Server with name %s replaced whilst unregistering", (Object)serverInfo.getName());
    }
}

