/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.event.method.asm;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.event.method.EventExecutor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ASMEventExecutorFactory<E, L>
implements EventExecutor.Factory<E, L> {
    private static final String PACKAGE = "net.kyori.event.asm.generated";
    private static final String SUPER_NAME = "java/lang/Object";
    private static final String EXECUTE_DESC = "(Ljava/lang/Object;Ljava/lang/Object;)V";
    private static final String[] GENERATED_EVENT_EXECUTOR_NAME = new String[]{Type.getInternalName(EventExecutor.class)};
    private final String session = UUID.randomUUID().toString().substring(26);
    private final AtomicInteger id = new AtomicInteger();
    private final DefiningClassLoader eventExecutorClassLoader;
    private final LoadingCache<Method, Class<? extends EventExecutor<E, L>>> cache;

    public ASMEventExecutorFactory() {
        this(ASMEventExecutorFactory.class.getClassLoader());
    }

    public ASMEventExecutorFactory(@NonNull ClassLoader parent) {
        this.eventExecutorClassLoader = new DefiningClassLoader(parent);
        this.cache = CacheBuilder.newBuilder().initialCapacity(16).weakValues().build(CacheLoader.from(method -> {
            Objects.requireNonNull(method, "method");
            Class<?> listener = method.getDeclaringClass();
            String listenerName = Type.getInternalName(listener);
            Class<?> parameter = method.getParameterTypes()[0];
            String className = this.executorClassName(listener, (Method)method, parameter);
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 17, className.replace('.', '/'), null, SUPER_NAME, GENERATED_EVENT_EXECUTOR_NAME);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, SUPER_NAME, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(1, "invoke", EXECUTE_DESC, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, listenerName);
            mv.visitVarInsn(25, 2);
            mv.visitTypeInsn(192, Type.getInternalName(parameter));
            mv.visitMethodInsn(182, listenerName, method.getName(), Type.getMethodDescriptor(method), false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            return this.eventExecutorClassLoader.defineClass(className, cw.toByteArray());
        }));
    }

    private String executorClassName(Class<?> listener, Method method, Class<?> parameter) {
        return String.format("%s.%s.%s-%s-%s-%d", PACKAGE, this.session, listener.getSimpleName(), method.getName(), parameter.getSimpleName(), this.id.incrementAndGet());
    }

    @Override
    public @NonNull EventExecutor<E, L> create(@NonNull Object object, @NonNull Method method) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (!Modifier.isPublic(object.getClass().getModifiers())) {
            throw new IllegalArgumentException(String.format("Listener class '%s' must be public", object.getClass().getName()));
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException(String.format("Subscriber method '%s' must be public", method));
        }
        return this.cache.getUnchecked(method).newInstance();
    }

    private static final class DefiningClassLoader
    extends ClassLoader {
        private DefiningClassLoader(ClassLoader parent) {
            super(parent);
        }

        <T> Class<T> defineClass(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }
}

