/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.util.Hex;

public class IdentityKey {
    private final ECPublicKey publicKey;

    public IdentityKey(ECPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public IdentityKey(byte[] bytes, int offset) throws InvalidKeyException {
        this.publicKey = Curve.decodePoint(bytes, offset);
    }

    public IdentityKey(byte[] bytes) throws InvalidKeyException {
        this.publicKey = Curve.decodePoint(bytes, 0);
    }

    public IdentityKey(long nativeHandle) {
        this.publicKey = new ECPublicKey(nativeHandle);
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] serialize() {
        return this.publicKey.serialize();
    }

    public String getFingerprint() {
        return Hex.toString(this.publicKey.serialize());
    }

    public boolean verifyAlternateIdentity(IdentityKey other, byte[] signature) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this.publicKey);){
            NativeHandleGuard otherGuard = new NativeHandleGuard(other.publicKey);
            try {
                boolean bl = FilterExceptions.filterExceptions(() -> Native.IdentityKey_VerifyAlternateIdentity(guard.nativeHandle(), otherGuard.nativeHandle(), signature));
                otherGuard.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    otherGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IdentityKey)) {
            return false;
        }
        return this.publicKey.equals(((IdentityKey)other).getPublicKey());
    }

    public int hashCode() {
        return this.publicKey.hashCode();
    }
}

