/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.signal.libsignal.metadata.InvalidMetadataMessageException;
import org.signal.libsignal.metadata.InvalidMetadataVersionException;
import org.signal.libsignal.metadata.ProtocolDuplicateMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyException;
import org.signal.libsignal.metadata.ProtocolInvalidKeyIdException;
import org.signal.libsignal.metadata.ProtocolInvalidMessageException;
import org.signal.libsignal.metadata.ProtocolInvalidVersionException;
import org.signal.libsignal.metadata.ProtocolLegacyMessageException;
import org.signal.libsignal.metadata.ProtocolNoSessionException;
import org.signal.libsignal.metadata.ProtocolUntrustedIdentityException;
import org.signal.libsignal.metadata.SealedSessionCipher;
import org.signal.libsignal.metadata.SelfSendException;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.DuplicateMessageException;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.InvalidSessionException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SessionCipher;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.groups.GroupCipher;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.PlaintextContent;
import org.signal.libsignal.protocol.message.PreKeySignalMessage;
import org.signal.libsignal.protocol.message.SignalMessage;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.EnvelopeContent;
import org.whispersystems.signalservice.api.crypto.EnvelopeMetadata;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.crypto.SignalGroupCipher;
import org.whispersystems.signalservice.api.crypto.SignalSealedSessionCipher;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipherResult;
import org.whispersystems.signalservice.api.crypto.SignalSessionCipher;
import org.whispersystems.signalservice.api.messages.SignalServiceMetadata;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.push.Content;
import org.whispersystems.signalservice.internal.push.Envelope;
import org.whispersystems.signalservice.internal.push.OutgoingPushMessage;
import org.whispersystems.signalservice.internal.push.PushTransportDetails;

public class SignalServiceCipher {
    private static final String TAG = SignalServiceCipher.class.getSimpleName();
    private final SignalServiceAccountDataStore signalProtocolStore;
    private final SignalSessionLock sessionLock;
    private final SignalServiceAddress localAddress;
    private final int localDeviceId;
    private final CertificateValidator certificateValidator;

    public SignalServiceCipher(SignalServiceAddress localAddress, int localDeviceId, SignalServiceAccountDataStore signalProtocolStore, SignalSessionLock sessionLock, CertificateValidator certificateValidator) {
        this.signalProtocolStore = signalProtocolStore;
        this.sessionLock = sessionLock;
        this.localAddress = localAddress;
        this.localDeviceId = localDeviceId;
        this.certificateValidator = certificateValidator;
    }

    public byte[] encryptForGroup(DistributionId distributionId, List<SignalProtocolAddress> destinations, Map<SignalProtocolAddress, SessionRecord> sessionMap, SenderCertificate senderCertificate, byte[] unpaddedMessage, ContentHint contentHint, Optional<byte[]> groupId2) throws NoSessionException, UntrustedIdentityException, InvalidKeyException, InvalidRegistrationIdException {
        PushTransportDetails transport = new PushTransportDetails();
        SignalProtocolAddress localProtocolAddress = new SignalProtocolAddress(this.localAddress.getIdentifier(), this.localDeviceId);
        SignalGroupCipher groupCipher = new SignalGroupCipher(this.sessionLock, new GroupCipher((SenderKeyStore)this.signalProtocolStore, localProtocolAddress));
        SignalSealedSessionCipher sessionCipher = new SignalSealedSessionCipher(this.sessionLock, new SealedSessionCipher((SignalProtocolStore)this.signalProtocolStore, this.localAddress.getServiceId().getRawUuid(), (String)this.localAddress.getNumber().orElse(null), this.localDeviceId));
        CiphertextMessage message = groupCipher.encrypt(distributionId.asUuid(), transport.getPaddedMessageBody(unpaddedMessage));
        UnidentifiedSenderMessageContent messageContent = new UnidentifiedSenderMessageContent(message, senderCertificate, contentHint.getType(), groupId2);
        return sessionCipher.multiRecipientEncrypt(destinations, sessionMap, messageContent);
    }

    public OutgoingPushMessage encrypt(SignalProtocolAddress destination, @Nullable SealedSenderAccess sealedSenderAccess, EnvelopeContent content) throws UntrustedIdentityException, InvalidKeyException {
        try {
            SignalSessionCipher sessionCipher = new SignalSessionCipher(this.sessionLock, new SessionCipher((SignalProtocolStore)this.signalProtocolStore, destination));
            if (sealedSenderAccess != null) {
                SignalSealedSessionCipher sealedSessionCipher = new SignalSealedSessionCipher(this.sessionLock, new SealedSessionCipher((SignalProtocolStore)this.signalProtocolStore, this.localAddress.getServiceId().getRawUuid(), (String)this.localAddress.getNumber().orElse(null), this.localDeviceId));
                return content.processSealedSender(sessionCipher, sealedSessionCipher, destination, sealedSenderAccess.getSenderCertificate());
            }
            return content.processUnsealedSender(sessionCipher, destination);
        }
        catch (NoSessionException e) {
            throw new InvalidSessionException("Session not found.");
        }
    }

    public SignalServiceCipherResult decrypt(Envelope envelope, long serverDeliveredTimestamp) throws InvalidMetadataMessageException, InvalidMetadataVersionException, ProtocolInvalidKeyIdException, ProtocolLegacyMessageException, ProtocolUntrustedIdentityException, ProtocolNoSessionException, ProtocolInvalidVersionException, ProtocolInvalidMessageException, ProtocolInvalidKeyException, ProtocolDuplicateMessageException, SelfSendException, InvalidMessageStructureException {
        try {
            if (envelope.content != null) {
                Plaintext plaintext = this.decryptInternal(envelope, serverDeliveredTimestamp);
                Content content = (Content)((Object)Content.ADAPTER.decode(plaintext.getData()));
                return new SignalServiceCipherResult(content, new EnvelopeMetadata(plaintext.metadata.getSender().getServiceId(), plaintext.metadata.getSender().getNumber().orElse(null), plaintext.metadata.getSenderDevice(), plaintext.metadata.isNeedsReceipt(), plaintext.metadata.getGroupId().orElse(null), this.localAddress.getServiceId()));
            }
            return null;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new InvalidMetadataMessageException(e);
        }
    }

    private Plaintext decryptInternal(Envelope envelope, long serverDeliveredTimestamp) throws InvalidMetadataMessageException, InvalidMetadataVersionException, ProtocolDuplicateMessageException, ProtocolUntrustedIdentityException, ProtocolLegacyMessageException, ProtocolInvalidKeyException, ProtocolInvalidVersionException, ProtocolInvalidMessageException, ProtocolInvalidKeyIdException, ProtocolNoSessionException, SelfSendException, InvalidMessageStructureException {
        try {
            SignalServiceMetadata metadata;
            byte[] paddedMessage;
            if (envelope.sourceServiceId == null && envelope.type != Envelope.Type.UNIDENTIFIED_SENDER) {
                throw new InvalidMessageStructureException("Non-UD envelope is missing a UUID!");
            }
            if (envelope.type == Envelope.Type.PREKEY_BUNDLE) {
                sourceAddress = new SignalProtocolAddress(envelope.sourceServiceId, envelope.sourceDevice.intValue());
                sessionCipher = new SignalSessionCipher(this.sessionLock, new SessionCipher((SignalProtocolStore)this.signalProtocolStore, sourceAddress));
                paddedMessage = sessionCipher.decrypt(new PreKeySignalMessage(envelope.content.toByteArray()));
                metadata = new SignalServiceMetadata(SignalServiceCipher.getSourceAddress(envelope), envelope.sourceDevice, envelope.timestamp, envelope.serverTimestamp, serverDeliveredTimestamp, false, envelope.serverGuid, Optional.empty(), envelope.destinationServiceId);
                this.signalProtocolStore.clearSenderKeySharedWith(Collections.singleton(sourceAddress));
            } else if (envelope.type == Envelope.Type.CIPHERTEXT) {
                sourceAddress = new SignalProtocolAddress(envelope.sourceServiceId, envelope.sourceDevice.intValue());
                sessionCipher = new SignalSessionCipher(this.sessionLock, new SessionCipher((SignalProtocolStore)this.signalProtocolStore, sourceAddress));
                paddedMessage = sessionCipher.decrypt(new SignalMessage(envelope.content.toByteArray()));
                metadata = new SignalServiceMetadata(SignalServiceCipher.getSourceAddress(envelope), envelope.sourceDevice, envelope.timestamp, envelope.serverTimestamp, serverDeliveredTimestamp, false, envelope.serverGuid, Optional.empty(), envelope.destinationServiceId);
            } else if (envelope.type == Envelope.Type.PLAINTEXT_CONTENT) {
                paddedMessage = new PlaintextContent(envelope.content.toByteArray()).getBody();
                metadata = new SignalServiceMetadata(SignalServiceCipher.getSourceAddress(envelope), envelope.sourceDevice, envelope.timestamp, envelope.serverTimestamp, serverDeliveredTimestamp, false, envelope.serverGuid, Optional.empty(), envelope.destinationServiceId);
            } else if (envelope.type == Envelope.Type.UNIDENTIFIED_SENDER) {
                SignalSealedSessionCipher sealedSessionCipher = new SignalSealedSessionCipher(this.sessionLock, new SealedSessionCipher((SignalProtocolStore)this.signalProtocolStore, this.localAddress.getServiceId().getRawUuid(), (String)this.localAddress.getNumber().orElse(null), this.localDeviceId));
                SealedSessionCipher.DecryptionResult result2 = sealedSessionCipher.decrypt(this.certificateValidator, envelope.content.toByteArray(), envelope.serverTimestamp);
                SignalServiceAddress resultAddress = new SignalServiceAddress((ServiceId)ServiceId.ACI.parseOrThrow(result2.getSenderUuid()), result2.getSenderE164());
                Optional groupId2 = result2.getGroupId();
                boolean needsReceipt = true;
                if (envelope.sourceServiceId != null) {
                    Log.w((String)TAG, (String)("[" + envelope.timestamp + "] Received a UD-encrypted message sent over an identified channel. Marking as needsReceipt=false"));
                    needsReceipt = false;
                }
                if (result2.getCiphertextMessageType() == 3) {
                    this.signalProtocolStore.clearSenderKeySharedWith(Collections.singleton(new SignalProtocolAddress(result2.getSenderUuid(), result2.getDeviceId())));
                }
                paddedMessage = result2.getPaddedMessage();
                metadata = new SignalServiceMetadata(resultAddress, result2.getDeviceId(), envelope.timestamp, envelope.serverTimestamp, serverDeliveredTimestamp, needsReceipt, envelope.serverGuid, groupId2, envelope.destinationServiceId);
            } else {
                throw new InvalidMetadataMessageException("Unknown type: " + String.valueOf((Object)envelope.type));
            }
            PushTransportDetails transportDetails = new PushTransportDetails();
            byte[] data = transportDetails.getStrippedPaddingMessageBody(paddedMessage);
            return new Plaintext(metadata, data);
        }
        catch (DuplicateMessageException e) {
            throw new ProtocolDuplicateMessageException((Exception)((Object)e), envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
        catch (LegacyMessageException e) {
            throw new ProtocolLegacyMessageException(e, envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
        catch (InvalidMessageException e) {
            throw new ProtocolInvalidMessageException(e, envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
        catch (InvalidKeyIdException e) {
            throw new ProtocolInvalidKeyIdException((Exception)((Object)e), envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
        catch (InvalidKeyException e) {
            throw new ProtocolInvalidKeyException(e, envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
        catch (UntrustedIdentityException e) {
            throw new ProtocolUntrustedIdentityException(e, envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
        catch (InvalidVersionException e) {
            throw new ProtocolInvalidVersionException(e, envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
        catch (NoSessionException e) {
            throw new ProtocolNoSessionException(e, envelope.sourceServiceId, envelope.sourceDevice.intValue());
        }
    }

    private static SignalServiceAddress getSourceAddress(Envelope envelope) {
        return new SignalServiceAddress(ServiceId.parseOrNull(envelope.sourceServiceId));
    }

    private static class Plaintext {
        private final SignalServiceMetadata metadata;
        private final byte[] data;

        private Plaintext(SignalServiceMetadata metadata, byte[] data) {
            this.metadata = metadata;
            this.data = data;
        }

        public SignalServiceMetadata getMetadata() {
            return this.metadata;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

