/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.websocket;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.net.ChatService;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.util.CompletableFutureExtensionsKt;
import org.whispersystems.signalservice.internal.websocket.OkHttpWebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.Snapshot;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketShadowingBridge;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u000245BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0003H\u0016J\"\u0010(\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020\u001fH\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020\rH\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/ShadowingWebSocketConnection;", "Lorg/whispersystems/signalservice/internal/websocket/OkHttpWebSocketConnection;", "name", "", "serviceConfiguration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "credentialsProvider", "Ljava/util/Optional;", "Lorg/whispersystems/signalservice/api/util/CredentialsProvider;", "signalAgent", "healthMonitor", "Lorg/whispersystems/signalservice/api/websocket/HealthMonitor;", "allowStories", "", "chatService", "Lorg/signal/libsignal/net/ChatService;", "shadowPercentage", "", "bridge", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketShadowingBridge;", "(Ljava/lang/String;Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;Ljava/util/Optional;Ljava/lang/String;Lorg/whispersystems/signalservice/api/websocket/HealthMonitor;ZLorg/signal/libsignal/net/ChatService;ILorg/whispersystems/signalservice/internal/websocket/WebSocketShadowingBridge;)V", "canShadow", "Ljava/util/concurrent/atomic/AtomicBoolean;", "executor", "Ljava/util/concurrent/ExecutorService;", "stats", "Lorg/whispersystems/signalservice/internal/websocket/ShadowingWebSocketConnection$Stats;", "connect", "Lio/reactivex/rxjava3/core/Observable;", "Lorg/whispersystems/signalservice/api/websocket/WebSocketConnectionState;", "disconnect", "", "libsignalKeepAlive", "actualResponse", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "onClosing", "webSocket", "Lokhttp3/WebSocket;", "code", "reason", "onFailure", "t", "", "response", "Lokhttp3/Response;", "saveSnapshot", "sendRequest", "Lio/reactivex/rxjava3/core/Single;", "request", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "sendShadow", "shouldSubmitLogs", "Companion", "Stats", "signal-service-java"})
public final class ShadowingWebSocketConnection
extends OkHttpWebSocketConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    private final int shadowPercentage;
    @NotNull
    private final WebSocketShadowingBridge bridge;
    @NotNull
    private Stats stats;
    @NotNull
    private final AtomicBoolean canShadow;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private static final String TAG = Log.tag(ShadowingWebSocketConnection.class);
    private static final long FULL_DAY = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS);
    private static final int FAILURE_PERCENTAGE = 10;
    private static final long KEEP_ALIVE_TIMEOUT = DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS);
    private static final long SNAPSHOT_INTERVAL = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);

    /*
     * WARNING - void declaration
     */
    public ShadowingWebSocketConnection(@NotNull String name, @NotNull SignalServiceConfiguration serviceConfiguration, @NotNull Optional<CredentialsProvider> credentialsProvider, @NotNull String signalAgent, @NotNull HealthMonitor healthMonitor, boolean allowStories, @NotNull ChatService chatService, int shadowPercentage, @NotNull WebSocketShadowingBridge bridge) {
        Object object;
        ShadowingWebSocketConnection shadowingWebSocketConnection;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)serviceConfiguration, (String)"serviceConfiguration");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)signalAgent, (String)"signalAgent");
        Intrinsics.checkNotNullParameter((Object)healthMonitor, (String)"healthMonitor");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        super(name, serviceConfiguration, credentialsProvider, signalAgent, healthMonitor, allowStories);
        this.chatService = chatService;
        this.shadowPercentage = shadowPercentage;
        this.bridge = bridge;
        ShadowingWebSocketConnection shadowingWebSocketConnection2 = this;
        try {
            Object object2;
            block5: {
                Stats stats;
                block4: {
                    void it;
                    shadowingWebSocketConnection = shadowingWebSocketConnection2;
                    object2 = this.bridge.readStatsSnapshot();
                    if (object2 == null) break block4;
                    byte[] byArray = object2;
                    ShadowingWebSocketConnection shadowingWebSocketConnection3 = shadowingWebSocketConnection;
                    boolean bl = false;
                    Stats stats2 = Stats.Companion.fromSnapshot((byte[])it);
                    shadowingWebSocketConnection = shadowingWebSocketConnection3;
                    object2 = stats2;
                    if (stats2 != null) break block5;
                }
                object2 = stats;
                stats = new Stats(0, 0, 0, 0L, 15, null);
            }
            object = object2;
        }
        catch (Exception exception) {
            void ex;
            shadowingWebSocketConnection = shadowingWebSocketConnection2;
            Log.w((String)TAG, (String)"Failed to restore Stats from a snapshot.", (Throwable)((Throwable)ex));
            object = new Stats(0, 0, 0, 0L, 15, null);
        }
        shadowingWebSocketConnection.stats = object;
        this.canShadow = new AtomicBoolean(false);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.executor = executorService;
    }

    @Override
    @NotNull
    public Observable<WebSocketConnectionState> connect() {
        this.executor.submit(() -> ShadowingWebSocketConnection.connect$lambda$1(this));
        Observable<WebSocketConnectionState> observable = super.connect();
        Intrinsics.checkNotNullExpressionValue(observable, (String)"connect(...)");
        return observable;
    }

    @Override
    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.saveSnapshot();
        super.onClosing(webSocket, code, reason);
    }

    @Override
    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.saveSnapshot();
        super.onFailure(webSocket, t, response);
    }

    @Override
    public void disconnect() {
        this.executor.submit(() -> ShadowingWebSocketConnection.disconnect$lambda$3(this));
        super.disconnect();
    }

    @Override
    @NotNull
    public Single<WebsocketResponse> sendRequest(@NotNull WebSocketRequestMessage request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Single single = super.sendRequest(request).doOnSuccess(new Consumer(this){
            final /* synthetic */ ShadowingWebSocketConnection $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull WebsocketResponse p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ShadowingWebSocketConnection.access$sendShadow(this.$tmp0, p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"doOnSuccess(...)");
        return single;
    }

    private final void sendShadow(WebsocketResponse actualResponse) {
        this.executor.submit(() -> ShadowingWebSocketConnection.sendShadow$lambda$4(this, actualResponse));
    }

    private final boolean shouldSubmitLogs() {
        int requestsCompared = this.stats.getRequestsCompared().get();
        if (requestsCompared == 0) {
            return false;
        }
        long timeSinceLastNotificationMs = System.currentTimeMillis() - this.stats.getLastNotified().get();
        int percentFailed = this.stats.getFailures().get() * 100 / requestsCompared;
        return timeSinceLastNotificationMs > Duration.getInWholeMilliseconds-impl((long)FULL_DAY) && percentFailed > 10;
    }

    private final void libsignalKeepAlive(WebsocketResponse actualResponse) {
        ChatService.Request request = new ChatService.Request("GET", "/v1/keepalive", MapsKt.emptyMap(), new byte[0], (int)Duration.getInWholeMilliseconds-impl((long)KEEP_ALIVE_TIMEOUT));
        CompletableFuture completableFuture = this.chatService.unauthenticatedSendAndDebug(request);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"unauthenticatedSendAndDebug(...)");
        CompletableFutureExtensionsKt.whenComplete(completableFuture, (Function1)new Function1<ChatService.ResponseAndDebugInfo, Unit>(this){
            final /* synthetic */ ShadowingWebSocketConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable ChatService.ResponseAndDebugInfo it) {
                boolean goodStatus;
                int n;
                ShadowingWebSocketConnection.access$getStats$p(this.this$0).getRequestsCompared().incrementAndGet();
                ChatService.ResponseAndDebugInfo responseAndDebugInfo = it;
                int n2 = responseAndDebugInfo != null && (responseAndDebugInfo = responseAndDebugInfo.response()) != null ? responseAndDebugInfo.status() : (n = -1);
                boolean bl = 200 <= n ? n < 300 : (goodStatus = false);
                if (!goodStatus) {
                    ShadowingWebSocketConnection.access$getStats$p(this.this$0).getBadStatuses().incrementAndGet();
                }
                Log.i((String)ShadowingWebSocketConnection.access$getTAG$cp(), (String)String.valueOf(it));
            }
        }, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, actualResponse){
            final /* synthetic */ ShadowingWebSocketConnection this$0;
            final /* synthetic */ WebsocketResponse $actualResponse;
            {
                this.this$0 = $receiver;
                this.$actualResponse = $actualResponse;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ShadowingWebSocketConnection.access$getStats$p(this.this$0).getRequestsCompared().incrementAndGet();
                ShadowingWebSocketConnection.access$getStats$p(this.this$0).getFailures().incrementAndGet();
                Log.w((String)ShadowingWebSocketConnection.access$getTAG$cp(), (String)("Shadow request failed: reason=[" + it + "]"));
                Log.i((String)ShadowingWebSocketConnection.access$getTAG$cp(), (String)("Actual response status=" + this.$actualResponse.getStatus()));
                if (ShadowingWebSocketConnection.access$shouldSubmitLogs(this.this$0)) {
                    Log.i((String)ShadowingWebSocketConnection.access$getTAG$cp(), (String)"Notification to submit logs triggered.");
                    ShadowingWebSocketConnection.access$getBridge$p(this.this$0).triggerFailureNotification("Experimental websocket transport failures!");
                    ShadowingWebSocketConnection.access$getStats$p(this.this$0).reset();
                }
            }
        }));
    }

    private final void saveSnapshot() {
        this.executor.submit(() -> ShadowingWebSocketConnection.saveSnapshot$lambda$5(this));
    }

    private static final void connect$lambda$1(ShadowingWebSocketConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CompletableFuture completableFuture = this$0.chatService.connectUnauthenticated();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"connectUnauthenticated(...)");
        CompletableFutureExtensionsKt.whenComplete(completableFuture, (Function1)new Function1<ChatService.DebugInfo, Unit>(this$0){
            final /* synthetic */ ShadowingWebSocketConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable ChatService.DebugInfo it) {
                ShadowingWebSocketConnection.access$getCanShadow$p(this.this$0).set(true);
                Log.i((String)ShadowingWebSocketConnection.access$getTAG$cp(), (String)"Shadow socket connected.");
            }
        }, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this$0){
            final /* synthetic */ ShadowingWebSocketConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ShadowingWebSocketConnection.access$getCanShadow$p(this.this$0).set(false);
                Log.i((String)ShadowingWebSocketConnection.access$getTAG$cp(), (String)"Shadow socket failed to connect.");
            }
        }));
    }

    private static final Unit disconnect$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final void disconnect$lambda$3(ShadowingWebSocketConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.chatService.disconnect().thenApply(arg_0 -> ShadowingWebSocketConnection.disconnect$lambda$3$lambda$2((Function1)new Function1<Void, Unit>(this$0){
            final /* synthetic */ ShadowingWebSocketConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Void it) {
                ShadowingWebSocketConnection.access$getCanShadow$p(this.this$0).set(false);
                Log.i((String)ShadowingWebSocketConnection.access$getTAG$cp(), (String)"Shadow socket disconnected.");
            }
        }, arg_0));
    }

    private static final void sendShadow$lambda$4(ShadowingWebSocketConnection this$0, WebsocketResponse $actualResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$actualResponse, (String)"$actualResponse");
        if (this$0.canShadow.get() && Random.Default.nextInt(100) < this$0.shadowPercentage) {
            this$0.libsignalKeepAlive($actualResponse);
            long snapshotAge = System.currentTimeMillis() - this$0.stats.getLastSnapshot().get();
            if (snapshotAge > Duration.getInWholeMilliseconds-impl((long)SNAPSHOT_INTERVAL)) {
                this$0.saveSnapshot();
            }
        }
    }

    private static final void saveSnapshot$lambda$5(ShadowingWebSocketConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Log.d((String)TAG, (String)"Persisting shadowing stats snapshot.");
        this$0.bridge.writeStatsSnapshot(this$0.stats.snapshot());
    }

    public static final /* synthetic */ void access$sendShadow(ShadowingWebSocketConnection $this, WebsocketResponse actualResponse) {
        $this.sendShadow(actualResponse);
    }

    public static final /* synthetic */ Stats access$getStats$p(ShadowingWebSocketConnection $this) {
        return $this.stats;
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ boolean access$shouldSubmitLogs(ShadowingWebSocketConnection $this) {
        return $this.shouldSubmitLogs();
    }

    public static final /* synthetic */ WebSocketShadowingBridge access$getBridge$p(ShadowingWebSocketConnection $this) {
        return $this.bridge;
    }

    public static final /* synthetic */ AtomicBoolean access$getCanShadow$p(ShadowingWebSocketConnection $this) {
        return $this.canShadow;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/ShadowingWebSocketConnection$Companion;", "", "()V", "FAILURE_PERCENTAGE", "", "FULL_DAY", "Lkotlin/time/Duration;", "J", "KEEP_ALIVE_TIMEOUT", "SNAPSHOT_INTERVAL", "TAG", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/ShadowingWebSocketConnection$Stats;", "", "requestsCompared", "", "failures", "badStatuses", "lastNotified", "", "(IIIJ)V", "Ljava/util/concurrent/atomic/AtomicInteger;", "getBadStatuses", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getFailures", "Ljava/util/concurrent/atomic/AtomicLong;", "getLastNotified", "()Ljava/util/concurrent/atomic/AtomicLong;", "lastSnapshot", "getLastSnapshot", "getRequestsCompared", "reset", "", "snapshot", "", "Companion", "signal-service-java"})
    public static final class Stats {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AtomicInteger requestsCompared;
        @NotNull
        private final AtomicInteger failures;
        @NotNull
        private final AtomicInteger badStatuses;
        @NotNull
        private final AtomicLong lastNotified;
        @NotNull
        private final AtomicLong lastSnapshot;

        public Stats(int requestsCompared, int failures, int badStatuses, long lastNotified) {
            this.requestsCompared = new AtomicInteger(requestsCompared);
            this.failures = new AtomicInteger(failures);
            this.badStatuses = new AtomicInteger(badStatuses);
            this.lastNotified = new AtomicLong(lastNotified);
            this.lastSnapshot = new AtomicLong(0L);
        }

        public /* synthetic */ Stats(int n, int n2, int n3, long l, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            if ((n4 & 8) != 0) {
                l = 0L;
            }
            this(n, n2, n3, l);
        }

        @NotNull
        public final AtomicInteger getRequestsCompared() {
            return this.requestsCompared;
        }

        @NotNull
        public final AtomicInteger getFailures() {
            return this.failures;
        }

        @NotNull
        public final AtomicInteger getBadStatuses() {
            return this.badStatuses;
        }

        @NotNull
        public final AtomicLong getLastNotified() {
            return this.lastNotified;
        }

        @NotNull
        public final AtomicLong getLastSnapshot() {
            return this.lastSnapshot;
        }

        public final void reset() {
            this.requestsCompared.set(0);
            this.failures.set(0);
            this.badStatuses.set(0);
        }

        @NotNull
        public final byte[] snapshot() {
            this.lastSnapshot.set(System.currentTimeMillis());
            return new Snapshot.Builder().requestsCompared(this.requestsCompared.get()).failures(this.failures.get()).badStatuses(this.badStatuses.get()).lastNotified(this.lastNotified.get()).build().encode();
        }

        public Stats() {
            this(0, 0, 0, 0L, 15, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/ShadowingWebSocketConnection$Stats$Companion;", "", "()V", "fromSnapshot", "Lorg/whispersystems/signalservice/internal/websocket/ShadowingWebSocketConnection$Stats;", "bytes", "", "signal-service-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Stats fromSnapshot(@NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                Snapshot snapshot = (Snapshot)((Object)Snapshot.ADAPTER.decode(bytes));
                return new Stats(snapshot.requestsCompared, snapshot.failures, snapshot.badStatuses, snapshot.lastNotified);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

