/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcMultiLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;

public class ListAccountsCommand
implements JsonRpcMultiLocalCommand {
    @Override
    public String getName() {
        return "listAccounts";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Show a list of registered accounts.");
    }

    @Override
    public void handleCommand(Namespace ns, MultiAccountManager c, OutputWriter outputWriter) throws CommandException {
        List accountNumbers = c.getAccountNumbers();
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonWriter.class, PlainTextWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonWriter jsonWriter = (JsonWriter)outputWriter3;
                List<JsonAccount> jsonAccounts = accountNumbers.stream().map(JsonAccount::new).toList();
                jsonWriter.write(jsonAccounts);
                break;
            }
            case 1: {
                PlainTextWriter plainTextWriter = (PlainTextWriter)outputWriter3;
                for (String number : accountNumbers) {
                    plainTextWriter.println("Number: {}", number);
                }
            }
        }
    }

    private record JsonAccount(String number) {
    }
}

