/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.output;

import java.io.IOException;
import java.io.Writer;
import org.asamk.signal.output.PlainTextWriter;
import org.slf4j.helpers.MessageFormatter;

public final class PlainTextWriterImpl
implements PlainTextWriter {
    private final Writer writer;
    private PlainTextWriter indentedWriter;

    public PlainTextWriterImpl(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void println(String format, Object ... args) {
        String message = MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage();
        try {
            this.writer.write(message);
            this.writer.write(System.lineSeparator());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public PlainTextWriter indentedWriter() {
        if (this.indentedWriter == null) {
            this.indentedWriter = new IndentedPlainTextWriter(this, this.writer);
        }
        return this.indentedWriter;
    }

    private static final class IndentedPlainTextWriter
    implements PlainTextWriter {
        private static final int INDENTATION = 2;
        private final String spaces = " ".repeat(2);
        private final PlainTextWriter plainTextWriter;
        private final Writer writer;
        private PlainTextWriter indentedWriter;

        private IndentedPlainTextWriter(PlainTextWriter plainTextWriter, Writer writer) {
            this.plainTextWriter = plainTextWriter;
            this.writer = writer;
        }

        @Override
        public void println(String format, Object ... args) {
            try {
                this.writer.write(this.spaces);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.plainTextWriter.println(format, args);
        }

        @Override
        public PlainTextWriter indentedWriter() {
            if (this.indentedWriter == null) {
                this.indentedWriter = new IndentedPlainTextWriter(this, this.writer);
            }
            return this.indentedWriter;
        }
    }
}

