/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.internal.JobExecutor;
import org.asamk.signal.manager.jobs.CheckWhoAmIJob;
import org.asamk.signal.manager.jobs.DownloadProfileAvatarJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.util.OptionalUtil;
import org.whispersystems.signalservice.api.util.UuidUtil;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.OptionalBool;

public class AccountRecordProcessor
extends DefaultStorageRecordProcessor<SignalAccountRecord> {
    private static final Logger logger = LoggerFactory.getLogger(AccountRecordProcessor.class);
    private final SignalAccountRecord localAccountRecord;
    private final SignalAccount account;
    private final Connection connection;
    private final JobExecutor jobExecutor;

    public AccountRecordProcessor(SignalAccount account, Connection connection, JobExecutor jobExecutor) throws SQLException {
        this.account = account;
        this.connection = connection;
        this.jobExecutor = jobExecutor;
        RecipientId selfRecipientId = account.getSelfRecipientId();
        Recipient recipient = account.getRecipientStore().getRecipient(connection, selfRecipientId);
        StorageId storageId = account.getRecipientStore().getSelfStorageId(connection);
        this.localAccountRecord = (SignalAccountRecord)StorageSyncModels.localToRemoteRecord(account.getConfigurationStore(), recipient, account.getUsernameLink(), storageId.getRaw()).getAccount().get();
    }

    @Override
    protected boolean isInvalid(SignalAccountRecord remote) {
        return false;
    }

    @Override
    protected Optional<SignalAccountRecord> getMatching(SignalAccountRecord record) {
        return Optional.of(this.localAccountRecord);
    }

    @Override
    protected SignalAccountRecord merge(SignalAccountRecord remote, SignalAccountRecord local) {
        String familyName;
        String givenName;
        if (remote.getGivenName().isPresent() || remote.getFamilyName().isPresent()) {
            givenName = remote.getGivenName().orElse("");
            familyName = remote.getFamilyName().orElse("");
        } else {
            givenName = local.getGivenName().orElse("");
            familyName = local.getFamilyName().orElse("");
        }
        SignalAccountRecord.Payments payments = remote.getPayments().getEntropy().isPresent() ? remote.getPayments() : local.getPayments();
        SignalAccountRecord.Subscriber subscriber = remote.getSubscriber().getId().isPresent() ? remote.getSubscriber() : local.getSubscriber();
        OptionalBool storyViewReceiptsState = remote.getStoryViewReceiptsState() == OptionalBool.UNSET ? local.getStoryViewReceiptsState() : remote.getStoryViewReceiptsState();
        byte[] unknownFields = remote.serializeUnknownFields();
        String avatarUrlPath = OptionalUtil.or((Optional[])new Optional[]{remote.getAvatarUrlPath(), local.getAvatarUrlPath()}).orElse("");
        byte[] profileKey = OptionalUtil.or((Optional[])new Optional[]{remote.getProfileKey(), local.getProfileKey()}).orElse(null);
        boolean noteToSelfArchived = remote.isNoteToSelfArchived();
        boolean noteToSelfForcedUnread = remote.isNoteToSelfForcedUnread();
        boolean readReceipts = remote.isReadReceiptsEnabled();
        boolean typingIndicators = remote.isTypingIndicatorsEnabled();
        boolean sealedSenderIndicators = remote.isSealedSenderIndicatorsEnabled();
        boolean linkPreviews = remote.isLinkPreviewsEnabled();
        boolean unlisted = remote.isPhoneNumberUnlisted();
        List pinnedConversations = remote.getPinnedConversations();
        AccountRecord.PhoneNumberSharingMode phoneNumberSharingMode = remote.getPhoneNumberSharingMode();
        boolean preferContactAvatars = remote.isPreferContactAvatars();
        int universalExpireTimer = remote.getUniversalExpireTimer();
        String e164 = this.account.isPrimaryDevice() ? local.getE164() : remote.getE164();
        List defaultReactions = !remote.getDefaultReactions().isEmpty() ? remote.getDefaultReactions() : local.getDefaultReactions();
        boolean displayBadgesOnProfile = remote.isDisplayBadgesOnProfile();
        boolean subscriptionManuallyCancelled = remote.isSubscriptionManuallyCancelled();
        boolean keepMutedChatsArchived = remote.isKeepMutedChatsArchived();
        boolean hasSetMyStoriesPrivacy = remote.hasSetMyStoriesPrivacy();
        boolean hasViewedOnboardingStory = remote.hasViewedOnboardingStory() || local.hasViewedOnboardingStory();
        boolean storiesDisabled = remote.isStoriesDisabled();
        boolean hasSeenGroupStoryEducation = remote.hasSeenGroupStoryEducationSheet() || local.hasSeenGroupStoryEducationSheet();
        boolean hasSeenUsernameOnboarding = remote.hasCompletedUsernameOnboarding() || local.hasCompletedUsernameOnboarding();
        String username = remote.getUsername();
        AccountRecord.UsernameLink usernameLink = remote.getUsernameLink();
        SignalAccountRecord.Builder mergedBuilder = new SignalAccountRecord.Builder(remote.getId().getRaw(), unknownFields).setGivenName(givenName).setFamilyName(familyName).setAvatarUrlPath(avatarUrlPath).setProfileKey(profileKey).setNoteToSelfArchived(noteToSelfArchived).setNoteToSelfForcedUnread(noteToSelfForcedUnread).setReadReceiptsEnabled(readReceipts).setTypingIndicatorsEnabled(typingIndicators).setSealedSenderIndicatorsEnabled(sealedSenderIndicators).setLinkPreviewsEnabled(linkPreviews).setUnlistedPhoneNumber(unlisted).setPhoneNumberSharingMode(phoneNumberSharingMode).setPinnedConversations(pinnedConversations).setPreferContactAvatars(preferContactAvatars).setPayments(payments.isEnabled(), (byte[])payments.getEntropy().orElse(null)).setUniversalExpireTimer(universalExpireTimer).setDefaultReactions(defaultReactions).setSubscriber(subscriber).setDisplayBadgesOnProfile(displayBadgesOnProfile).setSubscriptionManuallyCancelled(subscriptionManuallyCancelled).setKeepMutedChatsArchived(keepMutedChatsArchived).setHasSetMyStoriesPrivacy(hasSetMyStoriesPrivacy).setHasViewedOnboardingStory(hasViewedOnboardingStory).setStoriesDisabled(storiesDisabled).setHasSeenGroupStoryEducationSheet(hasSeenGroupStoryEducation).setHasCompletedUsernameOnboarding(hasSeenUsernameOnboarding).setStoryViewReceiptsState(storyViewReceiptsState).setUsername(username).setUsernameLink(usernameLink).setE164(e164);
        SignalAccountRecord merged = mergedBuilder.build();
        boolean matchesRemote = AccountRecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remote;
        }
        boolean matchesLocal = AccountRecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return local;
        }
        return mergedBuilder.setId(KeyUtils.createRawStorageId()).build();
    }

    @Override
    protected void insertLocal(SignalAccountRecord record) {
        throw new UnsupportedOperationException("We should always have a local AccountRecord, so we should never been inserting a new one.");
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalAccountRecord> update) throws SQLException {
        Profile profile;
        SignalAccountRecord accountRecord = update.newRecord();
        if (!accountRecord.getE164().equals(this.account.getNumber())) {
            this.jobExecutor.enqueueJob(new CheckWhoAmIJob());
        }
        this.account.getConfigurationStore().setReadReceipts(this.connection, accountRecord.isReadReceiptsEnabled());
        this.account.getConfigurationStore().setTypingIndicators(this.connection, accountRecord.isTypingIndicatorsEnabled());
        this.account.getConfigurationStore().setUnidentifiedDeliveryIndicators(this.connection, accountRecord.isSealedSenderIndicatorsEnabled());
        this.account.getConfigurationStore().setLinkPreviews(this.connection, accountRecord.isLinkPreviewsEnabled());
        this.account.getConfigurationStore().setPhoneNumberSharingMode(this.connection, StorageSyncModels.remoteToLocal(accountRecord.getPhoneNumberSharingMode()));
        this.account.getConfigurationStore().setPhoneNumberUnlisted(this.connection, accountRecord.isPhoneNumberUnlisted());
        this.account.setUsername(accountRecord.getUsername() != null && !accountRecord.getUsername().isEmpty() ? accountRecord.getUsername() : null);
        if (accountRecord.getUsernameLink() != null) {
            AccountRecord.UsernameLink usernameLink = accountRecord.getUsernameLink();
            this.account.setUsernameLink(new UsernameLinkComponents(usernameLink.entropy.toByteArray(), UuidUtil.parseOrThrow((byte[])usernameLink.serverId.toByteArray())));
            this.account.getConfigurationStore().setUsernameLinkColor(this.connection, usernameLink.color.name());
        }
        if (accountRecord.getProfileKey().isPresent()) {
            ProfileKey profileKey;
            try {
                profileKey = new ProfileKey((byte[])accountRecord.getProfileKey().get());
            }
            catch (InvalidInputException e) {
                logger.debug("Received invalid profile key from storage");
                profileKey = null;
            }
            if (profileKey != null) {
                this.account.setProfileKey(profileKey);
                String avatarPath = accountRecord.getAvatarUrlPath().orElse(null);
                this.jobExecutor.enqueueJob(new DownloadProfileAvatarJob(avatarPath));
            }
        }
        Profile.Builder builder = (profile = this.account.getRecipientStore().getProfile(this.connection, this.account.getSelfRecipientId())) == null ? Profile.newBuilder() : Profile.newBuilder(profile);
        builder.withGivenName(accountRecord.getGivenName().orElse(null));
        builder.withFamilyName(accountRecord.getFamilyName().orElse(null));
        this.account.getRecipientStore().storeProfile(this.connection, this.account.getSelfRecipientId(), builder.build());
        this.account.getRecipientStore().storeStorageRecord(this.connection, this.account.getSelfRecipientId(), accountRecord.getId(), accountRecord.toProto().encode());
    }

    @Override
    public int compare(SignalAccountRecord lhs, SignalAccountRecord rhs) {
        return 0;
    }

    private static boolean doProtosMatch(SignalAccountRecord merged, SignalAccountRecord other) {
        return Arrays.equals(merged.toProto().encode(), other.toProto().encode());
    }
}

