#!/bin/sh

# Copyright (C) 2004, 2005 Valery Reznic
# This file is part of the Elf Statifier project
# 
# This project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License.
# See LICENSE file in the doc directory.

# Create spec file

[ $# -ne 5 -o "x$1" = "x" -o "x$2" = "x" -o "x$3" = "x" -o "x$4" = "x" -o "x$5" = "x" ] && {
	echo "Usage: $0 <spec_in> <filelist_file> <version_file> <release_file> <changelog>" 1>&2
	exit 1 
}

spec_in=$1
filelist_file=$2
version_file=$3
release_file=$4
changelog=$5

# Exit in first error
set -e

echo "#"
echo "# Don't change this file. It was autogenerated by '$0'"
echo "#"

Version=`cat $version_file`
Release=`cat $release_file`

echo "%define my_version $Version"
echo "%define my_release $Release"

echo
cat  $spec_in

echo
echo "%files"
# Remove first 3 comment's line (if any)
sed  -n -e '1,3s/^#.*$//;t' -e 'p' < $filelist_file

echo 
echo %changelog
cat $changelog

exit 0
