/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.skill;

import java.math.BigDecimal;
import pcgen.core.kit.KitSkill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RankToken
extends AbstractNonEmptyToken<KitSkill>
implements CDOMPrimaryToken<KitSkill> {
    public String getTokenName() {
        return "RANK";
    }

    public Class<KitSkill> getTokenClass() {
        return KitSkill.class;
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, KitSkill kitSkill, String value) {
        try {
            BigDecimal rank = new BigDecimal(value);
            if (rank.compareTo(BigDecimal.ZERO) < 0) {
                return new ParseResult.Fail(this.getTokenName() + " must be a positive number: " + value, context);
            }
            kitSkill.setRank(rank);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException e) {
            return new ParseResult.Fail(this.getTokenName() + " expected a number: " + value, context);
        }
    }

    public String[] unparse(LoadContext context, KitSkill kitSkill) {
        BigDecimal bd = kitSkill.getRank();
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }
}

