/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.SpellProhibitor;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;
import pcgen.util.enumeration.ProhibitedSpellType;

public class ProhibitspellToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "PROHIBITSPELL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        SpellProhibitor sp = this.subParse(value);
        if (sp == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        context.getObjectContext().addToList((CDOMObject)pcc, ListKey.SPELL_PROHIBITOR, (Object)sp);
        return ParseResult.SUCCESS;
    }

    public SpellProhibitor subParse(String value) {
        ProhibitedSpellType type;
        StringTokenizer tok = new StringTokenizer(value, "|");
        String token = tok.nextToken();
        int dotLoc = token.indexOf(".");
        if (dotLoc == -1) {
            Logging.errorPrint((String)(this.getTokenName() + " has no . separator for arguments: " + value));
            return null;
        }
        String pstString = token.substring(0, dotLoc);
        try {
            type = ProhibitedSpellType.valueOf((String)pstString);
        }
        catch (IllegalArgumentException e) {
            Logging.errorPrint((String)(this.getTokenName() + " encountered an invalid Prohibited Spell Type: " + value));
            Logging.errorPrint((String)("  Legal values are: " + StringUtil.join(Arrays.asList(ProhibitedSpellType.values()), (String)", ")));
            return null;
        }
        SpellProhibitor spellProb = this.typeSafeParse(type, token.substring(dotLoc + 1));
        if (spellProb == null) {
            Logging.errorPrint((String)("  entire token value was: " + value));
            return null;
        }
        if (!tok.hasMoreTokens()) {
            return spellProb;
        }
        token = tok.nextToken();
        while (true) {
            Prerequisite prereq;
            if ((prereq = this.getPrerequisite(token)) == null) {
                Logging.errorPrint((String)("   (Did you put more than one limit, or items after the PRExxx tags in " + this.getTokenName() + ":?)"));
                return null;
            }
            spellProb.addPrerequisite(prereq);
            if (!tok.hasMoreTokens()) break;
            token = tok.nextToken();
        }
        return spellProb;
    }

    private SpellProhibitor typeSafeParse(ProhibitedSpellType type, String args) {
        SpellProhibitor spellProb = new SpellProhibitor();
        spellProb.setType(type);
        if (args.length() == 0) {
            Logging.errorPrint((String)(this.getTokenName() + " " + type + " has no arguments"));
            return null;
        }
        String joinChar = this.getJoinChar(type, new LinkedList<String>());
        if (args.indexOf(joinChar) == 0) {
            Logging.errorPrint((String)(this.getTokenName() + " arguments may not start with " + joinChar));
            return null;
        }
        if (args.lastIndexOf(joinChar) == args.length() - 1) {
            Logging.errorPrint((String)(this.getTokenName() + " arguments may not end with " + joinChar));
            return null;
        }
        if (args.indexOf(joinChar + joinChar) != -1) {
            Logging.errorPrint((String)(this.getTokenName() + " arguments uses double separator " + joinChar + joinChar));
            return null;
        }
        StringTokenizer elements = new StringTokenizer(args, joinChar);
        while (elements.hasMoreTokens()) {
            String aValue = elements.nextToken();
            if (!(!type.equals((Object)ProhibitedSpellType.ALIGNMENT) || aValue.equalsIgnoreCase("GOOD") || aValue.equalsIgnoreCase("EVIL") || aValue.equalsIgnoreCase("LAWFUL") || aValue.equalsIgnoreCase("CHAOTIC"))) {
                Logging.errorPrint((String)("Illegal PROHIBITSPELL:ALIGNMENT subtag '" + aValue + "'"));
                return null;
            }
            spellProb.addValue(aValue);
        }
        return spellProb;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)pcc, ListKey.SPELL_PROHIBITOR);
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (SpellProhibitor sp : added) {
            StringBuilder sb = new StringBuilder();
            ProhibitedSpellType pst = sp.getType();
            sb.append(pst.toString().toUpperCase());
            sb.append('.');
            List valueSet = sp.getValueList();
            String joinChar = this.getJoinChar(pst, valueSet);
            sb.append(StringUtil.join(new TreeSet(valueSet), (String)joinChar));
            if (sp.hasPrerequisites()) {
                sb.append("|");
                sb.append(this.getPrerequisiteString(context, sp.getPrerequisiteList()));
            }
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private <T> String getJoinChar(ProhibitedSpellType pst, Collection<String> spValues) {
        return pst.getRequiredCount(spValues) == 1 ? "," : ".";
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

