/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.Collection;
import java.util.Collections;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.FormatManager;

public final class FactKey<T> {
    private static CaseInsensitiveMap<FactKey<?>> typeMap = new CaseInsensitiveMap();
    private final String fieldName;
    private final FormatManager<T> formatManager;

    private FactKey(String name, FormatManager<T> mgr) {
        if (name == null) {
            throw new IllegalArgumentException("Name for FactKey cannot be null");
        }
        if (mgr == null) {
            throw new IllegalArgumentException("FormatManager for FactKey cannot be null");
        }
        this.fieldName = name;
        this.formatManager = mgr;
    }

    public String toString() {
        return this.fieldName;
    }

    public static <T> FactKey<T> getConstant(String name, FormatManager<T> cl) {
        FactKey<T> key = (FactKey<T>)typeMap.get((Object)name);
        if (key == null) {
            key = new FactKey<T>(name, cl);
            typeMap.put((Object)name, key);
        } else if (!key.formatManager.equals(cl)) {
            throw new IllegalArgumentException("FactKey: " + name + " does not store objects of " + cl.getManagedClass().getCanonicalName());
        }
        return key;
    }

    public static <T> FactKey<T> valueOf(String name) {
        FactKey key = (FactKey)typeMap.get((Object)name);
        if (key == null) {
            throw new IllegalArgumentException(name + " is not a previously defined FactKey");
        }
        return key;
    }

    public static Collection<FactKey<?>> getAllConstants() {
        return Collections.unmodifiableCollection(typeMap.values());
    }

    public static void clearConstants() {
        typeMap.clear();
    }

    public T cast(Object obj) {
        return (T)obj;
    }

    public FormatManager<T> getFormatManager() {
        return this.formatManager;
    }
}

