/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.AddedBonusFacet;
import pcgen.cdom.facet.PrerequisiteFacet;
import pcgen.cdom.facet.SaveableBonusFacet;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.core.bonus.BonusObj;

public class AppliedBonusFacet
extends AbstractListFacet<CharID, BonusObj>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private AddedBonusFacet addedBonusFacet;
    private SaveableBonusFacet saveableBonusFacet;
    private PrerequisiteFacet prerequisiteFacet;
    private RaceFacet raceFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CDOMObject cdo = dfce.getCDOMObject();
        this.processAdd(id, cdo, cdo.getSafeListFor(ListKey.BONUS));
        this.processAdd(id, cdo, this.addedBonusFacet.getSet(id, cdo));
        this.processAdd(id, cdo, this.saveableBonusFacet.getSet(id, cdo));
    }

    private void processAdd(CharID id, CDOMObject cdo, List<? extends BonusObj> bonusList) {
        for (BonusObj bonusObj : bonusList) {
            if (this.prerequisiteFacet.qualifies(id, bonusObj, cdo)) {
                this.add(id, bonusObj);
                continue;
            }
            this.remove(id, bonusObj);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CDOMObject cdo = dfce.getCDOMObject();
        this.processRemove(id, cdo.getSafeListFor(ListKey.BONUS));
        this.processRemove(id, this.addedBonusFacet.getSet(id, cdo));
        this.processRemove(id, this.saveableBonusFacet.getSet(id, cdo));
    }

    private void processRemove(CharID id, List<? extends BonusObj> bonusList) {
        for (BonusObj bonusObj : bonusList) {
            this.remove(id, bonusObj);
        }
    }

    public void setAddedBonusFacet(AddedBonusFacet addedBonusFacet) {
        this.addedBonusFacet = addedBonusFacet;
    }

    public void setSaveableBonusFacet(SaveableBonusFacet saveableBonusFacet) {
        this.saveableBonusFacet = saveableBonusFacet;
    }

    public void setPrerequisiteFacet(PrerequisiteFacet prerequisiteFacet) {
        this.prerequisiteFacet = prerequisiteFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
    }
}

