/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;

public class ListMatchingReference<T extends CDOMObject, V>
extends CDOMReference<T> {
    private final CDOMGroupRef<T> all;
    private final ListKey<V> key;
    private final V value;

    public ListMatchingReference(String unparse, Class<T> objClass, CDOMGroupRef<T> startingGroup, ListKey<V> targetKey, V expectedValue) {
        super(objClass, unparse);
        if (startingGroup == null) {
            throw new IllegalArgumentException("Starting Group cannot be null in ListMatchingReference");
        }
        if (targetKey == null) {
            throw new IllegalArgumentException("Target Key cannot be null in ListMatchingReference");
        }
        this.all = startingGroup;
        this.key = targetKey;
        this.value = expectedValue;
    }

    @Override
    public void addResolution(T item) {
        throw new IllegalStateException("Cannot add resolution to ListMatchingReference");
    }

    @Override
    public boolean contains(T item) {
        if (!this.all.contains(item)) {
            return false;
        }
        List<V> actualList = ((CDOMObject)item).getListFor(this.key);
        if (actualList != null) {
            for (V actual : actualList) {
                if (this.value == null || !this.value.equals(actual)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<T> getContainedObjects() {
        ArrayList<CDOMObject> list = new ArrayList<CDOMObject>();
        for (CDOMObject obj : this.all.getContainedObjects()) {
            List<V> actualList = obj.getListFor(this.key);
            if (actualList == null) continue;
            for (V actual : actualList) {
                if (this.value == null || !this.value.equals(actual)) continue;
                list.add(obj);
            }
        }
        return list;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.getName();
    }

    @Override
    public int getObjectCount() {
        int count = 0;
        for (CDOMObject obj : this.all.getContainedObjects()) {
            List<V> actualList = obj.getListFor(this.key);
            if (actualList == null) continue;
            for (V actual : actualList) {
                if (this.value == null || !this.value.equals(actual)) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListMatchingReference) {
            ListMatchingReference other = (ListMatchingReference)obj;
            if (this.getReferenceClass().equals(other.getReferenceClass()) && this.all.equals(other.all) && this.key.equals(other.key)) {
                if (this.value == null) {
                    return other.value == null;
                }
                return this.value.equals(other.value);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.key.hashCode() + (this.value == null ? -1 : this.value.hashCode());
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public String getChoice() {
        return null;
    }
}

