/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import pcgen.util.Logging;

public final class RollInfo {
    protected int sides = 0;
    protected int times = 0;
    private boolean[] keepList = null;
    private int modifier = 0;
    private int rerollAbove = Integer.MAX_VALUE;
    private int rerollBelow = Integer.MIN_VALUE;
    private int totalCeiling = Integer.MAX_VALUE;
    private int totalFloor = Integer.MIN_VALUE;

    public int getSides() {
        return this.sides;
    }

    public int getTimes() {
        return this.times;
    }

    public static String validateRollString(String rollString) {
        return RollInfo.parseRollInfo(new RollInfo(), rollString);
    }

    public static String parseRollInfo(RollInfo rollInfo, String rollString) {
        StringTokenizer st = new StringTokenizer(rollString, " ", true);
        try {
            String tok = st.nextToken("d");
            if ("d".equals(tok)) {
                rollInfo.times = 1;
            } else {
                rollInfo.times = Integer.parseInt(tok);
                if (st.hasMoreTokens()) {
                    tok = st.nextToken("d");
                    if (!"d".equals(tok)) {
                        return "Bad roll parsing in '" + rollString + "': missing 'd'";
                    }
                } else {
                    rollInfo.sides = 1;
                    return "";
                }
            }
            String parseChars = "/\\|mM+-tT";
            rollInfo.sides = Integer.parseInt(st.nextToken(parseChars));
            if (rollInfo.sides < 1) {
                return "Bad roll parsing in '" + rollString + "': sides < 1: " + rollInfo.sides;
            }
            block13: while (st.hasMoreTokens()) {
                tok = st.nextToken(parseChars);
                switch (tok.charAt(0)) {
                    case '/': {
                        parseChars = "mM+-tT";
                        int keepTop = Integer.parseInt(st.nextToken(parseChars));
                        if (keepTop > rollInfo.times) {
                            return "Bad keepTop in '" + rollString + "': times: " + rollInfo.times + "; keepTop: " + keepTop;
                        }
                        rollInfo.keepList = new boolean[rollInfo.times];
                        for (int i = rollInfo.times - keepTop; i < rollInfo.times; ++i) {
                            rollInfo.keepList[i] = true;
                        }
                        continue block13;
                    }
                    case '\\': {
                        parseChars = "mM+-tT";
                        int keepBottom = Integer.parseInt(st.nextToken(parseChars));
                        if (keepBottom > rollInfo.times) {
                            return "Bad keepBottom in '" + rollString + "': times: " + rollInfo.times + "; keepBottom: " + keepBottom;
                        }
                        rollInfo.keepList = new boolean[rollInfo.times];
                        for (int i = 0; i < keepBottom; ++i) {
                            rollInfo.keepList[i] = true;
                        }
                        continue block13;
                    }
                    case '|': {
                        parseChars = "mM+-tT";
                        tok = st.nextToken(parseChars);
                        rollInfo.keepList = new boolean[rollInfo.times];
                        StringTokenizer keepSt = new StringTokenizer(tok, ",");
                        while (keepSt.hasMoreTokens()) {
                            rollInfo.keepList[Integer.parseInt((String)keepSt.nextToken((String)",")) - 1] = true;
                        }
                        continue block13;
                    }
                    case 'm': {
                        parseChars = "M+-tT";
                        rollInfo.rerollBelow = Integer.parseInt(st.nextToken(parseChars));
                        break;
                    }
                    case 'M': {
                        parseChars = "m+-tT";
                        rollInfo.rerollAbove = Integer.parseInt(st.nextToken(parseChars));
                        break;
                    }
                    case '+': {
                        parseChars = "tT";
                        rollInfo.modifier = Integer.parseInt(st.nextToken(" "));
                        break;
                    }
                    case '-': {
                        parseChars = "tT";
                        rollInfo.modifier = -Integer.parseInt(st.nextToken(" "));
                        break;
                    }
                    case 't': {
                        parseChars = "T";
                        rollInfo.totalFloor = Integer.parseInt(st.nextToken(" "));
                        break;
                    }
                    case 'T': {
                        parseChars = "t";
                        rollInfo.totalCeiling = Integer.parseInt(st.nextToken(" "));
                        break;
                    }
                    default: {
                        Logging.errorPrint("Bizarre dice parser error in '" + rollString + "': not a valid delimiter");
                        return "Bad roll parsing in '" + rollString + "': invalid delimiter '" + tok.charAt(0) + "'.";
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Bad roll string in '" + rollString + "': " + ex, ex);
            }
            return "Bad roll string in '" + rollString + "': " + ex;
        }
        return "";
    }

    private RollInfo() {
    }

    public RollInfo(String rollString) {
        String errMsg = RollInfo.parseRollInfo(this, rollString);
        if (!StringUtils.isBlank(errMsg)) {
            Logging.errorPrint(errMsg);
        }
    }

    public static void main(String[] args) {
        Logging.setDebugMode(true);
        for (int i = 0; i < args.length; ++i) {
            RollInfo ri = new RollInfo(args[i]);
            Logging.debugPrint(ri + ": " + RollInfo.roll());
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        if (this.times > 0) {
            buf.append(this.times);
        }
        buf.append("d").append(this.sides);
        while (this.keepList != null) {
            int i;
            for (i = 0; i < this.times && !this.keepList[i]; ++i) {
            }
            if (i == this.times) {
                Logging.errorPrint("Bad rolls: nothing to keep!");
                return null;
            }
            for (i = 0; i < this.times && this.keepList[i]; ++i) {
            }
            if (i == this.times) break;
            int p = i;
            while (i < this.times && !this.keepList[i]) {
                ++i;
            }
            if (p > 0 && i == this.times) {
                buf.append("\\").append(p);
                break;
            }
            for (i = 0; i < this.times && !this.keepList[i]; ++i) {
            }
            p = i;
            while (i < this.times && this.keepList[i]) {
                ++i;
            }
            if (p > 0 && i == this.times) {
                buf.append("/").append(this.times - p);
                break;
            }
            buf.append("|");
            boolean first = true;
            for (i = 0; i < this.times; ++i) {
                if (!this.keepList[i]) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append(i + 1);
            }
        }
        if (this.rerollBelow != Integer.MIN_VALUE) {
            buf.append("m").append(this.rerollBelow);
        }
        if (this.rerollAbove != Integer.MAX_VALUE) {
            buf.append("M").append(this.rerollAbove);
        }
        if (this.modifier > 0) {
            buf.append("+").append(this.modifier);
        } else if (this.modifier < 0) {
            buf.append("-").append(-this.modifier);
        }
        if (this.totalFloor != Integer.MIN_VALUE) {
            buf.append("t").append(this.totalFloor);
        }
        if (this.totalCeiling != Integer.MAX_VALUE) {
            buf.append("T").append(this.totalCeiling);
        }
        return buf.toString();
    }

    private static int roll() {
        boolean result = false;
        return 0;
    }
}

