/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.base.formula.Formula;

public class SpellProgressionCache
implements Cloneable {
    private Progression knownProgression = null;
    private Progression specialtyKnownProgression = null;
    private Progression castProgression = null;

    public List<Formula> setKnown(int iLevel, List<Formula> aList) {
        if (this.knownProgression == null) {
            this.knownProgression = new Progression();
        }
        return this.knownProgression.setProgression(iLevel, aList);
    }

    public boolean hasKnownProgression() {
        return this.knownProgression != null && this.knownProgression.hasProgression();
    }

    public Map<Integer, List<Formula>> getKnownProgression() {
        return this.knownProgression == null ? null : this.knownProgression.getProgression();
    }

    public List<Formula> getKnownForLevel(int aLevel) {
        return this.knownProgression == null ? null : this.knownProgression.getProgressionForLevel(aLevel);
    }

    public int getHighestKnownSpellLevel() {
        return this.knownProgression == null ? 0 : this.knownProgression.getHighestSpellLevel();
    }

    public List<Formula> setSpecialtyKnown(int aLevel, List<Formula> aList) {
        if (this.specialtyKnownProgression == null) {
            this.specialtyKnownProgression = new Progression();
        }
        return this.specialtyKnownProgression.setProgression(aLevel, aList);
    }

    public boolean hasSpecialtyKnownProgression() {
        return this.specialtyKnownProgression != null && this.specialtyKnownProgression.hasProgression();
    }

    public Map<Integer, List<Formula>> getSpecialtyKnownMap() {
        return this.specialtyKnownProgression == null ? null : this.specialtyKnownProgression.getProgression();
    }

    public List<Formula> getSpecialtyKnownForLevel(int aLevel) {
        return this.specialtyKnownProgression == null ? null : this.specialtyKnownProgression.getProgressionForLevel(aLevel);
    }

    public List<Formula> setCast(int aLevel, List<Formula> aList) {
        if (this.castProgression == null) {
            this.castProgression = new Progression();
        }
        return this.castProgression.setProgression(aLevel, aList);
    }

    public boolean hasCastProgression() {
        return this.castProgression != null && this.castProgression.hasProgression();
    }

    public Map<Integer, List<Formula>> getCastProgression() {
        return this.castProgression == null ? null : this.castProgression.getProgression();
    }

    public List<Formula> getCastForLevel(int aLevel) {
        return this.castProgression == null ? null : this.castProgression.getProgressionForLevel(aLevel);
    }

    public int getHighestCastSpellLevel() {
        return this.castProgression == null ? 0 : this.castProgression.getHighestSpellLevel();
    }

    public int getMinLevelForSpellLevel(int spellLevel, boolean allowBonus) {
        int lvl;
        if (this.castProgression != null && (lvl = this.castProgression.getMinLevelForSpellLevel(spellLevel, allowBonus)) != -1) {
            return lvl;
        }
        if (this.knownProgression != null && (lvl = this.knownProgression.getMinLevelForSpellLevel(spellLevel, allowBonus)) != -1) {
            return lvl;
        }
        return -1;
    }

    public int getMaxSpellLevelForClassLevel(int classLevel) {
        List<Formula> knownList;
        if (this.castProgression != null && (knownList = this.castProgression.getProgressionForLevel(classLevel)) != null) {
            return knownList.size() - 1;
        }
        if (this.knownProgression != null && (knownList = this.knownProgression.getProgressionForLevel(classLevel)) != null) {
            return knownList.size() - 1;
        }
        return -1;
    }

    public SpellProgressionCache clone() throws CloneNotSupportedException {
        SpellProgressionCache spi = (SpellProgressionCache)super.clone();
        if (this.knownProgression != null) {
            spi.knownProgression = this.knownProgression.clone();
        }
        if (this.specialtyKnownProgression != null) {
            spi.specialtyKnownProgression = this.specialtyKnownProgression.clone();
        }
        if (this.castProgression != null) {
            spi.castProgression = this.castProgression.clone();
        }
        return spi;
    }

    public boolean isEmpty() {
        return this.knownProgression == null && this.castProgression == null && this.specialtyKnownProgression == null;
    }

    private static class Progression
    implements Cloneable {
        private TreeMap<Integer, List<Formula>> progressionMap = null;

        private Progression() {
        }

        public List<Formula> setProgression(int iLevel, List<Formula> aList) {
            if (iLevel < 1) {
                throw new IllegalArgumentException("Level must be >= 1 in spell progression");
            }
            if (aList == null) {
                throw new IllegalArgumentException("Cannot add null spell progression list to level " + iLevel);
            }
            if (aList.isEmpty()) {
                throw new IllegalArgumentException("Cannot add empty spell progression list to level " + iLevel);
            }
            if (aList.contains(null)) {
                throw new IllegalArgumentException("Cannot have null value in spell progrssion list in level " + iLevel);
            }
            if (this.progressionMap == null) {
                this.progressionMap = new TreeMap();
            }
            return this.progressionMap.put(iLevel, new ArrayList<Formula>(aList));
        }

        public int getMinLevelForSpellLevel(int spellLevel, boolean allowBonus) {
            for (Map.Entry<Integer, List<Formula>> me : this.progressionMap.entrySet()) {
                List<Formula> progressionList = me.getValue();
                for (int lvl = spellLevel; lvl < progressionList.size(); ++lvl) {
                    if (!allowBonus && Integer.parseInt(progressionList.get(lvl).toString()) == 0) continue;
                    return me.getKey();
                }
            }
            return -1;
        }

        public boolean hasProgression() {
            return this.progressionMap != null;
        }

        public Map<Integer, List<Formula>> getProgression() {
            if (this.progressionMap == null) {
                return null;
            }
            return this.progressionMap;
        }

        public List<Formula> getProgressionForLevel(int classLevel) {
            ArrayList<Formula> spellProgression = null;
            boolean found = false;
            if (this.progressionMap != null) {
                Integer key = classLevel;
                if (!this.progressionMap.containsKey(key)) {
                    if (this.progressionMap.firstKey() < classLevel) {
                        key = this.progressionMap.headMap(key).lastKey();
                        found = true;
                    }
                } else {
                    found = true;
                }
                if (found) {
                    List<Formula> list = this.progressionMap.get(key);
                    spellProgression = new ArrayList<Formula>(list);
                }
            }
            return spellProgression;
        }

        public int getHighestSpellLevel() {
            if (this.progressionMap != null) {
                int highest = -1;
                for (List<Formula> list : this.progressionMap.values()) {
                    highest = Math.max(highest, list.size() - 1);
                }
                return highest;
            }
            return -1;
        }

        public Progression clone() throws CloneNotSupportedException {
            Progression p = (Progression)super.clone();
            if (this.progressionMap != null) {
                p.progressionMap = new TreeMap<Integer, List<Formula>>((SortedMap<Integer, List<Formula>>)this.progressionMap);
            }
            return p;
        }
    }
}

