/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.bonus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.QualifyingObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.CoreUtility;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.LoadContext;

public abstract class BonusObj
extends ConcretePrereqObject
implements Serializable,
Cloneable,
QualifyingObject {
    private List<Object> bonusInfo = new ArrayList<Object>();
    private Map<String, String> dependMap = new HashMap<String, String>();
    private Formula bonusFormula = FormulaFactory.ZERO;
    private String bonusName = "";
    private String bonusType = "";
    private String varPart = "";
    private String typeOfBonus = "*UNDEFINED";
    private String stringRepresentation = null;
    private String tokenSource = null;
    private StackType theStackingFlag = StackType.NORMAL;
    private String originalString;

    public String getBonusInfo() {
        StringBuilder sb = new StringBuilder(50);
        if (this.bonusInfo.size() > 0) {
            for (int i = 0; i < this.bonusInfo.size(); ++i) {
                sb.append(i == 0 ? "" : ",");
                sb.append(this.unparseToken(this.bonusInfo.get(i)));
            }
        } else {
            sb.append("|ERROR");
        }
        return sb.toString().toUpperCase();
    }

    public List<String> getUnparsedBonusInfoList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Object info : this.bonusInfo) {
            list.add(this.unparseToken(info));
        }
        return list;
    }

    public List<?> getBonusInfoList() {
        return this.bonusInfo;
    }

    public String getBonusName() {
        return this.bonusName;
    }

    public boolean getDependsOn(String aString) {
        return this.dependMap.containsKey(aString);
    }

    public boolean getDependsOn(List<String> aList) {
        for (String key : aList) {
            if (!this.dependMap.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean getDependsOnBonusName(String bonusName) {
        return this.dependMap.containsKey("NAME|" + bonusName);
    }

    public String listDependsMap() {
        StringBuilder buff = new StringBuilder("[");
        for (String key : this.dependMap.keySet()) {
            if (buff.length() > 1) {
                buff.append(", ");
            }
            buff.append(key);
        }
        buff.append("]");
        return buff.toString();
    }

    public String getTypeOfBonus() {
        return this.typeOfBonus;
    }

    public String getTypeString() {
        return this.bonusType;
    }

    Formula setValue(String bValue) {
        this.bonusFormula = FormulaFactory.getFormulaFor(bValue);
        if (!this.bonusFormula.isStatic()) {
            this.buildDependMap(bValue.toUpperCase());
        }
        return this.bonusFormula;
    }

    public Formula getFormula() {
        return this.bonusFormula;
    }

    public String getValue() {
        return this.bonusFormula.toString();
    }

    public Number resolve(PlayerCharacter pc, String string) {
        return this.bonusFormula.resolve(pc, string);
    }

    public boolean isValueStatic() {
        return this.bonusFormula.isStatic();
    }

    public void setVariable(String aString) {
        this.varPart = aString.toUpperCase();
    }

    public String getVariable() {
        return this.varPart;
    }

    public boolean hasTypeString() {
        return this.bonusType.length() > 0;
    }

    public boolean hasVariable() {
        return this.varPart.length() > 0;
    }

    public String getPCCText() {
        if (this.stringRepresentation == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.getTypeOfBonus());
            if (this.varPart != null && this.varPart.length() > 0) {
                sb.append(this.varPart);
            }
            if (this.bonusInfo.size() > 0) {
                for (int i = 0; i < this.bonusInfo.size(); ++i) {
                    sb.append(i == 0 ? (char)'|' : ',').append(this.unparseToken(this.bonusInfo.get(i)));
                }
            } else {
                sb.append("|ERROR");
            }
            sb.append('|').append(this.bonusFormula.toString());
            if (this.bonusType.length() != 0) {
                sb.append("|TYPE=").append(this.bonusType);
            }
            if (this.hasPrerequisites()) {
                sb.append("|");
                sb.append(new PrerequisiteWriter().getPrerequisiteString(this.getPrerequisiteList(), "|"));
            }
            this.stringRepresentation = sb.toString();
        }
        return this.stringRepresentation;
    }

    public String toString() {
        return this.getPCCText();
    }

    protected void setBonusName(String aName) {
        this.bonusName = aName;
    }

    protected void setTypeOfBonus(String type) {
        this.typeOfBonus = type;
    }

    protected void addBonusInfo(Object obj) {
        this.bonusInfo.add(obj);
    }

    protected void replaceBonusInfo(Object oldObj, Object newObj) {
        for (int i = 0; i < this.bonusInfo.size(); ++i) {
            Object curObj = this.bonusInfo.get(i);
            if (curObj != oldObj) continue;
            this.bonusInfo.set(i, newObj);
            break;
        }
    }

    protected boolean addType(String typeString) {
        if (this.bonusType.length() == 0) {
            this.bonusType = typeString.toUpperCase();
            return true;
        }
        return false;
    }

    public void setStackingFlag(StackType aFlag) {
        this.theStackingFlag = aFlag;
    }

    public StackType getStackingFlag() {
        return this.theStackingFlag;
    }

    protected abstract boolean parseToken(LoadContext var1, String var2);

    protected abstract String unparseToken(Object var1);

    public abstract String getBonusHandled();

    private void buildDependMap(String aString) {
        this.addImpliedDependenciesFor(aString);
        while (aString.lastIndexOf(40) >= 0) {
            int x = CoreUtility.innerMostStringStart(aString);
            int y = CoreUtility.innerMostStringEnd(aString);
            if (y < x) {
                return;
            }
            String bString = aString.substring(x + 1, y);
            this.buildDependMap(bString);
            aString = new StringBuilder(aString.length()).append(aString.substring(0, x)).append(aString.substring(y + 1)).toString();
        }
        if (aString.indexOf("(") >= 0 || aString.indexOf(")") >= 0 || aString.indexOf("%") >= 0) {
            return;
        }
        StringTokenizer cTok = new StringTokenizer(aString, ".,");
        while (cTok.hasMoreTokens()) {
            String controlString = cTok.nextToken();
            if ("IF".equals(controlString) || "THEN".equals(controlString) || "ELSE".equals(controlString) || "GT".equals(controlString) || "GTEQ".equals(controlString) || "EQ".equals(controlString) || "LTEQ".equals(controlString) || "LT".equals(controlString)) continue;
            StringTokenizer mTok = new StringTokenizer(controlString, "+-/*>=<\"");
            while (mTok.hasMoreTokens()) {
                String newString;
                String testString = newString = mTok.nextToken();
                boolean found = false;
                while (!found) {
                    if (newString.indexOf("MAX") >= 0) {
                        testString = newString.substring(0, newString.indexOf("MAX"));
                        newString = newString.substring(newString.indexOf("MAX") + 3);
                    } else if (newString.indexOf("MIN") >= 0) {
                        testString = newString.substring(0, newString.indexOf("MIN"));
                        newString = newString.substring(newString.indexOf("MIN") + 3);
                    } else {
                        found = true;
                    }
                    try {
                        Float.parseFloat(testString);
                    }
                    catch (NumberFormatException e) {
                        if (testString.length() <= 0) continue;
                        if (testString.startsWith("MOVE[")) {
                            testString = new StringBuilder(testString.length()).append("TYPE.").append(testString.substring(5, testString.length() - 1)).toString();
                        }
                        this.dependMap.put(testString.intern(), "1");
                        this.addImpliedDependenciesFor(testString);
                    }
                }
            }
        }
    }

    private void addImpliedDependenciesFor(String aString) {
        if (aString.indexOf("SKILLINFO(") >= 0) {
            this.dependMap.put("JEPFORMULA", "1");
        }
        if (aString.indexOf("HP") >= 0) {
            this.dependMap.put("CURRENTMAX", "1");
        }
        if (aString.indexOf("SKILL.") >= 0 || aString.indexOf("SKILLINFO") >= 0) {
            this.dependMap.put("NAME|STAT", "1");
        }
        if (aString.indexOf("MODEQUIPMAXDEX") >= 0) {
            this.dependMap.put("MAXDEX", "1");
        }
        if (aString.equals("BAB")) {
            this.dependMap.put("BASEAB", "1");
        }
    }

    @Override
    public BonusObj clone() throws CloneNotSupportedException {
        BonusObj bonusObj = (BonusObj)super.clone();
        bonusObj.bonusInfo = new ArrayList<Object>(this.bonusInfo);
        bonusObj.dependMap = new HashMap<String, String>();
        bonusObj.setValue(this.bonusFormula.toString());
        return bonusObj;
    }

    public void setTokenSource(String tokenName) {
        this.tokenSource = tokenName;
    }

    public String getTokenSource() {
        return this.tokenSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BonusObj)) {
            return false;
        }
        BonusObj other = (BonusObj)obj;
        return this.equalsPrereqObject(other) && this.bonusFormula.equals(other.bonusFormula) && this.bonusName.equals(other.bonusName) && this.bonusType.equals(other.bonusType) && this.theStackingFlag.equals((Object)other.theStackingFlag) && this.bonusInfo.equals(other.bonusInfo);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void putOriginalString(String bonusString) {
        this.originalString = bonusString;
    }

    public String getLSTformat() {
        return this.originalString;
    }

    public String getDescription() {
        return this.getTypeOfBonus() + " " + this.getBonusInfo();
    }

    protected boolean requiresRealCaseTarget() {
        return false;
    }

    public static enum StackType {
        NORMAL,
        STACK,
        REPLACE;

    }
}

