/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.UserSelection;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

public final class KitAbilities
extends BaseKit {
    private Boolean free = null;
    private Integer choiceCount;
    private List<CDOMReference<Ability>> abilities = new ArrayList<CDOMReference<Ability>>();
    private transient List<CNAbilitySelection> abilitiesToAdd = null;
    private CDOMSingleRef<AbilityCategory> catRef;

    public void setFree(Boolean argFree) {
        this.free = argFree;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.choiceCount != null || this.abilities.size() != 1) {
            sb.append(this.getSafeCount()).append(" of ");
        }
        boolean firstDone = false;
        for (CDOMReference<Ability> ref : this.abilities) {
            if (firstDone) {
                sb.append("; ");
            }
            firstDone = true;
            String choice = ref.getChoice();
            for (Ability a : ref.getContainedObjects()) {
                if (a == null) continue;
                sb.append(a.getKeyName());
                if (choice == null) continue;
                sb.append(" (");
                sb.append(choice);
                sb.append(')');
            }
        }
        if (this.isFree()) {
            sb.append(" (free)");
        }
        return sb.toString();
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        List selected;
        int maxChoices;
        this.abilitiesToAdd = new ArrayList<CNAbilitySelection>();
        double minCost = Double.MAX_VALUE;
        ArrayList<AbilitySelection> available = new ArrayList<AbilitySelection>();
        for (CDOMReference<Ability> ref : this.abilities) {
            String choice = ref.getChoice();
            for (Ability a : ref.getContainedObjects()) {
                if (a == null) {
                    warnings.add("ABILITY: " + ref + " could not be found.");
                    minCost = 0.0;
                    continue;
                }
                if (a.getCost() < minCost) {
                    minCost = a.getCost();
                }
                if (choice == null && a.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                    available.add(new AbilitySelection(a, ""));
                    continue;
                }
                available.add(new AbilitySelection(a, choice));
            }
        }
        int numberOfChoices = this.getSafeCount();
        if (numberOfChoices > available.size()) {
            numberOfChoices = available.size();
        }
        AbilityCategory category = this.catRef.resolvesTo();
        boolean tooManyAbilities = false;
        int n = maxChoices = minCost > 0.0 ? aPC.getAvailableAbilityPool(category).divide(new BigDecimal(minCost)).intValue() : numberOfChoices;
        if (!this.isFree() && numberOfChoices > maxChoices) {
            numberOfChoices = maxChoices;
            tooManyAbilities = true;
        }
        if (!this.isFree() && numberOfChoices == 0) {
            warnings.add("ABILITY: Not enough " + category.getPluralName() + " available to take \"" + this + "\"");
            return false;
        }
        if (numberOfChoices == available.size()) {
            selected = available;
        } else {
            selected = new ArrayList();
            while ((selected = Globals.getChoiceFromList("Choose abilities", available, new ArrayList(), numberOfChoices, aPC)).size() == 0) {
            }
        }
        for (AbilitySelection as : selected) {
            Ability ability = as.ability;
            if (this.isFree() && this.free.booleanValue()) {
                aPC.adjustAbilities(category, new BigDecimal(1));
            }
            if (ability.getCost() > aPC.getAvailableAbilityPool(category).doubleValue()) {
                tooManyAbilities = true;
                continue;
            }
            CNAbility cna = CNAbilityFactory.getCNAbility(category, Nature.NORMAL, ability);
            CNAbilitySelection cnas = new CNAbilitySelection(cna, as.selection);
            this.abilitiesToAdd.add(cnas);
            aPC.addAbility(cnas, UserSelection.getInstance(), this);
        }
        if (tooManyAbilities) {
            warnings.add("ABILITY: Some Abilities were not granted -- not enough remaining feats");
            return false;
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        for (CNAbilitySelection cnas : this.abilitiesToAdd) {
            aPC.addAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
            if (!this.isFree()) continue;
            AbilityCategory category = this.catRef.resolvesTo();
            aPC.adjustAbilities(category, new BigDecimal(1));
        }
    }

    public boolean isFree() {
        return this.free != null && this.free != false;
    }

    @Override
    public String getObjectName() {
        return "Abilities";
    }

    public Boolean getFree() {
        return this.free;
    }

    public void setCount(Integer quan) {
        this.choiceCount = quan;
    }

    public Integer getCount() {
        return this.choiceCount;
    }

    public int getSafeCount() {
        return this.choiceCount == null ? 1 : this.choiceCount;
    }

    public void addAbility(CDOMReference<Ability> ref) {
        this.abilities.add(ref);
    }

    public Collection<CDOMReference<Ability>> getAbilityKeys() {
        TreeSet<CDOMReference<Ability>> wc = new TreeSet<CDOMReference<Ability>>(ReferenceUtilities.REFERENCE_SORTER);
        wc.addAll(this.abilities);
        return wc;
    }

    public void setCategory(CDOMSingleRef<AbilityCategory> ac) {
        this.catRef = ac;
    }

    public CDOMSingleRef<AbilityCategory> getCategory() {
        return this.catRef;
    }

    private static class AbilitySelection
    implements Comparable<AbilitySelection> {
        public final Ability ability;
        public final String selection;

        public AbilitySelection(Ability a, String sel) {
            this.ability = a;
            this.selection = sel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ability.getDisplayName());
            if (this.selection != null) {
                sb.append(" (").append(this.selection).append(')');
            }
            return sb.toString();
        }

        @Override
        public int compareTo(AbilitySelection o) {
            int base = this.ability.compareTo(o.ability);
            if (base != 0) {
                return base;
            }
            if (this.selection == null) {
                return o.selection == null ? 0 : -1;
            }
            return o.selection == null ? 1 : this.selection.compareToIgnoreCase(o.selection);
        }
    }
}

