/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.regex.Pattern;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.io.exporttoken.Token;

public class PCEqTypeTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private static final String Digits = "(\\p{Digit}+)";
    private static final String HexDigits = "(\\p{XDigit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";

    public PCEqTypeTermEvaluator(String originalText) {
        this.originalText = originalText;
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        String sTok = this.evaluate(pc);
        if (Pattern.matches(fpRegex, sTok)) {
            return this.convertToFloat(this.originalText, sTok);
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public String evaluate(PlayerCharacter pc) {
        EqTypeToken token = new EqTypeToken();
        return ((Token)token).getToken(this.originalText, pc, null);
    }

    @Override
    public String evaluate(PlayerCharacter pc, Spell aSpell) {
        return this.evaluate(pc);
    }

    @Override
    public boolean isSourceDependant() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

