/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.doomsdaybook;

import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdom.DataConversionException;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import pcgen.core.doomsdaybook.CRRule;
import pcgen.core.doomsdaybook.DDList;
import pcgen.core.doomsdaybook.DataElement;
import pcgen.core.doomsdaybook.DataElementComperator;
import pcgen.core.doomsdaybook.DataValue;
import pcgen.core.doomsdaybook.HyphenRule;
import pcgen.core.doomsdaybook.Rule;
import pcgen.core.doomsdaybook.RuleSet;
import pcgen.core.doomsdaybook.SpaceRule;
import pcgen.core.doomsdaybook.VariableHashMap;
import pcgen.core.doomsdaybook.WeightedDataValue;
import pcgen.gui2.doomsdaybook.NameButton;
import pcgen.gui2.doomsdaybook.XMLFilter;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.util.FontManipulation;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class NameGenPanel
extends JPanel {
    public Preferences namePrefs = Preferences.userNodeForPackage(NameGenPanel.class);
    private Map<String, List<RuleSet>> categories = new HashMap<String, List<RuleSet>>();
    private JButton generateButton;
    private JButton jButton1;
    private JCheckBox chkStructure;
    private JComboBox cbCatalog;
    private JComboBox cbCategory;
    private JComboBox cbSex;
    private JComboBox cbStructure;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel meaning;
    private JLabel pronounciation;
    private JPanel buttonPanel;
    private JPanel genCtrlPanel;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel nameDisplayPanel;
    private JPanel namePanel;
    private JPanel jPanel4;
    private JPanel nameSubInfoPanel;
    private JPanel nameActionPanel;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTextField name;
    private VariableHashMap allVars = new VariableHashMap();
    private Rule lastRule = null;

    public NameGenPanel() {
        this.initComponents();
        this.initPrefs();
        this.loadData(new File("."));
    }

    public NameGenPanel(File dataPath) {
        this.initComponents();
        this.initPrefs();
        this.loadData(dataPath);
    }

    public void setExitPrefs() {
    }

    public Rule generate() {
        try {
            Rule rule = null;
            if (this.chkStructure.isSelected()) {
                RuleSet rs = (RuleSet)this.cbCatalog.getSelectedItem();
                rule = rs.getRule();
            } else {
                rule = (Rule)this.cbStructure.getSelectedItem();
            }
            ArrayList<DataValue> aName = rule.getData();
            this.setNameText(aName);
            this.setMeaningText(aName);
            this.setPronounciationText(aName);
            return rule;
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
            return null;
        }
    }

    public void initPrefs() {
        double version;
        boolean prefsSet = this.namePrefs.getBoolean("arePrefsSet", false);
        if (!prefsSet) {
            this.namePrefs.putBoolean("arePrefsSet", true);
        }
        if ((version = this.namePrefs.getDouble("Version", 0.0)) < 0.5 || !prefsSet) {
            this.namePrefs.putDouble("Version", 0.5);
        }
        this.namePrefs.putDouble("SubVersion", 0.0);
    }

    private void setMeaningText(String meaning) {
        this.meaning.setText(meaning);
    }

    private void setMeaningText(ArrayList<DataValue> data) {
        StringBuilder meaningBuffer = new StringBuilder();
        for (DataValue val : data) {
            String aMeaning = val.getSubValue("meaning");
            if (aMeaning == null) {
                aMeaning = val.getValue();
            }
            meaningBuffer.append(aMeaning);
        }
        this.setMeaningText(meaningBuffer.toString());
    }

    private void setNameText(String name) {
        this.name.setText(name);
        LogUtilities.inst().logMessage("Random_Name_Generator", name);
    }

    private void setNameText(ArrayList<DataValue> data) {
        StringBuilder nameBuffer = new StringBuilder();
        for (DataValue val : data) {
            nameBuffer.append(val.getValue());
        }
        this.setNameText(nameBuffer.toString());
    }

    private void setPronounciationText(String pronounciation) {
        this.pronounciation.setText(pronounciation);
    }

    private void setPronounciationText(ArrayList<DataValue> data) {
        StringBuilder proBuffer = new StringBuilder();
        for (DataValue val : data) {
            String aPronounciation = val.getSubValue("pronounciation");
            if (aPronounciation == null) {
                aPronounciation = val.getValue();
            }
            proBuffer.append(aPronounciation);
        }
        this.setPronounciationText(proBuffer.toString());
    }

    void NameButtonActionPerformed(ActionEvent evt) {
        try {
            NameButton nb = (NameButton)evt.getSource();
            DataElement element = nb.getDataElement();
            element.getData();
            Rule rule = this.lastRule;
            if (rule == null) {
                if (this.chkStructure.isSelected()) {
                    RuleSet rs = (RuleSet)this.cbCatalog.getSelectedItem();
                    rule = rs.getLastRule();
                } else {
                    rule = (Rule)this.cbStructure.getSelectedItem();
                }
                this.lastRule = rule;
            }
            ArrayList<DataValue> aName = rule.getLastData();
            this.setNameText(aName);
            this.setMeaningText(aName);
            this.setPronounciationText(aName);
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    void cbCatalogActionPerformed(ActionEvent evt) {
        this.loadStructureDD();
        this.clearButtons();
    }

    void cbStructureActionPerformed(ActionEvent evt) {
        this.clearButtons();
    }

    void cbCategoryActionPerformed(ActionEvent evt) {
        this.loadGenderDD();
        this.loadCatalogDD();
        this.loadStructureDD();
        this.clearButtons();
    }

    void cbSexActionPerformed(ActionEvent evt) {
        this.loadCatalogDD();
        this.loadStructureDD();
        this.clearButtons();
    }

    void chkStructureActionPerformed(ActionEvent evt) {
        this.loadStructureDD();
    }

    private void clearButtons() {
        this.buttonPanel.removeAll();
        this.buttonPanel.repaint();
    }

    private void displayButtons(Rule rule) {
        this.clearButtons();
        for (String key : rule) {
            try {
                DataElement ele = this.allVars.getDataElement(key);
                if (ele.getTitle() == null) continue;
                NameButton nb = new NameButton(ele);
                nb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        NameGenPanel.this.NameButtonActionPerformed(evt);
                    }
                });
                this.buttonPanel.add(nb);
            }
            catch (Exception e) {
                Logging.errorPrint(e.getMessage(), e);
            }
        }
        this.buttonPanel.repaint();
    }

    void generateButtonActionPerformed(ActionEvent evt) {
        try {
            this.lastRule = this.generate();
            this.displayButtons(this.lastRule);
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    private void initComponents() {
        this.genCtrlPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel13 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jLabel4 = new JLabel();
        this.cbCatalog = new JComboBox();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbCategory = new JComboBox();
        this.jPanel14 = new JPanel();
        this.jPanel11 = new JPanel();
        this.generateButton = new JButton();
        this.jPanel9 = new JPanel();
        this.jLabel5 = new JLabel();
        this.cbSex = new JComboBox();
        this.jPanel7 = new JPanel();
        this.jSeparator4 = new JSeparator();
        this.jPanel12 = new JPanel();
        this.jLabel6 = new JLabel();
        this.cbStructure = new JComboBox();
        this.chkStructure = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.nameDisplayPanel = new JPanel();
        this.nameSubInfoPanel = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.meaning = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.pronounciation = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.namePanel = new JPanel();
        this.name = new JTextField();
        this.nameActionPanel = new JPanel();
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout(0, 5));
        this.genCtrlPanel.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 0));
        this.jPanel13.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new FlowLayout(0));
        this.jLabel4.setText(LanguageBundle.getString("in_rndNameCatalog"));
        this.jPanel10.add(this.jLabel4);
        this.cbCatalog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameGenPanel.this.cbCatalogActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.cbCatalog);
        this.jPanel13.add((Component)this.jPanel10, "Center");
        this.jPanel8.setLayout(new FlowLayout(0));
        this.jLabel1.setText(LanguageBundle.getString("in_rndNameCategory"));
        this.jPanel8.add(this.jLabel1);
        this.cbCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameGenPanel.this.cbCategoryActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.cbCategory);
        this.jPanel13.add((Component)this.jPanel8, "North");
        this.jPanel4.add(this.jPanel13);
        this.jPanel14.setLayout(new BorderLayout());
        this.jPanel11.setLayout(new FlowLayout(0));
        this.generateButton.setText(LanguageBundle.getString("in_rndNameGenerate"));
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameGenPanel.this.generateButtonActionPerformed(evt);
            }
        });
        this.jPanel11.add(this.generateButton);
        this.jPanel14.add((Component)this.jPanel11, "Center");
        this.jPanel9.setLayout(new FlowLayout(0));
        this.jLabel5.setText(LanguageBundle.getString("in_rndNameSex"));
        this.jPanel9.add(this.jLabel5);
        this.cbSex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameGenPanel.this.cbSexActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.cbSex);
        this.jPanel14.add((Component)this.jPanel9, "North");
        this.jPanel4.add(this.jPanel14);
        this.genCtrlPanel.add((Component)this.jPanel4, "North");
        this.jPanel7.setLayout(new BorderLayout());
        this.jPanel7.add((Component)this.jSeparator4, "North");
        this.jPanel12.setLayout(new FlowLayout(0));
        this.jLabel6.setText(LanguageBundle.getString("in_rndNameStructure"));
        this.jPanel12.add(this.jLabel6);
        this.cbStructure.setEnabled(false);
        this.cbStructure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameGenPanel.this.cbStructureActionPerformed(evt);
            }
        });
        this.jPanel12.add(this.cbStructure);
        this.chkStructure.setSelected(true);
        this.chkStructure.setText(LanguageBundle.getString("in_randomButton"));
        this.chkStructure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameGenPanel.this.chkStructureActionPerformed(evt);
            }
        });
        this.jPanel12.add(this.chkStructure);
        this.jPanel7.add((Component)this.jPanel12, "Center");
        this.jPanel7.add((Component)new JSeparator(), "South");
        JPanel adjustNamePanel = new JPanel();
        adjustNamePanel.setLayout(new BorderLayout());
        JLabel adjNameLabel = new JLabel(LanguageBundle.getString("in_rndNameAdjust"));
        adjustNamePanel.add((Component)adjNameLabel, "North");
        this.buttonPanel.setLayout(new FlowLayout(0));
        JLabel nb = new JLabel(" ");
        this.buttonPanel.add(nb);
        adjustNamePanel.add((Component)this.buttonPanel, "Center");
        this.add((Component)adjustNamePanel, "South");
        this.genCtrlPanel.add((Component)this.jPanel7, "Center");
        this.nameDisplayPanel.setLayout(new BorderLayout());
        this.nameSubInfoPanel.setLayout(new BoxLayout(this.nameSubInfoPanel, 1));
        this.nameSubInfoPanel.add(this.jSeparator2);
        this.jLabel2.setText(LanguageBundle.getString("in_rndNameMeaning"));
        this.nameSubInfoPanel.add(this.jLabel2);
        this.meaning.setText(LanguageBundle.getString("in_rndNmDefault"));
        this.nameSubInfoPanel.add(this.meaning);
        this.nameSubInfoPanel.add(this.jSeparator1);
        this.jLabel3.setText(LanguageBundle.getString("in_rndNmPronounciation"));
        this.nameSubInfoPanel.add(this.jLabel3);
        this.pronounciation.setText("nAm");
        this.nameSubInfoPanel.add(this.pronounciation);
        this.nameSubInfoPanel.add(this.jSeparator3);
        this.nameDisplayPanel.add((Component)this.nameSubInfoPanel, "South");
        JLabel nameTitleLabel = new JLabel(LanguageBundle.getString("in_sumName"));
        JPanel nameTitlePanel = new JPanel(new FlowLayout(0));
        nameTitlePanel.add(nameTitleLabel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.namePanel.setLayout(new BoxLayout(this.namePanel, 0));
        FontManipulation.xxlarge(this.name);
        this.name.setText(LanguageBundle.getString("in_nameLabel"));
        this.namePanel.add(this.name);
        this.nameActionPanel.setLayout(new FlowLayout(2));
        this.jButton1.setIcon(Icons.Copy16.getImageIcon());
        this.jButton1.setAlignmentY(0.0f);
        this.jButton1.setIconTextGap(0);
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameGenPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.nameActionPanel.add(this.jButton1);
        this.namePanel.add(this.nameActionPanel);
        topPanel.add(this.genCtrlPanel);
        topPanel.add(nameTitlePanel);
        topPanel.add(this.namePanel);
        topPanel.add(this.nameDisplayPanel);
        this.add((Component)topPanel, "North");
    }

    void jButton1ActionPerformed(ActionEvent evt) {
        Clipboard cb = this.getToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(this.name.getText());
        cb.setContents(ss, ss);
    }

    private void loadCatalogDD() {
        try {
            String catKey = (String)this.cbCategory.getSelectedItem();
            String sexKey = (String)this.cbSex.getSelectedItem();
            RuleSet oldRS = (RuleSet)this.cbCatalog.getSelectedItem();
            String catalogKey = "";
            if (oldRS != null) {
                catalogKey = oldRS.getTitle();
            }
            List<RuleSet> cats = this.categories.get(catKey);
            List<RuleSet> sexes = this.categories.get("Sex: " + sexKey);
            ArrayList<RuleSet> join = new ArrayList<RuleSet>();
            join.addAll(cats);
            join.retainAll(sexes);
            Collections.sort(join, new DataElementComperator());
            Vector<RuleSet> catalogs = new Vector<RuleSet>();
            int oldSelected = -1;
            int n = 0;
            for (int i = 0; i < join.size(); ++i) {
                RuleSet rs = (RuleSet)join.get(i);
                if (!rs.getUsage().equals("final")) continue;
                catalogs.add(rs);
                if (rs.getTitle().equals(catalogKey)) {
                    oldSelected = n;
                }
                ++n;
            }
            DefaultComboBoxModel catalogModel = new DefaultComboBoxModel(catalogs);
            this.cbCatalog.setModel(catalogModel);
            if (oldSelected >= 0) {
                this.cbCatalog.setSelectedIndex(oldSelected);
            }
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    private Vector<String> getGenderCategoryNames() {
        Vector<String> genders = new Vector<String>();
        Set<String> keySet = this.categories.keySet();
        for (String key : keySet) {
            if (!key.startsWith("Sex:")) continue;
            genders.add(key.substring(5));
        }
        return genders;
    }

    private void loadGenderDD() {
        Vector<String> genders = this.getGenderCategoryNames();
        Vector<String> selectable = new Vector<String>();
        String gender = (String)this.cbSex.getSelectedItem();
        String category = (String)this.cbCategory.getSelectedItem();
        List<RuleSet> categoryRules = this.categories.get(category);
        block0: for (int i = 0; i < genders.size(); ++i) {
            String genderString = genders.get(i);
            List<RuleSet> genderRules = this.categories.get("Sex: " + genderString);
            for (int j = 0; j < categoryRules.size(); ++j) {
                if (!genderRules.contains(categoryRules.get(j))) continue;
                selectable.add(genderString);
                continue block0;
            }
        }
        Collections.sort(selectable);
        this.cbSex.setModel(new DefaultComboBoxModel(selectable));
        if (gender != null && selectable.contains(gender)) {
            this.cbSex.setSelectedItem(gender);
        }
    }

    private void loadCategory(Element category, RuleSet rs) {
        List<RuleSet> thiscat;
        List<RuleSet> cat = this.categories.get(category.getAttributeValue("title"));
        if (cat == null) {
            thiscat = new ArrayList<RuleSet>();
            this.categories.put(category.getAttributeValue("title"), thiscat);
        } else {
            thiscat = cat;
        }
        thiscat.add(rs);
    }

    private void loadData(File path) {
        if (path.isDirectory()) {
            File[] dataFiles = path.listFiles(new XMLFilter());
            SAXBuilder builder = new SAXBuilder();
            GeneratorDtdResolver resolver = new GeneratorDtdResolver(path);
            builder.setEntityResolver((EntityResolver)resolver);
            for (int i = 0; i < dataFiles.length; ++i) {
                try {
                    URL url = dataFiles[i].toURI().toURL();
                    Document nameSet = builder.build(url);
                    DocType dt = nameSet.getDocType();
                    if (dt.getElementName().equals("GENERATOR")) {
                        this.loadFromDocument(nameSet);
                    }
                    nameSet = null;
                    dt = null;
                    continue;
                }
                catch (Exception e) {
                    Logging.errorPrint(e.getMessage(), e);
                    JOptionPane.showMessageDialog(this, "XML Error with file " + dataFiles[i].getName());
                }
            }
            this.loadDropdowns();
        } else {
            JOptionPane.showMessageDialog(this, "No data files in directory " + path.getPath());
        }
    }

    private Vector<String> getCategoryNames() {
        Vector<String> cats = new Vector<String>();
        Set<String> keySet = this.categories.keySet();
        for (String key : keySet) {
            if (key.startsWith("Sex:")) continue;
            cats.add(key);
        }
        Collections.sort(cats);
        return cats;
    }

    private void loadDropdowns() {
        Vector<String> cats = this.getCategoryNames();
        this.cbCategory.setModel(new DefaultComboBoxModel<String>(cats));
        this.loadGenderDD();
        this.loadCatalogDD();
    }

    private void loadFromDocument(Document nameSet) throws DataConversionException {
        Element generator = nameSet.getRootElement();
        List rulesets = generator.getChildren("RULESET");
        List lists = generator.getChildren("LIST");
        ListIterator listIterator = lists.listIterator();
        RuleSet rs = new RuleSet(this.allVars);
        while (listIterator.hasNext()) {
            Element list = (Element)listIterator.next();
            this.loadList(list);
        }
        ListIterator rulesetIterator = rulesets.listIterator();
        while (rulesetIterator.hasNext()) {
            Element ruleSet = (Element)rulesetIterator.next();
            rs = this.loadRuleSet(ruleSet);
            this.allVars.addDataElement(rs);
        }
    }

    private String loadList(Element list) throws DataConversionException {
        DDList dataList = new DDList(this.allVars, list.getAttributeValue("title"), list.getAttributeValue("id"));
        List elements = list.getChildren();
        ListIterator elementsIterator = elements.listIterator();
        while (elementsIterator.hasNext()) {
            Element child = (Element)elementsIterator.next();
            String elementName = child.getName();
            if (!elementName.equals("VALUE")) continue;
            WeightedDataValue dv = new WeightedDataValue(child.getText(), child.getAttribute("weight").getIntValue());
            List subElements = child.getChildren("SUBVALUE");
            ListIterator subElementsIterator = subElements.listIterator();
            while (subElementsIterator.hasNext()) {
                Element subElement = (Element)subElementsIterator.next();
                dv.addSubValue(subElement.getAttributeValue("type"), subElement.getText());
            }
            dataList.add(dv);
        }
        this.allVars.addDataElement(dataList);
        return dataList.getId();
    }

    private String loadRule(Element rule, String id) throws DataConversionException {
        Rule dataRule = new Rule(this.allVars, id, id, rule.getAttribute("weight").getIntValue());
        List elements = rule.getChildren();
        ListIterator elementsIterator = elements.listIterator();
        while (elementsIterator.hasNext()) {
            Element child = (Element)elementsIterator.next();
            String elementName = child.getName();
            if (elementName.equals("GETLIST")) {
                String listId = child.getAttributeValue("idref");
                dataRule.add(listId);
                continue;
            }
            if (elementName.equals("SPACE")) {
                SpaceRule sp = new SpaceRule();
                this.allVars.addDataElement(sp);
                dataRule.add(sp.getId());
                continue;
            }
            if (elementName.equals("HYPHEN")) {
                HyphenRule hy = new HyphenRule();
                this.allVars.addDataElement(hy);
                dataRule.add(hy.getId());
                continue;
            }
            if (elementName.equals("CR")) {
                CRRule cr = new CRRule();
                this.allVars.addDataElement(cr);
                dataRule.add(cr.getId());
                continue;
            }
            if (!elementName.equals("GETRULE")) continue;
            String ruleId = child.getAttributeValue("idref");
            dataRule.add(ruleId);
        }
        this.allVars.addDataElement(dataRule);
        return dataRule.getId();
    }

    private RuleSet loadRuleSet(Element ruleSet) throws DataConversionException {
        RuleSet rs = new RuleSet(this.allVars, ruleSet.getAttributeValue("title"), ruleSet.getAttributeValue("id"), ruleSet.getAttributeValue("usage"));
        List elements = ruleSet.getChildren();
        ListIterator elementsIterator = elements.listIterator();
        int num = 0;
        while (elementsIterator.hasNext()) {
            Element child = (Element)elementsIterator.next();
            String elementName = child.getName();
            if (elementName.equals("CATEGORY")) {
                this.loadCategory(child, rs);
            } else if (elementName.equals("RULE")) {
                rs.add(this.loadRule(child, rs.getId() + num));
            }
            ++num;
        }
        return rs;
    }

    private void loadStructureDD() {
        if (this.chkStructure.isSelected()) {
            this.cbStructure.setModel(new DefaultComboBoxModel());
            this.cbStructure.setEnabled(false);
        } else {
            Vector<DataElement> struct = new Vector<DataElement>();
            for (String key : (RuleSet)this.cbCatalog.getSelectedItem()) {
                try {
                    struct.add(this.allVars.getDataElement(key));
                }
                catch (Exception e) {
                    Logging.errorPrint(e.getMessage(), e);
                }
            }
            DefaultComboBoxModel structModel = new DefaultComboBoxModel(struct);
            this.cbStructure.setModel(structModel);
            this.cbStructure.setEnabled(true);
        }
    }

    public String getChosenName() {
        return this.name.getText();
    }

    public String getGender() {
        return (String)this.cbSex.getSelectedItem();
    }

    public void setGender(String gender) {
        if (gender != null && this.cbSex != null) {
            this.cbSex.setSelectedItem(gender);
        }
    }

    public class GeneratorDtdResolver
    implements EntityResolver {
        private final File parent;

        public GeneratorDtdResolver(File parent) {
            this.parent = parent;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.endsWith("generator.dtd")) {
                FileInputStream dtdIn;
                try {
                    dtdIn = new FileInputStream(new File(this.parent, "generator.dtd"));
                }
                catch (FileNotFoundException e) {
                    Logging.errorPrint("GeneratorDtdResolver.resolveEntity failed", e);
                    return null;
                }
                return new InputSource(dtdIn);
            }
            return null;
        }
    }
}

