/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.sources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.GameModeDisplayFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ListFacades;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.tools.InfoPaneLinkAction;
import pcgen.gui2.util.FacadeComboBoxModel;
import pcgen.gui2.util.TreeColumnCellRenderer;
import pcgen.gui2.util.table.DynamicTableColumnModel;
import pcgen.gui2.util.table.TableCellUtilities;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.Comparators;
import pcgen.util.Logging;

class AdvancedSourceSelectionPanel
extends JPanel
implements ListSelectionListener,
ListListener<CampaignFacade>,
ActionListener {
    private static final UIPropertyContext context = UIPropertyContext.createContext("advancedSourceSelectionPanel");
    private static final String PROP_SELECTED_GAME = "selectedGame";
    private static final String PROP_SELECTED_SOURCES = "selectedSources.";
    private final FilteredTreeViewTable<Object, CampaignFacade> availableTable;
    private final FilteredTreeViewTable<Object, CampaignFacade> selectedTable;
    private SourceTreeViewModel availTreeViewModel;
    private SourceTreeViewModel selTreeViewModel;
    private InfoPane infoPane;
    private GameModeFacade gameMode;
    private JComboBox gameModeList;
    private InfoPaneLinkAction linkAction;
    private final JButton unloadAllButton;
    private final JButton addButton;
    private final JButton removeButton;
    private DefaultListFacade<CampaignFacade> selectedCampaigns;
    private final PCGenFrame frame;

    public AdvancedSourceSelectionPanel(PCGenFrame frame) {
        this.frame = frame;
        this.availableTable = new FilteredTreeViewTable();
        this.selectedTable = new FilteredTreeViewTable();
        this.selectedCampaigns = new DefaultListFacade();
        this.availTreeViewModel = new SourceTreeViewModel();
        this.selTreeViewModel = new SourceTreeViewModel(this.selectedCampaigns);
        this.gameModeList = new JComboBox();
        this.unloadAllButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.infoPane = new InfoPane(LanguageBundle.getString("in_src_info"));
        this.linkAction = new InfoPaneLinkAction(this.infoPane);
        this.initComponents();
        this.initDefaults();
        this.selectedCampaigns.addListListener(this);
    }

    private void initComponents() {
        FlippingSplitPane mainPane = new FlippingSplitPane(0, "advSrcMain");
        FlippingSplitPane topPane = new FlippingSplitPane("advSrcTop");
        topPane.setResizeWeight(0.6);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(LanguageBundle.getString("in_src_gameLabel")), "West");
        FacadeComboBoxModel<GameModeDisplayFacade> gameModes = new FacadeComboBoxModel<GameModeDisplayFacade>();
        gameModes.setListFacade(FacadeFactory.getGameModeDisplays());
        this.gameModeList.setModel(gameModes);
        this.gameModeList.addActionListener(this);
        panel.add((Component)this.gameModeList, "Center");
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>(false);
        bar.add((Component)panel, "West");
        bar.addDisplayableFilter(new SearchFilterPanel());
        panel = new JPanel(new BorderLayout());
        panel.add(bar, "North");
        this.availableTable.setDisplayableFilter(bar);
        this.availableTable.setTreeViewModel(this.availTreeViewModel);
        this.availableTable.getSelectionModel().addListSelectionListener(this);
        this.availableTable.setTreeCellRenderer(new CampaignRenderer());
        ((DynamicTableColumnModel)this.availableTable.getColumnModel()).getAvailableColumns().get(2).setCellRenderer(new TableCellUtilities.AlignRenderer(0));
        JScrollPane pane = new JScrollPane(this.availableTable);
        pane.setPreferredSize(new Dimension(600, 310));
        panel.add((Component)pane, "Center");
        Box box = Box.createHorizontalBox();
        this.unloadAllButton.setAction(new UnloadAllAction());
        box.add(this.unloadAllButton);
        box.add(Box.createHorizontalGlue());
        this.addButton.setHorizontalTextPosition(10);
        this.addButton.setAction(new AddAction());
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        panel.add((Component)box, "South");
        topPane.setLeftComponent(panel);
        JPanel selPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.selectedTable.setDisplayableFilter(filterBar);
        this.selectedTable.setTreeViewModel(this.selTreeViewModel);
        this.selectedTable.getSelectionModel().addListSelectionListener(this);
        this.selectedTable.setTreeCellRenderer(new CampaignRenderer());
        ((DynamicTableColumnModel)this.selectedTable.getColumnModel()).getAvailableColumns().get(2).setCellRenderer(new TableCellUtilities.AlignRenderer(0));
        JScrollPane scrollPane = new JScrollPane(this.selectedTable);
        scrollPane.setPreferredSize(new Dimension(300, 350));
        selPanel.add((Component)scrollPane, "Center");
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        this.removeButton.setAction(new RemoveAction());
        box.add(this.removeButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        selPanel.add((Component)box, "South");
        topPane.setRightComponent(selPanel);
        mainPane.setTopComponent(topPane);
        this.linkAction.install();
        this.infoPane.setPreferredSize(new Dimension(800, 150));
        mainPane.setBottomComponent(this.infoPane);
        mainPane.setResizeWeight(0.7);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPane, "Center");
    }

    private void initDefaults() {
        String defaultGame = context.initProperty(PROP_SELECTED_GAME, "");
        GameModeDisplayFacade modeDisplay = null;
        if (StringUtils.isNotEmpty(defaultGame)) {
            for (int i = 0; i < this.gameModeList.getModel().getSize(); ++i) {
                GameModeDisplayFacade game = (GameModeDisplayFacade)this.gameModeList.getModel().getElementAt(i);
                if (!defaultGame.equals(game.getGameMode().toString())) continue;
                this.gameModeList.setSelectedIndex(i);
                modeDisplay = game;
            }
        }
        if (modeDisplay == null && this.gameModeList.getModel().getSize() > 0) {
            this.gameModeList.setSelectedIndex(0);
            modeDisplay = (GameModeDisplayFacade)this.gameModeList.getSelectedItem();
        }
    }

    private void selectDefaultSources(GameModeFacade mode) {
        if (mode != null) {
            String defaultSelectedSources = context.initProperty(PROP_SELECTED_SOURCES + mode.toString(), "");
            List<String> sourceNames = defaultSelectedSources == null || "".equals(defaultSelectedSources) ? mode.getDefaultDataSetList() : Arrays.asList(defaultSelectedSources.split("\\|"));
            block0: for (String name : sourceNames) {
                for (CampaignFacade camp : FacadeFactory.getSupportedCampaigns(mode)) {
                    if (!name.equals(camp.toString())) continue;
                    this.selectedCampaigns.addElement(camp);
                    continue block0;
                }
            }
        }
    }

    public GameModeFacade getSelectedGameMode() {
        return this.gameMode;
    }

    public List<CampaignFacade> getSelectedCampaigns() {
        return this.selectedCampaigns.getContents();
    }

    public void setSourceSelection(SourceSelectionFacade sources) {
        if (sources == null || sources.getGameMode() == null) {
            Logging.errorPrint("Invalid source selection " + sources + "- ignoring.");
            return;
        }
        GameModeFacade selectedGame = sources.getGameMode().getReference();
        for (int i = 0; i < this.gameModeList.getModel().getSize(); ++i) {
            GameModeDisplayFacade gmdf = (GameModeDisplayFacade)this.gameModeList.getModel().getElementAt(i);
            if (gmdf.getGameMode() != selectedGame) continue;
            this.gameModeList.setSelectedItem(gmdf);
        }
        ArrayList<CampaignFacade> wrap = new ArrayList<CampaignFacade>(ListFacades.wrap(sources.getCampaigns()));
        Collections.sort(wrap, Comparators.toStringIgnoreCaseCollator());
        this.selectedCampaigns.setContents(wrap);
    }

    private void setSelectedGameMode(GameModeDisplayFacade elementAt) {
        this.gameMode = elementAt.getGameMode();
        context.setProperty(PROP_SELECTED_GAME, this.gameMode.toString());
        this.selectedCampaigns.clearContents();
        this.availTreeViewModel.setGameModel(elementAt.getGameMode());
        this.selectDefaultSources(this.gameMode);
    }

    private void setSelectedCampaign(CampaignFacade source) {
        this.infoPane.setText(FacadeFactory.getCampaignInfoFactory().getHTMLInfo(source, this.selectedCampaigns.getContents()));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            Object data;
            int selectedRow;
            if (e.getSource() == this.availableTable.getSelectionModel()) {
                Object data2;
                int selectedRow2 = this.availableTable.getSelectedRow();
                if (selectedRow2 != -1 && (data2 = this.availableTable.getModel().getValueAt(selectedRow2, 0)) != null && data2 instanceof CampaignFacade) {
                    this.setSelectedCampaign((CampaignFacade)data2);
                }
            } else if (e.getSource() == this.selectedTable.getSelectionModel() && (selectedRow = this.selectedTable.getSelectedRow()) != -1 && (data = this.selectedTable.getModel().getValueAt(selectedRow, 0)) != null && data instanceof CampaignFacade) {
                this.setSelectedCampaign((CampaignFacade)data);
            }
        }
    }

    void refreshDisplay() {
        this.availableTable.refreshModelData();
        this.selectedTable.refreshModelData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setSelectedGameMode((GameModeDisplayFacade)this.gameModeList.getSelectedItem());
    }

    @Override
    public void elementAdded(ListEvent<CampaignFacade> e) {
        this.availableTable.updateDisplay();
    }

    @Override
    public void elementRemoved(ListEvent<CampaignFacade> e) {
        this.availableTable.updateDisplay();
    }

    @Override
    public void elementsChanged(ListEvent<CampaignFacade> e) {
        this.availableTable.updateDisplay();
    }

    @Override
    public void elementModified(ListEvent<CampaignFacade> e) {
        this.availableTable.updateDisplay();
    }

    void rememberSelectedSources() {
        String sources = StringUtils.join(this.getSelectedCampaigns(), "|");
        context.setProperty(PROP_SELECTED_SOURCES + this.gameMode.toString(), sources);
    }

    private class CampaignRenderer
    extends TreeColumnCellRenderer {
        public CampaignRenderer() {
            this.setTextNonSelectionColor(UIPropertyContext.getQualifiedColor());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            Object campaignObj = ((DefaultMutableTreeNode)value).getUserObject();
            if (campaignObj instanceof CampaignFacade) {
                CampaignFacade campaign = (CampaignFacade)campaignObj;
                List<CampaignFacade> testCampaigns = AdvancedSourceSelectionPanel.this.selectedCampaigns.getContents();
                testCampaigns.add(campaign);
                if (!FacadeFactory.passesPrereqs(testCampaigns)) {
                    this.setForeground(UIPropertyContext.getNotQualifiedColor());
                }
            }
            return this;
        }
    }

    private static enum SourceTreeView implements TreeView<CampaignFacade>
    {
        NAME("in_nameLabel"),
        PUBLISHER_NAME("in_src_pubName"),
        PUBLISHER_SETTING_NAME("in_src_pubSetName"),
        PUBLISHER_FORMAT_SETTING_NAME("in_src_pubFmtSetName");

        private String name;

        private SourceTreeView(String name) {
            this.name = LanguageBundle.getString(name);
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<CampaignFacade>> getPaths(CampaignFacade pobj) {
            String publisher = pobj.getPublisher();
            if (publisher == null) {
                publisher = LanguageBundle.getString("in_other");
            }
            String setting = pobj.getSetting();
            String format = pobj.getFormat();
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<CampaignFacade>(pobj));
                }
                case PUBLISHER_FORMAT_SETTING_NAME: {
                    if (format != null && setting != null) {
                        return Collections.singletonList(new TreeViewPath<CampaignFacade>(pobj, publisher, format, setting));
                    }
                    if (format != null) {
                        return Collections.singletonList(new TreeViewPath<CampaignFacade>(pobj, publisher, format));
                    }
                }
                case PUBLISHER_SETTING_NAME: {
                    if (setting != null) {
                        return Collections.singletonList(new TreeViewPath<CampaignFacade>(pobj, publisher, setting));
                    }
                }
                case PUBLISHER_NAME: {
                    return Collections.singletonList(new TreeViewPath<CampaignFacade>(pobj, (Object)publisher));
                }
            }
            throw new InternalError();
        }
    }

    private class SourceTreeViewModel
    implements TreeViewModel<CampaignFacade>,
    DataView<CampaignFacade>,
    ListListener<CampaignFacade> {
        private ListFacade<TreeView<CampaignFacade>> views = new DefaultListFacade<SourceTreeView>(Arrays.asList(SourceTreeView.values()));
        private DefaultListFacade<CampaignFacade> model;
        private ListFacade<CampaignFacade> baseModel = null;
        private final List<DefaultDataViewColumn> columns;
        private final boolean isAvailModel;

        public SourceTreeViewModel() {
            this.model = new DefaultListFacade();
            this.isAvailModel = true;
            this.columns = Arrays.asList(new DefaultDataViewColumn("in_src_bookType", String.class, true), new DefaultDataViewColumn("in_src_status", String.class, true), new DefaultDataViewColumn("in_src_loaded", String.class, false));
        }

        public SourceTreeViewModel(DefaultListFacade<CampaignFacade> model) {
            this.model = model;
            this.isAvailModel = false;
            this.columns = Arrays.asList(new DefaultDataViewColumn("in_src_bookType", String.class, false), new DefaultDataViewColumn("in_src_status", String.class, false), new DefaultDataViewColumn("in_src_loaded", String.class, false));
        }

        @Override
        public ListFacade<? extends TreeView<CampaignFacade>> getTreeViews() {
            return this.views;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return this.isAvailModel ? 2 : 0;
        }

        @Override
        public DataView<CampaignFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<CampaignFacade> getDataModel() {
            return this.model;
        }

        @Override
        public List<?> getData(CampaignFacade obj) {
            SourceSelectionFacade sourceFacade = AdvancedSourceSelectionPanel.this.frame.getCurrentSourceSelectionRef().getReference();
            boolean isLoaded = sourceFacade != null && sourceFacade.getCampaigns().containsElement(obj);
            return Arrays.asList(obj.getBookTypes(), obj.getStatus(), isLoaded ? LanguageBundle.getString("in_yes") : LanguageBundle.getString("in_no"));
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        public void setGameModel(GameModeFacade gameMode) {
            if (this.baseModel != null) {
                this.baseModel.removeListListener(this);
            }
            this.baseModel = FacadeFactory.getSupportedCampaigns(gameMode);
            this.model.setContents(ListFacades.wrap(this.baseModel));
            this.baseModel.addListListener(this);
        }

        @Override
        public void elementAdded(ListEvent<CampaignFacade> e) {
            this.model.addElement(e.getIndex(), e.getElement());
        }

        @Override
        public void elementRemoved(ListEvent<CampaignFacade> e) {
            this.model.removeElement(e.getIndex());
        }

        @Override
        public void elementsChanged(ListEvent<CampaignFacade> e) {
            this.model.setContents(ListFacades.wrap(this.baseModel));
        }

        @Override
        public void elementModified(ListEvent<CampaignFacade> e) {
        }

        @Override
        public String getPrefsKey() {
            return this.isAvailModel ? "SourceAvail" : "SourceSelected";
        }
    }

    private class UnloadAllAction
    extends AbstractAction {
        public UnloadAllAction() {
            super(LanguageBundle.getString("in_src_unloadAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedSourceSelectionPanel.this.frame.unloadSources();
            AdvancedSourceSelectionPanel.this.availableTable.refreshModelData();
            AdvancedSourceSelectionPanel.this.selectedTable.refreshModelData();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(LanguageBundle.getString("in_removeSelected"));
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
            AdvancedSourceSelectionPanel.this.selectedTable.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> list = AdvancedSourceSelectionPanel.this.selectedTable.getSelectedData();
            if (list != null && !list.isEmpty()) {
                for (Object obj : list) {
                    if (!(obj instanceof CampaignFacade)) continue;
                    AdvancedSourceSelectionPanel.this.selectedCampaigns.removeElement((CampaignFacade)obj);
                }
                AdvancedSourceSelectionPanel.this.rememberSelectedSources();
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super(LanguageBundle.getString("in_addSelected"));
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
            AdvancedSourceSelectionPanel.this.availableTable.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> list = AdvancedSourceSelectionPanel.this.availableTable.getSelectedData();
            if (list != null && !list.isEmpty()) {
                for (Object obj : list) {
                    if (!(obj instanceof CampaignFacade)) continue;
                    CampaignFacade camp = (CampaignFacade)obj;
                    if (AdvancedSourceSelectionPanel.this.selectedCampaigns.containsElement(camp)) continue;
                    AdvancedSourceSelectionPanel.this.selectedCampaigns.addElement(camp);
                    if (FacadeFactory.passesPrereqs(AdvancedSourceSelectionPanel.this.selectedCampaigns.getContents())) continue;
                    String prereqDesc = FacadeFactory.getCampaignInfoFactory().getRequirementsHTMLString(camp, AdvancedSourceSelectionPanel.this.selectedCampaigns.getContents());
                    JOptionPane.showMessageDialog(AdvancedSourceSelectionPanel.this, LanguageBundle.getFormattedString("in_src_badComboMsg", prereqDesc), LanguageBundle.getString("in_src_badComboTitle"), 1);
                    AdvancedSourceSelectionPanel.this.selectedCampaigns.removeElement(camp);
                }
                AdvancedSourceSelectionPanel.this.rememberSelectedSources();
            }
        }
    }
}

