/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.equip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.util.treetable.SortableTreeTableModel;
import pcgen.gui2.util.treetable.TreeTableNode;
import pcgen.util.CollectionMaps;
import pcgen.util.ListMap;

public class EquipmentTreeTableModel
implements SortableTreeTableModel,
ListListener<EquipmentSetFacade.EquipNode>,
EquipmentSetFacade.EquipmentTreeListener {
    private EventListenerList listenerList = new EventListenerList();
    private CharacterFacade character;
    private EquipmentSetFacade equipSet;
    private Object root = new Object();
    private ListMap<EquipmentSetFacade.EquipNode, EquipmentSetFacade.EquipNode, List<EquipmentSetFacade.EquipNode>> pathMap;
    private List<EquipmentSetFacade.EquipNode> bodySlotNodes;
    private Comparator<EquipmentSetFacade.EquipNode> pathComparator = new NodeComparator();

    public EquipmentTreeTableModel(CharacterFacade character, EquipmentSetFacade equipSet) {
        this.character = character;
        this.equipSet = equipSet;
        this.pathMap = CollectionMaps.createListMap(HashMap.class, ArrayList.class);
        this.bodySlotNodes = new ArrayList<EquipmentSetFacade.EquipNode>();
        this.initPathMap();
        equipSet.getNodes().addListListener(this);
        equipSet.addEquipmentTreeListener(this);
    }

    private void initPathMap() {
        ListFacade<EquipmentSetFacade.EquipNode> equipNodes = this.equipSet.getNodes();
        for (EquipmentSetFacade.EquipNode equipNode : equipNodes) {
            EquipmentSetFacade.EquipNode parent = equipNode.getParent();
            while (parent != null && !this.pathMap.containsValue(parent, equipNode)) {
                this.addNode(parent, equipNode);
                equipNode = parent;
                parent = equipNode.getParent();
            }
            if (parent != null || this.bodySlotNodes.contains(equipNode)) continue;
            this.addBodyNode(equipNode);
        }
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return column == 0;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return TreeTableNode.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Float.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        return null;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getValueAt(Object node, int column) {
        EquipmentSetFacade.EquipNode pathNode = (EquipmentSetFacade.EquipNode)node;
        if (column == 0) {
            return pathNode;
        }
        switch (pathNode.getNodeType()) {
            case BODY_SLOT: {
                switch (column) {
                    case 1: {
                        return "Type";
                    }
                    case 2: {
                        return "Located";
                    }
                    case 3: {
                        return "Qty";
                    }
                    case 4: {
                        return "Wgt";
                    }
                }
            }
            case PHANTOM_SLOT: {
                switch (column) {
                    case 2: {
                        return this.equipSet.getLocation(pathNode);
                    }
                }
                return null;
            }
            case EQUIPMENT: {
                switch (column) {
                    case 1: {
                        return pathNode.getEquipment().getTypes()[0];
                    }
                    case 2: {
                        return this.equipSet.getLocation(pathNode);
                    }
                    case 3: {
                        return this.equipSet.getQuantity(pathNode);
                    }
                    case 4: {
                        return Float.valueOf(this.character.getInfoFactory().getWeight(pathNode.getEquipment()));
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.bodySlotNodes.get(index);
        }
        return this.pathMap.get(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.bodySlotNodes.size();
        }
        return this.pathMap.size(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.root == node) {
            return false;
        }
        return !this.pathMap.containsKey(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            EquipmentSetFacade.EquipNode path = (EquipmentSetFacade.EquipNode)child;
            return this.bodySlotNodes.indexOf(path);
        }
        return this.pathMap.indexOf(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void sortModel(Comparator<List<?>> comparator) {
    }

    private void addBodyNode(EquipmentSetFacade.EquipNode bodyNode) {
        int insertion_index = Collections.binarySearch(this.bodySlotNodes, bodyNode, this.pathComparator);
        this.bodySlotNodes.add(-(insertion_index + 1), bodyNode);
    }

    private int addNode(EquipmentSetFacade.EquipNode parent, EquipmentSetFacade.EquipNode child) {
        int insertion_index;
        List children = (List)this.pathMap.get(parent);
        if (children == null) {
            children = Collections.emptyList();
        }
        if ((insertion_index = 1 + Collections.binarySearch(children, child, this.pathComparator)) < 0) {
            insertion_index *= -1;
        }
        this.pathMap.add(parent, insertion_index, child);
        return insertion_index;
    }

    @Override
    public void elementAdded(ListEvent<EquipmentSetFacade.EquipNode> e) {
        EquipmentSetFacade.EquipNode child = e.getElement();
        EquipmentSetFacade.EquipNode parent = child.getParent();
        int index = this.addNode(parent, child);
        this.fireTreeNodesInserted(this, this.getPathToRoot(parent), new int[]{index}, new Object[]{child});
    }

    @Override
    public void elementRemoved(ListEvent<EquipmentSetFacade.EquipNode> e) {
        EquipmentSetFacade.EquipNode child = e.getElement();
        EquipmentSetFacade.EquipNode parent = child.getParent();
        List children = (List)this.pathMap.get(parent);
        int index = children.indexOf(child);
        this.pathMap.remove((Object)parent, index);
        this.fireTreeNodesRemoved(this, this.getPathToRoot(parent), new int[]{index}, new Object[]{child});
    }

    @Override
    public void elementsChanged(ListEvent<EquipmentSetFacade.EquipNode> e) {
        this.pathMap.clear();
        this.initPathMap();
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
    }

    @Override
    public void elementModified(ListEvent<EquipmentSetFacade.EquipNode> e) {
    }

    @Override
    public void quantityChanged(EquipmentSetFacade.EquipmentTreeEvent e) {
        EquipmentSetFacade.EquipNode child = e.getNode();
        EquipmentSetFacade.EquipNode parent = child.getParent();
        List children = (List)this.pathMap.get(parent);
        int index = Collections.binarySearch(children, child, this.pathComparator);
        this.fireTreeNodesChanged(this, this.getPathToRoot(parent), new int[]{index}, new Object[]{child});
    }

    private Object[] getPathToRoot(EquipmentSetFacade.EquipNode node) {
        return this.getPathToRoot(node, 0);
    }

    private Object[] getPathToRoot(EquipmentSetFacade.EquipNode aNode, int depth) {
        Object[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new Object[depth + 1];
            retNodes[0] = this.root;
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private static class NodeComparator
    implements Comparator<EquipmentSetFacade.EquipNode> {
        private NodeComparator() {
        }

        @Override
        public int compare(EquipmentSetFacade.EquipNode o1, EquipmentSetFacade.EquipNode o2) {
            return o1.compareTo(o2);
        }
    }
}

