/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pcgen.gui2.util.JTableSortingHeader;
import pcgen.gui2.util.SortMode;
import pcgen.gui2.util.SortingPriority;
import pcgen.gui2.util.table.DefaultSortableTableModel;
import pcgen.gui2.util.table.SortableTableModel;
import pcgen.gui2.util.table.TableCellUtilities;
import pcgen.util.Comparators;

public class JTableEx
extends JTable {
    private static final long serialVersionUID = 514835142307946415L;
    public static final int ACTION_DOUBLECLICK = 2042;
    private final RowComparator rowComparator = new RowComparator();
    private List<SortingPriority> columnkeys;

    public JTableEx() {
        this(null, null, null);
    }

    public JTableEx(SortableTableModel tm) {
        this(tm, null, null);
    }

    public JTableEx(SortableTableModel tm, TableColumnModel tcm) {
        this(tm, tcm, null);
    }

    public JTableEx(SortableTableModel tm, TableColumnModel tcm, ListSelectionModel lsm) {
        super(tm, tcm, lsm);
        this.setDefaultRenderer(BigDecimal.class, new TableCellUtilities.AlignRenderer(4));
        this.setDefaultRenderer(Float.class, new TableCellUtilities.AlignRenderer(4));
        this.setDefaultRenderer(Integer.class, new TableCellUtilities.AlignRenderer(4));
        this.setSortingPriority(this.createDefaultSortingPriority());
        this.setTableHeader(new JTableSortingHeader(this));
        this.setFillsViewportHeight(true);
        this.installDoubleCLickListener();
    }

    protected List<SortingPriority> createDefaultSortingPriority() {
        Vector<SortingPriority> list = new Vector<SortingPriority>();
        list.add(new SortingPriority(0, SortMode.ASCENDING));
        return list;
    }

    private void installDoubleCLickListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getComponent().isEnabled() && e.getButton() == 1 && e.getClickCount() == 2) {
                    Point p = e.getPoint();
                    int row = JTableEx.this.convertRowIndexToModel(JTableEx.this.rowAtPoint(p));
                    int column = JTableEx.this.convertColumnIndexToModel(JTableEx.this.columnAtPoint(p));
                    Object value = JTableEx.this.getModel().getValueAt(row, column);
                    JTableEx.this.fireActionEvent(JTableEx.this, 2042, String.valueOf(value));
                }
            }
        });
    }

    private void fireActionEvent(Object value, int id, String command) {
        ActionEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(value, id, command);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    @Override
    public void setModel(TableModel model) {
        if (!(model instanceof SortableTableModel)) {
            model = new DefaultSortableTableModel(model);
        }
        super.setModel(model);
        this.sortModel();
    }

    @Override
    public SortableTableModel getModel() {
        return (SortableTableModel)super.getModel();
    }

    public void setColAlign(int col, int alignment) {
        this.getColumnModel().getColumn(col).setCellRenderer(new TableCellUtilities.AlignRenderer(alignment));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public void toggleSort(int column) {
        int index;
        Vector<SortingPriority> list = new Vector<SortingPriority>(this.getSortingPriority());
        for (index = list.size() - 1; index >= 0 && list.get(index).getColumn() != column; --index) {
        }
        switch (index) {
            case 0: {
                if (list.get(0).getMode() == SortMode.ASCENDING) {
                    list.set(0, new SortingPriority(column, SortMode.DESCENDING));
                    break;
                }
            }
            default: {
                list.remove(index);
            }
            case -1: {
                list.add(0, new SortingPriority(column, SortMode.ASCENDING));
            }
        }
        if (list.size() > 2) {
            list.setSize(2);
        }
        this.setSortingPriority(list);
    }

    public void setSortingPriority(List<SortingPriority> keys) {
        this.columnkeys = Collections.unmodifiableList(keys);
        this.sortModel();
    }

    public void sortModel() {
        if (this.getAutoCreateColumnsFromModel()) {
            TableColumnModel old = this.getColumnModel();
            this.setColumnModel(new DefaultTableColumnModel());
            this.getModel().sortModel(this.rowComparator);
            this.setColumnModel(old);
        } else {
            this.getModel().sortModel(this.rowComparator);
        }
    }

    public List<SortingPriority> getSortingPriority() {
        return this.columnkeys;
    }

    private final class RowComparator
    implements Comparator<List<?>> {
        private RowComparator() {
        }

        @Override
        public int compare(List<?> o1, List<?> o2) {
            SortableTableModel model = JTableEx.this.getModel();
            for (SortingPriority priority : JTableEx.this.columnkeys) {
                if (priority.getMode() == SortMode.UNORDERED) continue;
                int column = priority.getColumn();
                Comparator<?> comparator = Comparators.getComparatorFor(model.getColumnClass(column));
                Object obj1 = null;
                Object obj2 = null;
                if (o1.size() > column) {
                    obj1 = o1.get(column);
                }
                if (o2.size() > column) {
                    obj2 = o2.get(column);
                }
                int ret = obj1 == null || obj2 == null ? (obj1 == obj2 ? 0 : (obj1 == null ? -1 : 1)) : comparator.compare(obj1, obj2);
                if (priority.getMode() == SortMode.DESCENDING) {
                    ret *= -1;
                }
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    }
}

