/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SystemCollections;
import pcgen.io.PCGFile;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.system.ConfigurationSettings;

public class VariableReport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(Map<ReportFormat, String> reportNameMap) throws IOException, TemplateException {
        List<GameMode> games = SystemCollections.getUnmodifiableGameModeList();
        TreeMap<String, List<VarDefine>> gameModeVarMap = new TreeMap<String, List<VarDefine>>();
        TreeMap<String, Integer> gameModeVarCountMap = new TreeMap<String, Integer>();
        for (GameMode gameMode : games) {
            ArrayList<VarDefine> varList = new ArrayList<VarDefine>();
            HashMap<String, Integer> varCountMap = new HashMap<String, Integer>();
            HashSet<File> processedLstFiles = new HashSet<File>();
            List<Campaign> campaignsForGameMode = this.getCampaignsForGameMode(gameMode);
            for (Campaign campaign : campaignsForGameMode) {
                this.processCampaign(campaign, varList, varCountMap, processedLstFiles);
            }
            Collections.sort(varList);
            gameModeVarMap.put(gameMode.getName(), varList);
            gameModeVarCountMap.put(gameMode.getName(), varCountMap.size());
        }
        for (Map.Entry entry : reportNameMap.entrySet()) {
            FileWriter file = new FileWriter(new File((String)entry.getValue()));
            try {
                this.outputReport(gameModeVarMap, gameModeVarCountMap, (ReportFormat)((Object)entry.getKey()), file);
            }
            finally {
                IOUtils.closeQuietly((Writer)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputReport(Map<String, List<VarDefine>> gameModeVarMap, Map<String, Integer> gameModeVarCountMap, ReportFormat reportFormat, Writer outputWriter) throws IOException, TemplateException {
        Writer file = null;
        Configuration cfg = new Configuration();
        int dataPathLen = ConfigurationSettings.getPccFilesDir().length();
        try {
            File codeDir = new File("code");
            File templateDir = new File(codeDir, "templates");
            cfg.setDirectoryForTemplateLoading(templateDir);
            Template template = cfg.getTemplate(reportFormat.getTemplate());
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("gameModeVarMap", gameModeVarMap);
            input.put("gameModeVarCountMap", gameModeVarCountMap);
            input.put("pathIgnoreLen", dataPathLen + 1);
            template.process(input, outputWriter);
            outputWriter.flush();
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e2) {}
            }
        }
    }

    private List<Campaign> getCampaignsForGameMode(GameMode game) {
        ArrayList<String> gameModeList = new ArrayList<String>();
        gameModeList.addAll(game.getAllowedModes());
        List<Campaign> allCampaigns = Globals.getCampaignList();
        HashSet<Campaign> gameModeCampaigns = new HashSet<Campaign>();
        for (Campaign campaign : allCampaigns) {
            if (!campaign.containsAnyInList(ListKey.GAME_MODE, gameModeList)) continue;
            gameModeCampaigns.add(campaign);
            for (CampaignSourceEntry fName : campaign.getSafeListFor(ListKey.FILE_PCC)) {
                Campaign c;
                URI uri = fName.getURI();
                if (!PCGFile.isPCGenCampaignFile(uri) || (c = Globals.getCampaignByURI(uri, false)) == null) continue;
                gameModeCampaigns.add(c);
            }
        }
        return new ArrayList<Campaign>(gameModeCampaigns);
    }

    private List<File> processCampaign(Campaign campaign, List<VarDefine> varList, Map<String, Integer> varCountMap, Set<File> processedLstFiles) throws FileNotFoundException, IOException {
        ArrayList<CampaignSourceEntry> cseList = new ArrayList<CampaignSourceEntry>();
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_LST_EXCLUDE));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_RACE));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_CLASS));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_COMPANION_MOD));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_SKILL));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_ABILITY_CATEGORY));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_ABILITY));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_FEAT));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_DEITY));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_DOMAIN));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_WEAPON_PROF));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_ARMOR_PROF));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_SHIELD_PROF));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_EQUIP));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_SPELL));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_LANGUAGE));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_TEMPLATE));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_EQUIP_MOD));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_KIT));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_BIO_SET));
        cseList.addAll(campaign.getSafeListFor(ListKey.FILE_DATACTRL));
        ArrayList<File> missingLstFiles = new ArrayList<File>();
        for (CampaignSourceEntry cse : cseList) {
            File lstFile = new File(cse.getURI());
            if (!lstFile.exists()) {
                missingLstFiles.add(lstFile);
                continue;
            }
            if (processedLstFiles.contains(lstFile)) continue;
            processedLstFiles.add(lstFile);
            this.processLstFile(varList, varCountMap, lstFile);
        }
        return missingLstFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLstFile(List<VarDefine> varList, Map<String, Integer> varCountMap, File file) throws FileNotFoundException, IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            HashMap<String, String> varUseMap = new HashMap<String, String>();
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("###VAR:")) {
                    String[] varUse = line.trim().split("\t");
                    if (varUse.length >= 2 && varUse[1].startsWith("USE:")) {
                        varUseMap.put(varUse[0].substring(7), varUse[1].substring(4));
                    }
                } else if (!line.startsWith("#") && StringUtils.isNotBlank(line)) {
                    String[] tokens = line.split("\t");
                    String object = tokens[0];
                    for (String tok : tokens) {
                        if (!tok.startsWith("DEFINE:")) continue;
                        String[] define = tok.split("[:|]");
                        String varName = define[1];
                        if (define.length <= 1 || varName.startsWith("LOCK.") || varName.startsWith("UNLOCK.")) continue;
                        varList.add(new VarDefine(varName, object, file, (String)varUseMap.get(varName)));
                        Integer count = varCountMap.get(varName);
                        if (count == null) {
                            count = 0;
                        }
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                        varCountMap.put(varName, count);
                    }
                }
                line = br.readLine();
            }
        }
    }

    public static class VarDefine
    implements Comparable<VarDefine> {
        private final String varName;
        private final String definingObject;
        private File definingFile;
        private String use;

        public VarDefine(String varName, String definingObject, File definingFile, String use) {
            this.varName = varName;
            this.definingObject = definingObject;
            this.definingFile = definingFile;
            this.use = use;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.varName == null ? 0 : this.varName.hashCode());
            result = 31 * result + (this.definingObject == null ? 0 : this.definingObject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof VarDefine)) {
                return false;
            }
            VarDefine other = (VarDefine)obj;
            if (this.varName == null ? other.varName != null : !this.varName.equals(other.varName)) {
                return false;
            }
            return !(this.definingObject == null ? other.definingObject != null : !this.definingObject.equals(other.definingObject));
        }

        @Override
        public int compareTo(VarDefine other) {
            if (this.varName == null) {
                if (other.varName != null) {
                    return -1;
                }
                return 0;
            }
            if (other.varName == null) {
                return 1;
            }
            return this.varName.compareToIgnoreCase(other.varName);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(100);
            builder.append("VarDefine [varName=");
            builder.append(this.varName);
            builder.append(", definingObject=");
            builder.append(this.definingObject);
            builder.append(", definingFile=");
            builder.append(this.definingFile);
            builder.append(", use=");
            builder.append(this.use);
            builder.append("]");
            return builder.toString();
        }

        public String getVarName() {
            return this.varName;
        }

        public String getDefiningObject() {
            return this.definingObject;
        }

        public File getDefiningFile() {
            return this.definingFile;
        }

        public void setDefiningFile(File definingFile) {
            this.definingFile = definingFile;
        }

        public String getUse() {
            return this.use;
        }

        public void setUse(String use) {
            this.use = use;
        }
    }

    public static enum ReportFormat {
        HTML("variable-report-html.ftl"),
        CSV("variable-report-csv.ftl");

        private final String template;

        private ReportFormat(String template) {
            this.template = template;
        }

        public String getTemplate() {
            return this.template;
        }
    }
}

