/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.ShieldProfProvider;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.ShieldProf;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class ShieldProfToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<ShieldProf> {
    private static final Class<ShieldProf> SHIELDPROF_CLASS = ShieldProf.class;
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    @Override
    public String getParentToken() {
        return "AUTO";
    }

    @Override
    public String getTokenName() {
        return "SHIELDPROF";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String shieldProf;
        Prerequisite prereq = null;
        boolean isPre = false;
        if (value.indexOf("[") == -1) {
            shieldProf = value;
            StringTokenizer tok = new StringTokenizer(shieldProf, "|");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (!PreParserFactory.isPreReqString(token)) continue;
                if (isPre) {
                    String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                    Logging.errorPrint(errorText);
                    return new ParseResult.Fail(errorText, context);
                }
                prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
                }
                int preStart = value.indexOf(token) - 1;
                shieldProf = value.substring(0, preStart);
                isPre = true;
            }
        } else {
            return new ParseResult.Fail("Use of [] for Prerequisites has been removed. Please use | based standard", context);
        }
        ParseResult pr = this.checkForIllegalSeparator('|', shieldProf);
        if (!pr.passed()) {
            return pr;
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(shieldProf, "|");
        ArrayList<CDOMReference<ShieldProf>> shieldProfs = new ArrayList<CDOMReference<ShieldProf>>();
        ArrayList<CDOMReference<Equipment>> equipTypes = new ArrayList<CDOMReference<Equipment>>();
        while (tok.hasMoreTokens()) {
            String aProf = tok.nextToken();
            if ("%LIST".equals(aProf)) {
                ChooseSelectionActor<ShieldProf> cra;
                foundOther = true;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor<ShieldProf> cca = new ConditionalSelectionActor<ShieldProf>(this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, cra);
                continue;
            }
            if ("ALL".equalsIgnoreCase(aProf)) {
                foundAny = true;
                shieldProfs.add(context.getReferenceContext().getCDOMAllReference(SHIELDPROF_CLASS));
                continue;
            }
            if (aProf.startsWith("SHIELDTYPE.") || aProf.startsWith("SHIELDTYPE=")) {
                foundOther = true;
                CDOMGroupRef<Equipment> ref = TokenUtilities.getTypeReference(context, EQUIPMENT_CLASS, "SHIELD." + aProf.substring(11));
                if (ref == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                equipTypes.add(ref);
                continue;
            }
            foundOther = true;
            shieldProfs.add(context.getReferenceContext().getCDOMReference(SHIELDPROF_CLASS, aProf));
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        if (!shieldProfs.isEmpty() || !equipTypes.isEmpty()) {
            ShieldProfProvider pp = new ShieldProfProvider((List<CDOMReference<ShieldProf>>)shieldProfs, (List<CDOMReference<Equipment>>)equipTypes);
            if (prereq != null) {
                pp.addPrerequisite(prereq);
            }
            context.getObjectContext().addToList(obj, ListKey.AUTO_SHIELDPROF, pp);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<ShieldProfProvider> changes = context.getObjectContext().getListChanges(obj, ListKey.AUTO_SHIELDPROF);
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Collection<ShieldProfProvider> added = changes.getAdded();
        TreeSet<String> set = new TreeSet<String>();
        Collection<ChooseSelectionActor<?>> listAdded = listChanges.getAdded();
        boolean foundAny = false;
        boolean foundOther = false;
        if (listAdded != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor chooseSelectionActor : listAdded) {
                if (!chooseSelectionActor.getSource().equals(this.getTokenName())) continue;
                try {
                    set.add(chooseSelectionActor.getLstFormat());
                    foundOther = true;
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
            }
        }
        if (added != null) {
            for (ShieldProfProvider shieldProfProvider : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(shieldProfProvider.getLstFormat());
                if (shieldProfProvider.hasPrerequisites()) {
                    sb.append('|');
                    sb.append(this.getPrerequisiteString(context, shieldProfProvider.getPrerequisiteList()));
                }
                String ab = sb.toString();
                boolean isUnconditionalAll = "ALL".equals(ab);
                foundAny |= isUnconditionalAll;
                foundOther |= !isUnconditionalAll;
                set.add(ab);
            }
        }
        if (foundAny && foundOther) {
            context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + set);
            return null;
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(ChooseDriver obj, ShieldProf sp, PlayerCharacter pc) {
        pc.addShieldProf(obj, sp);
    }

    @Override
    public void removeChoice(ChooseDriver obj, ShieldProf sp, PlayerCharacter pc) {
        pc.removeShieldProf(obj, sp);
    }

    @Override
    public Class<ShieldProf> getChoiceClass() {
        return SHIELDPROF_CLASS;
    }

    @Override
    public String getSource() {
        return this.getTokenName();
    }

    @Override
    public String getLstFormat() {
        return "%LIST";
    }
}

