/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcreteTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SkilllistToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<ClassSkillList> SKILLLIST_CLASS = ClassSkillList.class;

    @Override
    public String getTokenName() {
        return "SKILLLIST";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        Formula count = FormulaFactory.getFormulaFor(tok.nextToken());
        if (!count.isValid()) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
        }
        if (!count.isStatic() || count.resolveStatic().intValue() <= 0) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " must be > 0", context);
        }
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " must have a | separating " + "count from the list of possible values: " + value, context);
        }
        ArrayList<CDOMGroupRef<ClassSkillList>> refs = new ArrayList<CDOMGroupRef<ClassSkillList>>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            CDOMReference ref = "ALL".equals(token) ? context.getReferenceContext().getCDOMAllReference(SKILLLIST_CLASS) : context.getReferenceContext().getCDOMReference(SKILLLIST_CLASS, token);
            refs.add((CDOMGroupRef<ClassSkillList>)ref);
        }
        ReferenceChoiceSet rcs = new ReferenceChoiceSet(refs);
        if (!rcs.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value);
        }
        ChoiceSet cs = new ChoiceSet(this.getTokenName(), rcs);
        cs.setTitle("Select class whose class-skills this class will inherit");
        ConcreteTransitionChoice tc = new ConcreteTransitionChoice(cs, count);
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.SKILLLIST_CHOICE, tc);
        tc.setRequired(false);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        TransitionChoice<ClassSkillList> grantChanges = context.getObjectContext().getObject(pcc, ObjectKey.SKILLLIST_CHOICE);
        if (grantChanges == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Formula count = grantChanges.getCount();
        if (count == null) {
            context.addWriteMessage("Unable to find " + this.getTokenName() + " Count");
            return null;
        }
        sb.append(count);
        sb.append("|");
        sb.append(grantChanges.getChoices().getLSTformat().replaceAll(",", "|"));
        return new String[]{sb.toString()};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

