/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreSkillTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) {
        Set<Skill> targets;
        boolean isType;
        CharacterDisplay display = character.getDisplay();
        int requiredRanks = Integer.parseInt(prereq.getOperand());
        String requiredSkillKey = prereq.getKey().toUpperCase();
        if (prereq.getSubKey() != null) {
            requiredSkillKey = requiredSkillKey + " (" + prereq.getSubKey().toUpperCase() + ")";
        }
        boolean bl = isType = requiredSkillKey.startsWith("TYPE.") || requiredSkillKey.startsWith("TYPE=");
        if (isType) {
            requiredSkillKey = requiredSkillKey.substring(5);
        }
        String skillKey = requiredSkillKey;
        int percentageSignPosition = skillKey.lastIndexOf(37);
        HashMap<Skill, Set<Skill>> serveAsSkills = new HashMap<Skill, Set<Skill>>();
        HashSet<Skill> imitators = new HashSet<Skill>();
        this.getImitators(serveAsSkills, imitators, display);
        int runningTotal = 0;
        boolean foundMatch = false;
        boolean foundSkill = false;
        for (Skill aSkill : display.getSkillSet()) {
            String aSkillKey = aSkill.getKeyName().toUpperCase();
            if (isType) {
                if (percentageSignPosition >= 0) {
                    foundMatch = this.matchesTypeWildCard(skillKey, percentageSignPosition, foundSkill, aSkill);
                    foundSkill = foundMatch;
                    runningTotal = this.getRunningTotal(aSkill, character, prereq, foundMatch, runningTotal, requiredRanks);
                } else if (aSkill.isType(skillKey)) {
                    foundMatch = true;
                    foundSkill = true;
                    runningTotal = this.getRunningTotal(aSkill, character, prereq, foundMatch, runningTotal, requiredRanks);
                }
                if (runningTotal == 0) {
                    foundMatch = false;
                }
            } else if (aSkillKey.equals(skillKey) || percentageSignPosition >= 0 && aSkillKey.startsWith(skillKey.substring(0, percentageSignPosition))) {
                foundMatch = true;
                foundSkill = true;
                runningTotal = this.getRunningTotal(aSkill, character, prereq, foundMatch, runningTotal, requiredRanks);
            }
            if (prereq.isCountMultiples() || prereq.isTotalValues()) {
                foundMatch = false;
            }
            if (!foundMatch) continue;
            break;
        }
        if (!isType && !foundSkill) {
            block1: for (Skill mock : serveAsSkills.keySet()) {
                targets = serveAsSkills.get(mock);
                for (Skill target : targets) {
                    int theTotal;
                    if (foundSkill) continue block1;
                    String aSkillKey = target.getKeyName().toUpperCase();
                    if (target.getDisplayName().equalsIgnoreCase(skillKey)) {
                        foundSkill = true;
                        foundMatch = true;
                        theTotal = this.getRunningTotal(mock, character, prereq, foundMatch, runningTotal, requiredRanks);
                        runningTotal += theTotal;
                        continue;
                    }
                    if (!aSkillKey.equals(skillKey) && (percentageSignPosition < 0 || !aSkillKey.startsWith(skillKey.substring(0, percentageSignPosition)))) continue;
                    foundSkill = true;
                    foundMatch = true;
                    theTotal = this.getRunningTotal(mock, character, prereq, foundMatch, runningTotal, requiredRanks);
                    runningTotal += theTotal;
                }
            }
        } else if (isType && !foundSkill) {
            block3: for (Skill mock : serveAsSkills.keySet()) {
                targets = serveAsSkills.get(mock);
                block4: for (Skill target : targets) {
                    if (foundSkill) continue block3;
                    if (target.isType(skillKey)) {
                        foundSkill = true;
                        foundMatch = true;
                        int theTotal = this.getRunningTotal(mock, character, prereq, foundMatch, runningTotal, requiredRanks);
                        runningTotal += theTotal;
                        continue;
                    }
                    if (percentageSignPosition < 0) continue;
                    List<Type> mockTypes = target.getTrueTypeList(true);
                    for (Type mockType : mockTypes) {
                        foundMatch = this.matchesTypeWildCard(skillKey, percentageSignPosition, foundSkill, target);
                        foundSkill = foundMatch;
                        runningTotal = this.getRunningTotal(mock, character, prereq, foundMatch, runningTotal, requiredRanks);
                        if (!foundSkill) continue;
                        continue block4;
                    }
                }
            }
        }
        if (!foundSkill && prereq.getOperator() == PrerequisiteOperator.LT) {
            ++runningTotal;
        }
        return this.countedTotal(prereq, runningTotal);
    }

    private void getImitators(HashMap<Skill, Set<Skill>> serveAsSkills, Set<Skill> imitators, CharacterDisplay display) {
        HashSet<Skill> skillSet = new HashSet<Skill>(display.getSkillSet());
        for (Skill aSkill : skillSet) {
            HashSet<Skill> servesAs = new HashSet<Skill>();
            for (CDOMReference<Skill> ref : aSkill.getSafeListFor(ListKey.SERVES_AS_SKILL)) {
                servesAs.addAll(ref.getContainedObjects());
            }
            if (servesAs.size() <= 0) continue;
            imitators.add(aSkill);
            serveAsSkills.put(aSkill, servesAs);
        }
    }

    @Override
    public String kindHandled() {
        return "SKILL";
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        String skillName = prereq.getKey();
        if (prereq.getSubKey() != null && !prereq.getSubKey().equals("")) {
            skillName = skillName + " (" + prereq.getSubKey() + ")";
        }
        String foo = LanguageBundle.getFormattedString("PreSkill.toHtml", prereq.getOperator().toDisplayString(), prereq.getOperand(), skillName);
        return foo;
    }

    private boolean matchesTypeWildCard(String skillKey, int percentageSignPosition, boolean found, Skill aSkill) {
        for (Type type : aSkill.getTrueTypeList(false)) {
            if (!type.toString().toUpperCase().startsWith(skillKey.substring(0, percentageSignPosition))) continue;
            found = true;
            break;
        }
        return found;
    }

    private int getRunningTotal(Skill aSkill, PlayerCharacter character, Prerequisite prereq, boolean foundMatch, int runningTotal, int requiredRanks) {
        if (foundMatch) {
            if (prereq.isTotalValues()) {
                runningTotal += SkillRankControl.getTotalRank(character, aSkill).intValue();
            } else if (prereq.getOperator().compare(SkillRankControl.getTotalRank(character, aSkill).intValue(), requiredRanks) > 0) {
                ++runningTotal;
            }
        }
        return runningTotal;
    }
}

