/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.Follower;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.FollowerToken;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class FollowerTypeToken
extends Token {
    public static final String TOKENNAME = "FOLLOWERTYPE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        String typeString = aTok.nextToken();
        StringBuilder restString = new StringBuilder();
        int followerIndex = -1;
        if (aTok.hasMoreTokens()) {
            block8: {
                String startString = aTok.nextToken();
                try {
                    followerIndex = Integer.parseInt(startString);
                }
                catch (NumberFormatException exc) {
                    Logging.errorPrint((String)"Old syntax FOLLOWERTYPEx will be replaced for FOLLOWERTYPE.x");
                    restString.append(startString);
                    int numCharToRemove = 0;
                    for (int i = typeString.length() - 1; i > 0; --i) {
                        if (typeString.charAt(i) >= '0' && typeString.charAt(i) <= '9') {
                            followerIndex = Integer.parseInt(typeString.substring(i));
                            ++numCharToRemove;
                            continue;
                        }
                        i = 0;
                    }
                    if (numCharToRemove <= 0) break block8;
                    typeString = typeString.substring(0, typeString.length() - numCharToRemove);
                }
            }
            while (aTok.hasMoreTokens()) {
                restString.append(".").append(aTok.nextToken());
            }
            if (restString.indexOf(".") == 0) {
                restString.deleteCharAt(0);
            }
        }
        String result = "";
        List<Follower> aList = this.getFollowersOfType(pc.getDisplay(), typeString);
        if (followerIndex > -1 && followerIndex < aList.size()) {
            result = FollowerToken.getFollowerOutput((ExportHandler)eh, (String)restString.toString(), (Follower)aList.get(followerIndex));
        }
        return result;
    }

    private List<Follower> getFollowersOfType(CharacterDisplay display, String typeString) {
        ArrayList<Follower> aList = new ArrayList<Follower>();
        for (Follower fol : display.getFollowerList()) {
            if (!fol.getType().getKeyName().equalsIgnoreCase(typeString)) continue;
            aList.add(fol);
        }
        return aList;
    }
}

