/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Language;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class LangToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<Language> {
    private static final Class<Language> LANGUAGE_CLASS = Language.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "LANG";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String lang = value;
        ParseResult pr = this.checkSeparatorsAndNonEmpty('|', lang);
        if (!pr.passed()) {
            return pr;
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(lang, "|");
        boolean isPre = false;
        Prerequisite prereq = null;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (!PreParserFactory.isPreReqString((String)token)) continue;
            if (isPre) {
                String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                Logging.errorPrint((String)errorText);
                return new ParseResult.Fail(errorText, context);
            }
            prereq = this.getPrerequisite(token);
            if (prereq == null) {
                return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
            }
            int preStart = value.indexOf(token) - 1;
            lang = value.substring(0, preStart);
            isPre = true;
        }
        boolean firstToken = true;
        tok = new StringTokenizer(lang, "|");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (".CLEAR".equals(token)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEAR must be the first argument", context);
                }
                context.getObjectContext().removeList(obj, ListKey.AUTO_LANGUAGE);
            } else if ("%LIST".equals(token)) {
                LangToken cra;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor cca = new ConditionalSelectionActor((ChooseSelectionActor)this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                foundOther = true;
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, (Object)cra);
            } else if ("ALL".equals(token)) {
                foundAny = true;
                context.getObjectContext().addToList(obj, ListKey.AUTO_LANGUAGE, (Object)new QualifiedObject((Object)context.getReferenceContext().getCDOMAllReference(LANGUAGE_CLASS), prereq));
            } else {
                foundOther = true;
                CDOMReference ref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, LANGUAGE_CLASS, (String)token);
                if (ref == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                }
                context.getObjectContext().addToList(obj, ListKey.AUTO_LANGUAGE, (Object)new QualifiedObject((Object)ref, prereq));
            }
            firstToken = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.AUTO_LANGUAGE);
        Changes listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Collection added = changes.getAdded();
        StringBuilder sb = new StringBuilder();
        Collection listAdded = listChanges.getAdded();
        boolean foundAny = false;
        boolean foundOther = false;
        if (changes.includesGlobalClear()) {
            sb.append(".CLEAR");
        }
        if (listAdded != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor cra : listAdded) {
                if (!cra.getSource().equals(this.getTokenName())) continue;
                try {
                    if (sb.length() > 0) {
                        sb.append('|');
                    }
                    sb.append(cra.getLstFormat());
                    foundOther = true;
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
            }
        }
        if (added != null) {
            boolean needPipe = sb.length() > 0;
            Prerequisite prereq = null;
            for (QualifiedObject spp : added) {
                CDOMReference lang = (CDOMReference)spp.getRawObject();
                List prereqs = spp.getPrerequisiteList();
                String ab = lang.getLSTformat(false);
                boolean isUnconditionalAll = "ALL".equals(ab);
                foundAny |= isUnconditionalAll;
                foundOther |= !isUnconditionalAll;
                if (needPipe) {
                    sb.append('|');
                }
                needPipe = true;
                if (prereqs != null && !prereqs.isEmpty()) {
                    if (prereqs.size() > 1) {
                        context.addWriteMessage("Error: " + obj.getClass().getSimpleName() + " had more than one Prerequisite for " + this.getFullName());
                        return null;
                    }
                    Prerequisite p = (Prerequisite)prereqs.get(0);
                    if (prereq != null && !p.equals((Object)prereq)) {
                        context.addWriteMessage("Error: " + obj.getClass().getSimpleName() + " had differing Prerequisites for " + this.getFullName());
                        return null;
                    }
                    prereq = p;
                }
                sb.append(ab);
            }
            if (prereq != null) {
                StringWriter swriter = new StringWriter();
                try {
                    prereqWriter.write((Writer)swriter, prereq);
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
                sb.append('|').append(swriter.toString());
            }
        }
        if (foundAny && foundOther) {
            context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + sb);
            return null;
        }
        if (sb.length() == 0) {
            return null;
        }
        return new String[]{sb.toString()};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(ChooseDriver obj, Language l, PlayerCharacter pc) {
        pc.addAutoLanguage(l, (Object)obj);
    }

    public void removeChoice(ChooseDriver obj, Language l, PlayerCharacter pc) {
        pc.removeAutoLanguage(l, (Object)obj);
    }

    public Class<Language> getChoiceClass() {
        return LANGUAGE_CLASS;
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

