/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public class KunststoffToolBarUI
extends MetalToolBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new KunststoffToolBarUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        int n = 0;
        if (jComponent instanceof JToolBar) {
            n = ((JToolBar)jComponent).getOrientation();
        }
        if (n == 0) {
            Serializable serializable;
            Color color;
            ColorUIResource colorUIResource = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorUIResource != null) {
                color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
                serializable = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight() / 2);
                KunststoffUtilities.drawGradient(graphics, colorUIResource, color, (Rectangle)serializable, true);
            }
            if ((color = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                serializable = KunststoffUtilities.getTranslucentColor(color, 0);
                Rectangle rectangle = new Rectangle(0, jComponent.getHeight() / 2, jComponent.getWidth(), jComponent.getHeight() / 2);
                KunststoffUtilities.drawGradient(graphics, serializable, color, rectangle, true);
            }
        } else {
            Serializable serializable;
            Color color;
            ColorUIResource colorUIResource = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorUIResource != null) {
                color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
                serializable = new Rectangle(0, 0, jComponent.getWidth() / 2, jComponent.getHeight());
                KunststoffUtilities.drawGradient(graphics, colorUIResource, color, (Rectangle)serializable, false);
            }
            if ((color = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                serializable = KunststoffUtilities.getTranslucentColor(color, 0);
                Rectangle rectangle = new Rectangle(jComponent.getWidth() / 2, 0, jComponent.getWidth() / 2, jComponent.getHeight());
                KunststoffUtilities.drawGradient(graphics, serializable, color, rectangle, false);
            }
        }
    }
}

