/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;

public class DoubleKeyMap<K1, K2, V>
implements Cloneable {
    private final Class<? extends Map> firstClass;
    private final Class<? extends Map> secondClass;
    private Map<K1, Map<K2, V>> map;
    private boolean cleanup = true;

    public DoubleKeyMap() {
        this.firstClass = HashMap.class;
        this.secondClass = this.firstClass;
        this.map = new HashMap<K1, Map<K2, V>>();
    }

    public DoubleKeyMap(Class<? extends Map> cl1, Class<? extends Map> cl2) {
        if (cl1 == null) {
            throw new IllegalArgumentException("First underlying Class cannot be null for DoubleKeyMap");
        }
        if (cl2 == null) {
            throw new IllegalArgumentException("Second underlying Class cannot be null for DoubleKeyMap");
        }
        this.firstClass = cl1;
        this.secondClass = cl2;
        this.map = this.createGlobalMap();
        this.createLocalMap();
    }

    public DoubleKeyMap(DoubleKeyMap<K1, K2, V> otherMap) {
        this(otherMap.firstClass, otherMap.secondClass);
        this.putAll(otherMap);
    }

    public V put(K1 key1, K2 key2, V value) {
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap == null) {
            localMap = this.createLocalMap();
            this.map.put(key1, localMap);
        }
        return localMap.put(key2, value);
    }

    public final void putAll(DoubleKeyMap<K1, K2, V> dkm) {
        for (Map.Entry<K1, Map<K2, V>> me : dkm.map.entrySet()) {
            Map<K2, V> localMap = this.map.get(me.getKey());
            if (localMap == null) {
                localMap = this.createLocalMap();
                this.map.put(me.getKey(), localMap);
            }
            localMap.putAll(me.getValue());
        }
    }

    public V get(K1 key1, K2 key2) {
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap == null) {
            return null;
        }
        return localMap.get(key2);
    }

    public Map<K2, V> getMapFor(K1 key1) {
        Map<K2, V> localMap = this.map.get(key1);
        Map<K2, V> copy = this.createLocalMap();
        if (localMap != null) {
            copy.putAll(localMap);
        }
        return copy;
    }

    public boolean containsKey(K1 key1) {
        return this.map.containsKey(key1);
    }

    public boolean containsKey(K1 key1, K2 key2) {
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap == null) {
            return false;
        }
        return localMap.containsKey(key2);
    }

    public V remove(K1 key1, K2 key2) {
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap == null) {
            return null;
        }
        V removed = localMap.remove(key2);
        if (this.cleanup && localMap.isEmpty()) {
            this.map.remove(key1);
        }
        return removed;
    }

    public Map<K2, V> removeAll(K1 key1) {
        return this.map.remove(key1);
    }

    public Set<K1> getKeySet() {
        return new WrappedMapSet<K1>(this.firstClass, this.map.keySet());
    }

    public Set<K2> getSecondaryKeySet(K1 key1) {
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap == null) {
            return Collections.emptySet();
        }
        return new WrappedMapSet<K2>(this.secondClass, localMap.keySet());
    }

    public void clear() {
        this.cleanup = true;
        this.map.clear();
    }

    public Set<V> values(K1 key1) {
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap == null) {
            return Collections.emptySet();
        }
        return new HashSet<V>(localMap.values());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int primaryKeyCount() {
        return this.map.size();
    }

    public DoubleKeyMap<K1, K2, V> clone() throws CloneNotSupportedException {
        DoubleKeyMap dkm = (DoubleKeyMap)super.clone();
        dkm.map = this.createGlobalMap();
        for (Map.Entry<K1, Map<K2, V>> me : this.map.entrySet()) {
            if (me.getValue().isEmpty()) continue;
            dkm.map.put(me.getKey(), new HashMap<K2, V>(me.getValue()));
        }
        dkm.cleanup = true;
        return dkm;
    }

    public boolean removeValue(K1 key1, V obj) {
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap != null) {
            return localMap.values().remove(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DoubleKeyMap && this.map.equals(((DoubleKeyMap)obj).map);
    }

    private Map<K2, V> createLocalMap() {
        try {
            return this.secondClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a zero-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a public zero-argument constructor", e);
        }
    }

    private Map<K1, Map<K2, V>> createGlobalMap() {
        try {
            return this.firstClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a zero-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a public zero-argument constructor", e);
        }
    }

    public Map<K2, V> getReadOnlyMapFor(K1 key1) {
        this.cleanup = false;
        Map<K2, V> localMap = this.map.get(key1);
        if (localMap == null) {
            localMap = this.createLocalMap();
            this.map.put(key1, localMap);
        }
        return Collections.unmodifiableMap(localMap);
    }
}

