/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CompsToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "COMPS";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        StringTokenizer aTok = new StringTokenizer(value, "|");
        boolean first = true;
        while (aTok.hasMoreTokens()) {
            String tok = aTok.nextToken();
            if (".CLEAR".equals(tok)) {
                if (!first) {
                    return new ParseResult.Fail("Non-sensical use of .CLEAR in " + this.getTokenName() + ": " + value, context);
                }
                context.getObjectContext().removeList((CDOMObject)spell, ListKey.COMPONENTS);
            } else {
                context.getObjectContext().addToList((CDOMObject)spell, ListKey.COMPONENTS, (Object)tok);
            }
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)spell, ListKey.COMPONENTS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collection added = changes.getAdded();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            sb.append(".CLEAR");
        }
        if (added != null && !added.isEmpty()) {
            if (globalClear) {
                sb.append("|");
            }
            sb.append(StringUtil.join((Collection)added, (String)"|"));
        }
        if (sb.length() == 0) {
            context.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return new String[]{sb.toString()};
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

