/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.ComputedCSS2Properties;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLFontElement;

public class HTMLFontElementImpl
extends HTMLAbstractUIElement
implements HTMLFontElement {
    public HTMLFontElementImpl(String name) {
        super(name);
    }

    public String getColor() {
        return this.getAttribute("color");
    }

    public String getFace() {
        return this.getAttribute("face");
    }

    public String getSize() {
        return this.getAttribute("size");
    }

    public void setColor(String color) {
        this.setAttribute("color", color);
    }

    public void setFace(String face) {
        this.setAttribute("face", face);
    }

    public void setSize(String size) {
        this.setAttribute("size", size);
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        return super.createRenderState(prevRenderState);
    }

    protected AbstractCSS2Properties createDefaultStyleSheet() {
        String fontFamily = this.getAttribute("face");
        String color = this.getAttribute("color");
        String size = this.getAttribute("size");
        String fontSize = null;
        if (size != null) {
            RenderState parentRS;
            ModelNode parentModelNode = this.getParentModelNode();
            RenderState renderState = parentRS = parentModelNode == null ? null : parentModelNode.getRenderState();
            if (parentRS != null) {
                int fontNumber = HtmlValues.getFontNumberOldStyle(size, parentRS);
                fontSize = HtmlValues.getFontSizeSpec(fontNumber);
            }
        }
        ComputedCSS2Properties css = new ComputedCSS2Properties(this);
        if (fontSize != null) {
            css.internalSetLC("font-size", fontSize);
        }
        if (fontFamily != null) {
            css.internalSetLC("font-family", fontFamily);
        }
        if (color != null) {
            css.internalSetLC("color", color);
        }
        return css;
    }
}

