/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MonskillToken
extends AbstractNonEmptyToken<PCClass>
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "MONSKILL";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PCClass pcc, String value) {
        BonusObj bon = Bonus.newBonus((LoadContext)context, (String)("MONSKILLPTS|NUMBER|" + value));
        if (bon == null) {
            return new ParseResult.Fail(this.getTokenName() + " was given invalid bonus value: " + value, context);
        }
        Prerequisite prereq = this.getPrerequisite("PRELEVELMAX:1");
        if (prereq == null) {
            return new ParseResult.Fail("Internal Error: " + this.getTokenName() + " had invalid prerequisite", context);
        }
        bon.addPrerequisite(prereq);
        bon.setTokenSource(this.getTokenName());
        context.getObjectContext().addToList((CDOMObject)pcc, ListKey.BONUS, (Object)bon);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass obj) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)obj, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection added = changes.getAdded();
        String tokenName = this.getTokenName();
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(bonus.getValue());
            ArrayList prereqList = new ArrayList(bonus.getPrerequisiteList());
            Prerequisite prereq = this.getPrerequisite("PRELEVELMAX:1");
            prereqList.remove(prereq);
            if (!prereqList.isEmpty()) {
                sb.append('|');
                sb.append(this.getPrerequisiteString(context, prereqList));
            }
            bonusSet.add(sb.toString());
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

