/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.eqsizepenalty;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.inst.EqSizePenalty;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class BonusToken
implements CDOMPrimaryToken<EqSizePenalty> {
    public String getTokenName() {
        return "BONUS";
    }

    public ParseResult parseToken(LoadContext context, EqSizePenalty esp, String value) {
        BonusObj bon = Bonus.newBonus((LoadContext)context, (String)value);
        if (bon == null) {
            return new ParseResult.Fail(this.getTokenName() + " was given invalid bonus: " + value, context);
        }
        bon.setTokenSource(this.getTokenName());
        esp.addBonus(bon);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, EqSizePenalty esp) {
        Collection added = esp.getBonuses();
        String tokenName = this.getTokenName();
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            bonusSet.add(bonus.toString());
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    public Class<EqSizePenalty> getTokenClass() {
        return EqSizePenalty.class;
    }
}

